/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.dries007.tfc.client.screen.TFCContainerScreen;
import net.dries007.tfc.client.screen.button.KnappingButton;
import net.dries007.tfc.common.container.KnappingContainer;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class KnappingScreen
extends TFCContainerScreen<KnappingContainer> {
    public static final ResourceLocation BACKGROUND = Helpers.identifier("textures/gui/knapping.png");
    public static final ResourceLocation CLAY = Helpers.identifier("textures/gui/knapping/clay_ball.png");
    public static final ResourceLocation CLAY_DISABLED = Helpers.identifier("textures/gui/knapping/clay_ball_disabled.png");
    public static final ResourceLocation FIRE_CLAY = Helpers.identifier("textures/gui/knapping/fire_clay.png");
    public static final ResourceLocation FIRE_CLAY_DISABLED = Helpers.identifier("textures/gui/knapping/fire_clay_disabled.png");
    public static final ResourceLocation LEATHER = Helpers.identifier("textures/gui/knapping/leather.png");
    private final ResourceLocation buttonLocation;
    @Nullable
    private final ResourceLocation buttonDisabledLocation;

    public static ResourceLocation getButtonLocation(Item item, boolean disabled) {
        ResourceLocation buttonAssetPath = item.getRegistryName();
        assert (buttonAssetPath != null);
        return Helpers.identifier("textures/gui/knapping/" + buttonAssetPath.m_135815_() + (disabled ? "_disabled" : "") + ".png");
    }

    public KnappingScreen(KnappingContainer container, Inventory inv, Component name) {
        super(container, inv, name, BACKGROUND);
        this.f_97727_ = 186;
        this.f_97731_ += 22;
        this.f_97729_ -= 2;
        this.buttonLocation = KnappingScreen.getButtonLocation(container.getOriginalStack().m_41720_(), false);
        this.buttonDisabledLocation = container.usesDisabledTexture() ? KnappingScreen.getButtonLocation(container.getOriginalStack().m_41720_(), true) : null;
    }

    protected void m_7856_() {
        super.m_7856_();
        for (int x = 0; x < 5; ++x) {
            for (int y = 0; y < 5; ++y) {
                int bx = (this.f_96543_ - this.getXSize()) / 2 + 12 + 16 * x;
                int by = (this.f_96544_ - this.getYSize()) / 2 + 12 + 16 * y;
                this.m_142416_((GuiEventListener)new KnappingButton(x + 5 * y, bx, by, 16, 16, this.buttonLocation, ((KnappingContainer)this.f_97732_).getSound()));
            }
        }
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        KnappingButton button;
        if (((KnappingContainer)this.f_97732_).requiresReset()) {
            for (Widget widget : this.f_169369_) {
                if (!(widget instanceof KnappingButton)) continue;
                button = (KnappingButton)widget;
                button.f_93624_ = ((KnappingContainer)this.f_97732_).getPattern().get(button.id);
            }
            ((KnappingContainer)this.f_97732_).setRequiresReset(false);
        }
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        for (Widget widget : this.f_169369_) {
            if (!(widget instanceof KnappingButton)) continue;
            button = (KnappingButton)widget;
            if (button.f_93624_) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)this.buttonLocation);
                KnappingScreen.m_93133_((PoseStack)poseStack, (int)button.f_93620_, (int)button.f_93621_, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                continue;
            }
            if (this.buttonDisabledLocation == null) continue;
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.buttonDisabledLocation);
            KnappingScreen.m_93133_((PoseStack)poseStack, (int)button.f_93620_, (int)button.f_93621_, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
    }

    public boolean m_7979_(double x, double y, int clickType, double dragX, double dragY) {
        if (clickType == 0) {
            this.m_6375_(x, y, clickType);
        }
        return super.m_7979_(x, y, clickType, dragX, dragY);
    }

    public boolean m_6375_(double x, double y, int clickType) {
        if (clickType == 0) {
            this.undoAccidentalButtonPress(x, y);
        }
        return super.m_6375_(x, y, clickType);
    }

    private void undoAccidentalButtonPress(double x, double y) {
        for (Widget widget : this.f_169369_) {
            KnappingButton button;
            if (!(widget instanceof KnappingButton) || !(button = (KnappingButton)widget).m_5953_(x, y)) continue;
            ((KnappingContainer)this.f_97732_).getPattern().set(button.id, false);
        }
    }
}

