/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import net.dries007.tfc.client.screen.BlockEntityScreen;
import net.dries007.tfc.common.blockentities.PotBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.heat.Heat;
import net.dries007.tfc.common.container.PotContainer;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.fluids.FluidStack;

public class PotScreen
extends BlockEntityScreen<PotBlockEntity, PotContainer> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("tfc", "textures/gui/fire_pit_cooking_pot.png");

    public PotScreen(PotContainer container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name, BACKGROUND);
        this.f_97731_ += 20;
        this.f_97727_ += 20;
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        super.m_7027_(poseStack, mouseX, mouseY);
        if (((PotBlockEntity)this.blockEntity).shouldRenderAsBoiling()) {
            this.drawDisabled(poseStack, 4, 8);
        }
        String text = ((PotBlockEntity)this.blockEntity).shouldRenderAsBoiling() ? I18n.m_118938_((String)"tfc.tooltip.pot_boiling", (Object[])new Object[0]) : (((PotBlockEntity)this.blockEntity).getOutput() != null && !((PotBlockEntity)this.blockEntity).getOutput().isEmpty() ? I18n.m_118938_((String)"tfc.tooltip.pot_finished", (Object[])new Object[0]) : I18n.m_118938_((String)"tfc.tooltip.pot_ready", (Object[])new Object[0]));
        int x = 118 - this.f_96547_.m_92895_(text) / 2;
        this.f_96547_.m_92883_(poseStack, text, (float)x, 56.0f, 0x404040);
    }

    protected void m_7025_(PoseStack poseStack, int mouseX, int mouseY) {
        FluidStack fluid;
        super.m_7025_(poseStack, mouseX, mouseY);
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        if (mouseX >= left + 54 && mouseY >= top + 48 && mouseX < left + 86 && mouseY < top + 74 && !(fluid = ((PotBlockEntity)this.blockEntity).getCapability(Capabilities.FLUID).map(c -> c.getFluidInTank(0)).orElse(FluidStack.EMPTY)).isEmpty()) {
            this.m_96602_(poseStack, (Component)Helpers.translatable("tfc.tooltip.fluid_units_and_capacity_of", fluid.getAmount(), 1000).m_7220_(fluid.getDisplayName()), mouseX, mouseY);
        }
    }

    @Override
    protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(poseStack, partialTicks, mouseX, mouseY);
        int temp = (int)(51.0f * ((PotBlockEntity)this.blockEntity).getTemperature() / Heat.maxVisibleTemperature());
        if (temp > 0) {
            this.m_93228_(poseStack, this.f_97735_ + 30, this.f_97736_ + 76 - Math.min(51, temp), 176, 0, 15, 5);
        }
    }
}

