/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.ArrayList;
import java.util.List;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.blocks.BloomBlock;
import net.dries007.tfc.common.blocks.MoltenBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.BloomeryBlock;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.common.recipes.BloomeryRecipe;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.inventory.BloomeryInventory;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class BloomeryBlockEntity
extends TickableInventoryBlockEntity<Inventory>
implements ICalendarTickable {
    private static final Component NAME = Helpers.translatable("tfc.block_entity.bloomery");
    protected final List<ItemStack> inputStacks;
    protected final List<ItemStack> catalystStacks;
    private long lastPlayerTick = Integer.MIN_VALUE;
    private long litTick;
    @Nullable
    protected BloomeryRecipe cachedRecipe;

    public static void serverTick(Level level, BlockPos pos, BlockState state, BloomeryBlockEntity bloomery) {
        bloomery.checkForLastTickSync();
        bloomery.checkForCalendarUpdate();
        if (level.m_46467_() % 20L == 0L) {
            boolean lit;
            if (((Boolean)state.m_61143_((Property)BloomeryBlock.LIT)).booleanValue() && bloomery.getRemainingTicks() <= 0L) {
                bloomery.completeRecipe();
                state = (BlockState)state.m_61124_((Property)BloomeryBlock.LIT, (Comparable)Boolean.valueOf(false));
            }
            Direction direction = (Direction)state.m_61143_((Property)BloomeryBlock.FACING);
            int capacity = bloomery.calculateCapacity();
            boolean modified = bloomery.inputStacks.size() > capacity || bloomery.catalystStacks.size() > capacity;
            bloomery.popItemsOffOverCapacity(bloomery.inputStacks, capacity);
            bloomery.popItemsOffOverCapacity(bloomery.catalystStacks, capacity);
            if (modified) {
                if (((Boolean)state.m_61143_((Property)BloomeryBlock.LIT)).booleanValue()) {
                    state = (BlockState)state.m_61124_((Property)BloomeryBlock.LIT, (Comparable)Boolean.valueOf(false));
                    level.m_46597_(pos, state);
                }
                if (!BloomeryBlock.canGateStayInPlace((LevelAccessor)level, pos, direction.m_122434_())) {
                    level.m_46961_(pos, true);
                    return;
                }
                bloomery.markForSync();
            }
            if (!(lit = ((Boolean)state.m_61143_((Property)BloomeryBlock.LIT)).booleanValue())) {
                bloomery.addItemsFromWorld(capacity);
            }
            MoltenBlock.manageMoltenBlockTower(level, bloomery.getInternalBlockPos(), lit, (Integer)TFCConfig.SERVER.bloomeryMaxChimneyHeight.get(), bloomery.inputStacks.size(), (Integer)TFCConfig.SERVER.bloomeryCapacity.get());
        }
    }

    public BloomeryBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.BLOOMERY.get(), pos, state, Inventory::new, NAME);
        this.inputStacks = new ArrayList<ItemStack>();
        this.catalystStacks = new ArrayList<ItemStack>();
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        Helpers.readItemStacksFromNbt(this.inputStacks, nbt.m_128437_("inputStacks", 10));
        Helpers.readItemStacksFromNbt(this.catalystStacks, nbt.m_128437_("catalystStacks", 10));
        this.litTick = nbt.m_128454_("litTick");
        this.lastPlayerTick = nbt.m_128454_("lastTick");
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inputStacks", (Tag)Helpers.writeItemStacksToNbt(this.inputStacks));
        nbt.m_128365_("catalystStacks", (Tag)Helpers.writeItemStacksToNbt(this.catalystStacks));
        nbt.m_128356_("litTick", this.litTick);
        nbt.m_128356_("lastTick", this.lastPlayerTick);
        super.m_183515_(nbt);
    }

    public long getRemainingTicks() {
        if (this.cachedRecipe != null) {
            return (long)this.cachedRecipe.getDuration() - (Calendars.SERVER.getTicks() - this.litTick);
        }
        return 0L;
    }

    public BlockPos getInternalBlockPos() {
        assert (this.f_58857_ != null);
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (state.m_61138_((Property)BloomeryBlock.FACING)) {
            return this.f_58858_.m_142300_(((Direction)state.m_61143_((Property)BloomeryBlock.FACING)).m_122424_());
        }
        return this.f_58858_;
    }

    public BlockPos getExternalBlock() {
        assert (this.f_58857_ != null);
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (state.m_61138_((Property)BloomeryBlock.FACING)) {
            return this.f_58858_.m_142300_((Direction)state.m_61143_((Property)BloomeryBlock.FACING));
        }
        return this.f_58858_;
    }

    public boolean light(BlockState state) {
        assert (this.f_58857_ != null);
        if (Helpers.isBlock(this.f_58857_.m_8055_(this.getInternalBlockPos()), (Block)TFCBlocks.MOLTEN.get()) && this.cachedRecipe != null && this.cachedRecipe.matches((BloomeryInventory)this.inventory, this.f_58857_)) {
            this.litTick = Calendars.get((LevelReader)this.f_58857_).getTicks();
            state = (BlockState)((BlockState)state.m_61124_((Property)BloomeryBlock.LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BloomeryBlock.OPEN, (Comparable)Boolean.valueOf(false));
            this.f_58857_.m_46597_(this.f_58858_, state);
            return true;
        }
        return false;
    }

    @Override
    public void ejectInventory() {
        this.dumpItems();
        this.destroyMolten();
    }

    @Override
    public void onCalendarUpdate(long ticks) {
        assert (this.f_58857_ != null);
        if (this.cachedRecipe == null) {
            this.updateCachedRecipe();
        }
        if (this.f_58857_.f_46443_ || this.cachedRecipe == null || !((Boolean)this.f_58857_.m_8055_(this.f_58858_).m_61143_((Property)BloomeryBlock.LIT)).booleanValue()) {
            return;
        }
        long finishTick = (long)this.cachedRecipe.getDuration() + this.litTick;
        if (finishTick <= Calendars.SERVER.getTicks()) {
            long offset = Calendars.SERVER.getTicks() - finishTick;
            Calendars.SERVER.runTransaction(offset, offset, this::completeRecipe);
        }
    }

    @Override
    @Deprecated
    public long getLastUpdateTick() {
        return this.lastPlayerTick;
    }

    @Override
    @Deprecated
    public void setLastUpdateTick(long tick) {
        this.lastPlayerTick = tick;
    }

    private void dumpItems() {
        assert (this.f_58857_ != null);
        BlockPos pos = this.getExternalBlock();
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        this.inputStacks.forEach(i -> Containers.m_18992_((Level)this.f_58857_, (double)x, (double)y, (double)z, (ItemStack)i));
        this.catalystStacks.forEach(i -> Containers.m_18992_((Level)this.f_58857_, (double)x, (double)y, (double)z, (ItemStack)i));
        this.cachedRecipe = null;
    }

    private void popItemsOffOverCapacity(List<ItemStack> items, int capacity) {
        assert (this.f_58857_ != null);
        while (items.size() > capacity) {
            Helpers.spawnItem(this.f_58857_, this.f_58858_, items.remove(items.size() - 1));
        }
    }

    private void addItemsFromWorld(int capacity) {
        assert (this.f_58857_ != null);
        this.updateCachedRecipe();
        if (this.cachedRecipe == null && !this.inputStacks.isEmpty()) {
            this.dumpItems();
            this.markForSync();
        }
        if (this.inputStacks.size() == capacity) {
            return;
        }
        BlockPos internalPos = this.getInternalBlockPos();
        List items = this.f_58857_.m_6443_(ItemEntity.class, new AABB(internalPos, internalPos.m_142082_(1, BloomeryBlock.getChimneyLevels(this.f_58857_, internalPos) + 1, 1)), EntitySelector.f_20402_);
        if (this.cachedRecipe == null) {
            for (ItemEntity entity : items) {
                ItemStack stack = entity.m_32055_();
                BloomeryRecipe recipe = BloomeryRecipe.get(this.f_58857_, stack);
                if (recipe == null) continue;
                this.cachedRecipe = recipe;
                this.markForSync();
                break;
            }
        }
        if (this.cachedRecipe != null) {
            ArrayList<ItemEntity> foundInputs = new ArrayList<ItemEntity>();
            ArrayList<ItemEntity> foundCatalysts = new ArrayList<ItemEntity>();
            int inputCount = 0;
            int catalystCount = 0;
            for (ItemEntity entity : items) {
                ItemStack stack = entity.m_32055_();
                if (this.cachedRecipe.matchesInput(stack)) {
                    foundInputs.add(entity);
                    inputCount += stack.m_41613_();
                    continue;
                }
                if (!this.cachedRecipe.matchesCatalyst(stack)) continue;
                foundCatalysts.add(entity);
                catalystCount += stack.m_41613_();
            }
            int totalInsertCapacity = Math.min(capacity - this.inputStacks.size(), Math.min(inputCount, catalystCount));
            Helpers.consumeItemsFromEntitiesIndividually(foundInputs, totalInsertCapacity, this.inputStacks::add);
            Helpers.consumeItemsFromEntitiesIndividually(foundCatalysts, totalInsertCapacity, this.catalystStacks::add);
            this.markForSync();
        }
    }

    private void destroyMolten() {
        assert (this.f_58857_ != null);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            MoltenBlock.removeMoltenBlockTower(this.f_58857_, this.f_58858_.m_142300_(direction), (Integer)TFCConfig.SERVER.bloomeryMaxChimneyHeight.get());
        }
    }

    private int calculateCapacity() {
        Direction direction;
        assert (this.f_58857_ != null);
        BlockPos pos = this.getInternalBlockPos();
        if (BloomeryBlock.isFormed(this.f_58857_, pos, direction = (Direction)this.m_58900_().m_61143_((Property)BloomeryBlock.FACING))) {
            return BloomeryBlock.getChimneyLevels(this.f_58857_, pos) * (Integer)TFCConfig.SERVER.bloomeryCapacity.get();
        }
        return 0;
    }

    private void completeRecipe() {
        assert (this.f_58857_ != null);
        if (this.cachedRecipe != null) {
            ItemStack result = this.cachedRecipe.assemble((BloomeryInventory)this.inventory);
            FluidStack inputFluid = ((Inventory)this.inventory).getFluid();
            if (!this.catalystStacks.isEmpty() && !inputFluid.isEmpty()) {
                int producedAmount = inputFluid.getAmount() / this.cachedRecipe.getInputFluid().amount();
                Metal metal = Metal.get(((Inventory)this.inventory).getFluid().getFluid());
                if (metal != null) {
                    result.getCapability(HeatCapability.CAPABILITY).ifPresent(cap -> cap.setTemperature(metal.getMeltTemperature() - 1.0f));
                }
                BlockPos pos = this.getInternalBlockPos();
                this.f_58857_.m_46597_(pos, (BlockState)((Block)TFCBlocks.BLOOM.get()).m_49966_().m_61124_((Property)BloomBlock.LAYERS, (Comparable)Integer.valueOf(8)));
                this.f_58857_.m_141902_(pos, (BlockEntityType)TFCBlockEntities.BLOOM.get()).ifPresent(bloom -> bloom.setBloom(result, producedAmount));
            }
        }
        this.inputStacks.clear();
        this.catalystStacks.clear();
        this.cachedRecipe = null;
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)BloomeryBlock.LIT, (Comparable)Boolean.valueOf(false)));
        this.destroyMolten();
    }

    private void updateCachedRecipe() {
        assert (this.f_58857_ != null);
        this.cachedRecipe = !this.inputStacks.isEmpty() ? BloomeryRecipe.get(this.f_58857_, this.inputStacks.get(0)) : null;
    }

    static class Inventory
    extends InventoryItemHandler
    implements BloomeryInventory {
        private final BloomeryBlockEntity bloomery;

        public Inventory(ISlotCallback callback) {
            super(callback, 0);
            this.bloomery = (BloomeryBlockEntity)callback;
        }

        @Override
        public FluidStack getFluid() {
            FluidStack fluid = FluidStack.EMPTY;
            for (ItemStack stack : this.bloomery.inputStacks) {
                FluidStack toAdd;
                ItemStackInventory inventory = new ItemStackInventory(stack);
                HeatingRecipe heatingRecipe = HeatingRecipe.getRecipe(inventory);
                if (heatingRecipe == null || (toAdd = heatingRecipe.assembleFluid(inventory)).isEmpty()) continue;
                if (fluid.isEmpty()) {
                    fluid = toAdd;
                    continue;
                }
                if (!fluid.isFluidEqual(toAdd)) continue;
                fluid.grow(toAdd.getAmount());
            }
            return fluid;
        }

        @Override
        public ItemStack getCatalyst() {
            return this.bloomery.catalystStacks.isEmpty() ? ItemStack.f_41583_ : this.bloomery.catalystStacks.get(0);
        }
    }
}

