/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.devices.TFCComposterBlock;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ComposterBlockEntity
extends TickCounterBlockEntity {
    private int green;
    private int brown;

    public ComposterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.COMPOSTER.get(), pos, state);
    }

    public ComposterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void randomTick() {
        if (this.green >= 4 && this.brown >= 4 & !this.isRotten()) {
            assert (this.f_58857_ != null);
            float rainfall = Climate.getRainfall(this.f_58857_, this.m_58899_());
            long readyTicks = ((Integer)TFCConfig.SERVER.composterTicks.get()).intValue();
            if (((Boolean)TFCConfig.SERVER.composterRainfallCheck.get()).booleanValue()) {
                if (rainfall < 150.0f) {
                    readyTicks *= (long)((150.0f - rainfall) / 50.0f + 1.0f);
                } else if (rainfall > 350.0f) {
                    readyTicks *= (long)((rainfall - 350.0f) / 50.0f + 1.0f);
                }
            }
            if (this.getTicksSinceUpdate() > readyTicks) {
                this.setState(TFCComposterBlock.CompostType.READY);
                this.markForSync();
            }
        }
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        this.green = nbt.m_128451_("green");
        this.brown = nbt.m_128451_("brown");
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("green", this.getGreen());
        nbt.m_128405_("brown", this.getBrown());
        super.m_183515_(nbt);
    }

    public InteractionResult use(ItemStack stack, Player player, boolean client) {
        assert (this.f_58857_ != null);
        boolean rotten = this.isRotten();
        BlockPos pos = this.m_58899_();
        if (player.m_142538_().equals((Object)pos)) {
            return InteractionResult.FAIL;
        }
        if (stack.m_41619_() && player.m_6144_()) {
            if (this.brown == 4 && this.green == 4 && this.isReady()) {
                Helpers.spawnItem(this.f_58857_, pos.m_7494_(), new ItemStack(rotten ? (ItemLike)TFCItems.ROTTEN_COMPOST.get() : (ItemLike)TFCItems.COMPOST.get()));
            }
            this.reset();
            Helpers.playSound(this.f_58857_, pos, SoundEvents.f_144206_);
            return this.finishUse(client);
        }
        if (rotten) {
            if (!client) {
                player.m_5661_((Component)Helpers.translatable("tfc.composter.rotten"), true);
            }
            return this.finishUse(client);
        }
        if (Helpers.isItem(stack, TFCTags.Items.COMPOST_POISONS)) {
            if (!client) {
                this.setState(TFCComposterBlock.CompostType.ROTTEN);
            }
            return this.finishUse(client);
        }
        if (this.green <= 4 && Helpers.isItem(stack, TFCTags.Items.COMPOST_GREENS)) {
            if (this.green == 4) {
                if (!client) {
                    player.m_5661_((Component)Helpers.translatable("tfc.composter.too_many_greens"), true);
                }
            } else {
                ++this.green;
                if (!client) {
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    Helpers.playSound(this.f_58857_, pos, SoundEvents.f_11955_);
                    this.resetCounter();
                }
            }
            return this.finishUse(client);
        }
        if (this.brown <= 4 && Helpers.isItem(stack, TFCTags.Items.COMPOST_BROWNS)) {
            if (this.brown == 4) {
                if (!client) {
                    player.m_5661_((Component)Helpers.translatable("tfc.composter.too_many_browns"), true);
                }
            } else {
                ++this.brown;
                if (!client) {
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    Helpers.playSound(this.f_58857_, pos, SoundEvents.f_11955_);
                    this.resetCounter();
                }
            }
            return this.finishUse(client);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult finishUse(boolean client) {
        if (!client) {
            this.setState(this.green + this.brown);
            this.markForSync();
        }
        return InteractionResult.m_19078_((boolean)client);
    }

    public int getGreen() {
        return this.green;
    }

    public int getBrown() {
        return this.brown;
    }

    public void reset() {
        this.brown = 0;
        this.green = 0;
        this.resetCounter();
        this.setState(TFCComposterBlock.CompostType.NORMAL, 0);
    }

    private boolean isRotten() {
        assert (this.f_58857_ != null);
        return this.f_58857_.m_8055_(this.m_58899_()).m_61143_(TFCComposterBlock.TYPE) == TFCComposterBlock.CompostType.ROTTEN;
    }

    private boolean isReady() {
        assert (this.f_58857_ != null);
        return this.f_58857_.m_8055_(this.m_58899_()).m_61143_(TFCComposterBlock.TYPE) == TFCComposterBlock.CompostType.READY;
    }

    private void setState(TFCComposterBlock.CompostType type) {
        assert (this.f_58857_ != null);
        this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_(TFCComposterBlock.TYPE, (Comparable)((Object)type)));
    }

    private void setState(TFCComposterBlock.CompostType type, int stage) {
        assert (this.f_58857_ != null);
        this.f_58857_.m_46597_(this.m_58899_(), (BlockState)((BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_(TFCComposterBlock.TYPE, (Comparable)((Object)type))).m_61124_((Property)TFCComposterBlock.STAGE, (Comparable)Integer.valueOf(stage)));
    }

    private void setState(int stage) {
        assert (this.f_58857_ != null);
        this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_((Property)TFCComposterBlock.STAGE, (Comparable)Integer.valueOf(stage)));
    }
}

