/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.List;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.util.Fertilizer;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class FarmlandBlockEntity
extends TFCBlockEntity {
    private float nitrogen = 0.0f;
    private float phosphorous = 0.0f;
    private float potassium = 0.0f;

    public FarmlandBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.FARMLAND.get(), pos, state);
    }

    protected FarmlandBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        this.nitrogen = nbt.m_128457_("n");
        this.phosphorous = nbt.m_128457_("p");
        this.potassium = nbt.m_128457_("k");
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128350_("n", this.nitrogen);
        nbt.m_128350_("p", this.phosphorous);
        nbt.m_128350_("k", this.potassium);
        super.m_183515_(nbt);
    }

    public boolean isMaxedOut() {
        return this.nitrogen == 1.0f && this.phosphorous == 1.0f && this.potassium == 1.0f;
    }

    public void addHoeOverlayInfo(Level level, BlockPos pos, List<Component> text, boolean includeHydration, boolean includeNutrients) {
        if (includeHydration) {
            int value = FarmlandBlock.getHydration((LevelAccessor)level, pos);
            TranslatableComponent hydration = Helpers.translatable("tfc.tooltip.farmland.hydration", value);
            text.add((Component)hydration);
        }
        if (includeNutrients) {
            text.add((Component)Helpers.translatable("tfc.tooltip.farmland.nutrients", this.format(this.nitrogen), this.format(this.phosphorous), this.format(this.potassium)));
        }
    }

    private String format(float value) {
        return String.format("%.2f", Float.valueOf(value * 100.0f));
    }

    public float consumeNutrientAndResupplyOthers(NutrientType type, float amount) {
        float startValue = this.getNutrient(type);
        float consumed = Math.min(startValue, amount);
        this.setNutrient(type, startValue - consumed);
        for (NutrientType other : NutrientType.VALUES) {
            if (other == type) continue;
            this.addNutrient(other, consumed * 0.16666667f);
        }
        return consumed;
    }

    public float getNutrient(NutrientType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NutrientType.NITROGEN -> this.nitrogen;
            case NutrientType.PHOSPHOROUS -> this.phosphorous;
            case NutrientType.POTASSIUM -> this.potassium;
        };
    }

    public void addNutrients(Fertilizer fertilizer) {
        this.nitrogen = Math.min(1.0f, this.nitrogen + fertilizer.getNitrogen());
        this.phosphorous = Math.min(1.0f, this.phosphorous + fertilizer.getPhosphorus());
        this.potassium = Math.min(1.0f, this.potassium + fertilizer.getPotassium());
        this.markForSync();
    }

    public void addNutrient(NutrientType type, float value) {
        this.setNutrient(type, this.getNutrient(type) + value);
    }

    public void setNutrient(NutrientType type, float value) {
        value = Mth.m_14036_((float)value, (float)0.0f, (float)1.0f);
        switch (type) {
            case NITROGEN: {
                this.nitrogen = value;
                break;
            }
            case PHOSPHOROUS: {
                this.phosphorous = value;
                break;
            }
            case POTASSIUM: {
                this.potassium = value;
            }
        }
        this.markForSync();
    }

    public static enum NutrientType {
        NITROGEN,
        PHOSPHOROUS,
        POTASSIUM;

        private static final NutrientType[] VALUES;

        static {
            VALUES = NutrientType.values();
        }
    }
}

