/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.container.FirepitContainer;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class FirepitBlockEntity
extends AbstractFirepitBlockEntity<ItemStackHandler> {
    public static final int SLOT_ITEM_INPUT = 4;
    public static final int SLOT_OUTPUT_1 = 5;
    public static final int SLOT_OUTPUT_2 = 6;
    private static final Component NAME = Helpers.translatable("tfc.block_entity.firepit");
    @Nullable
    protected HeatingRecipe cachedRecipe;

    public FirepitBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.FIREPIT.get(), pos, state, FirepitBlockEntity.defaultInventory(7), NAME);
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory playerInv, Player player) {
        return FirepitContainer.create(this, playerInv, windowID);
    }

    @Override
    protected void handleCooking() {
        if (this.temperature > 0.0f) {
            ItemStack inputStack = ((ItemStackHandler)this.inventory).getStackInSlot(4);
            inputStack.getCapability(HeatCapability.CAPABILITY).ifPresent(cap -> {
                float itemTemp = cap.getTemperature();
                HeatCapability.addTemp(cap, this.temperature);
                if (this.cachedRecipe != null && this.cachedRecipe.isValidTemperature(itemTemp)) {
                    HeatingRecipe recipe = this.cachedRecipe;
                    ItemStackInventory inventory = new ItemStackInventory(inputStack);
                    ((ItemStackHandler)this.inventory).setStackInSlot(4, ItemStack.f_41583_);
                    this.mergeOutputStack(recipe.assemble(inventory));
                    this.mergeOutputFluids(recipe.assembleFluid(inventory), cap.getTemperature());
                }
            });
        }
    }

    @Override
    protected void coolInstantly() {
        ((ItemStackHandler)this.inventory).getStackInSlot(4).getCapability(HeatCapability.CAPABILITY).ifPresent(cap -> cap.setTemperature(0.0f));
    }

    @Override
    protected void updateCachedRecipe() {
        assert (this.f_58857_ != null);
        this.cachedRecipe = HeatingRecipe.getRecipe(new ItemStackInventory(((ItemStackHandler)this.inventory).getStackInSlot(4)));
    }

    private void mergeOutputStack(ItemStack outputStack) {
        if ((outputStack = ((ItemStackHandler)this.inventory).insertItem(5, outputStack, false)).m_41619_()) {
            return;
        }
        if ((outputStack = ((ItemStackHandler)this.inventory).insertItem(6, outputStack, false)).m_41619_()) {
            return;
        }
        assert (this.f_58857_ != null);
        Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)outputStack);
    }

    private void mergeOutputFluids(FluidStack fluidStack, float temperature) {
        fluidStack = Helpers.mergeOutputFluidIntoSlot(this.inventory, fluidStack, temperature, 5);
        Helpers.mergeOutputFluidIntoSlot(this.inventory, fluidStack, temperature, 6);
    }
}

