/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.recipes.LoomRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class LoomBlockEntity
extends InventoryBlockEntity<ItemStackHandler> {
    private static final Component NAME = Helpers.translatable("tfc.block_entity.loom");
    private static final int SLOT_RECIPE = 0;
    private static final int SLOT_OUTPUT = 1;
    @Nullable
    private LoomRecipe recipe = null;
    @Nullable
    private ResourceLocation recipeId;
    private int progress = 0;
    private long lastPushed = 0L;
    private boolean needsProgressUpdate = false;
    private boolean needsRecipeUpdate = false;

    public static void tick(Level level, BlockPos pos, BlockState state, LoomBlockEntity loom) {
        if (loom.needsRecipeUpdate) {
            loom.updateCachedRecipe();
            loom.needsRecipeUpdate = false;
        }
        if (loom.recipe != null) {
            LoomRecipe recipe = loom.recipe;
            if (loom.needsProgressUpdate && level.m_46467_() - loom.lastPushed >= 20L) {
                loom.needsProgressUpdate = false;
                ++loom.progress;
                if (loom.progress == recipe.getStepCount()) {
                    ((ItemStackHandler)loom.inventory).setStackInSlot(0, ItemStack.f_41583_);
                    ((ItemStackHandler)loom.inventory).setStackInSlot(1, recipe.assemble(new ItemStackInventory(((ItemStackHandler)loom.inventory).getStackInSlot(0))));
                }
                loom.markForSync();
            }
        }
    }

    public LoomBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.LOOM.get(), pos, state, LoomBlockEntity.defaultInventory(2), NAME);
    }

    public InteractionResult onRightClick(Player player) {
        assert (this.f_58857_ != null);
        ItemStack heldItem = player.m_21205_();
        if (player.m_6144_()) {
            if (!((ItemStackHandler)this.inventory).getStackInSlot(0).m_41619_() && this.progress == 0) {
                if (heldItem.m_41619_() && !this.f_58857_.f_46443_) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)((ItemStackHandler)this.inventory).extractItem(0, 1, false));
                    if (((ItemStackHandler)this.inventory).getStackInSlot(0).m_41619_()) {
                        this.clearRecipe();
                    }
                    this.markForSync();
                }
                return InteractionResult.SUCCESS;
            }
        } else {
            if (((ItemStackHandler)this.inventory).getStackInSlot(0).m_41619_() && ((ItemStackHandler)this.inventory).getStackInSlot(1).m_41619_()) {
                LoomRecipe foundRecipe = LoomRecipe.getRecipe(this.f_58857_, new ItemStackInventory(heldItem));
                if (foundRecipe != null && !this.f_58857_.f_46443_) {
                    ((ItemStackHandler)this.inventory).setStackInSlot(0, heldItem.m_41620_(1));
                    this.recipeId = foundRecipe.m_6423_();
                    this.recipe = foundRecipe;
                    this.markForSync();
                }
                return InteractionResult.SUCCESS;
            }
            if (!((ItemStackHandler)this.inventory).getStackInSlot(0).m_41619_() && heldItem.m_41656_(((ItemStackHandler)this.inventory).getStackInSlot(0)) && this.recipe != null && this.recipe.getInputCount() > ((ItemStackHandler)this.inventory).getStackInSlot(0).m_41613_()) {
                if (!this.f_58857_.f_46443_) {
                    heldItem.m_41774_(1);
                    ((ItemStackHandler)this.inventory).getStackInSlot(0).m_41769_(1);
                    this.markForSync();
                }
                return InteractionResult.SUCCESS;
            }
            if (this.recipe != null && heldItem.m_41619_() && this.recipe.getInputCount() == ((ItemStackHandler)this.inventory).getStackInSlot(0).m_41613_() && this.progress < this.recipe.getStepCount() && !this.needsProgressUpdate) {
                long time = this.f_58857_.m_46467_() - this.lastPushed;
                if (time <= 20L) {
                    return InteractionResult.PASS;
                }
                this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)TFCSounds.LOOM_WEAVE.get(), SoundSource.BLOCKS, 1.0f, 1.0f + (this.f_58857_.f_46441_.nextFloat() - this.f_58857_.f_46441_.nextFloat()) / 16.0f);
                this.lastPushed = this.f_58857_.m_46467_();
                this.needsProgressUpdate = true;
                this.markForSync();
                return InteractionResult.m_19078_((boolean)this.f_58857_.f_46443_);
            }
            if (!((ItemStackHandler)this.inventory).getStackInSlot(1).m_41619_() && heldItem.m_41619_()) {
                if (!this.f_58857_.f_46443_) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)((ItemStackHandler)this.inventory).getStackInSlot(1).m_41777_());
                    ((ItemStackHandler)this.inventory).setStackInSlot(1, ItemStack.f_41583_);
                    this.markForSync();
                }
                this.progress = 0;
                this.clearRecipe();
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean currentBoolean() {
        return this.progress % 2 == 0;
    }

    public int getCount() {
        return ((ItemStackHandler)this.inventory).getStackInSlot(0).m_41613_();
    }

    public int getProgress() {
        return this.progress;
    }

    @Nullable
    public LoomRecipe getRecipe() {
        return this.recipe;
    }

    public double getAnimPos() {
        assert (this.f_58857_ != null);
        if (this.recipe == null) {
            return 0.0;
        }
        int time = (int)(this.f_58857_.m_46467_() - this.lastPushed);
        if (time < 20) {
            return Math.sin(0.15707963267948966 * (double)time) * 0.23125;
        }
        return 0.0;
    }

    private void clearRecipe() {
        this.recipe = null;
        this.recipeId = null;
        this.markForSync();
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("progress", this.progress);
        if (this.recipeId != null) {
            tag.m_128359_("recipe", this.recipeId.toString());
        }
        super.m_183515_(tag);
    }

    @Override
    public void loadAdditional(CompoundTag tag) {
        this.progress = tag.m_128451_("progress");
        this.recipeId = tag.m_128441_("recipe") ? new ResourceLocation(tag.m_128461_("recipe")) : null;
        this.updateCachedRecipe();
        super.loadAdditional(tag);
    }

    private void updateCachedRecipe() {
        this.recipe = null;
        if (this.f_58857_ == null) {
            this.needsRecipeUpdate = true;
        } else if (this.recipeId != null) {
            this.recipe = this.f_58857_.m_7465_().m_44043_(this.recipeId).map(r -> {
                LoomRecipe lr;
                return r instanceof LoomRecipe ? (lr = (LoomRecipe)r) : null;
            }).orElse(null);
        }
    }
}

