/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.PlacedItemBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.PitKilnBlock;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.ItemStackHandler;

public class PitKilnBlockEntity
extends PlacedItemBlockEntity {
    public static final Vec3i[] DIAGONALS = new Vec3i[]{new Vec3i(1, 0, 1), new Vec3i(-1, 0, 1), new Vec3i(1, 0, -1), new Vec3i(-1, 0, -1)};
    public static final int STRAW_NEEDED = 8;
    public static final int WOOD_NEEDED = 8;
    private final NonNullList<ItemStack> logItems = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> strawItems = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
    private final HeatingRecipe[] cachedRecipes = new HeatingRecipe[4];
    private long litTick;
    private boolean isLit;

    public static void serverTick(Level level, BlockPos pos, BlockState state, PitKilnBlockEntity pitKiln) {
        if (pitKiln.isLit) {
            BlockPos above = pos.m_7494_();
            if (level.m_46859_(above)) {
                level.m_46597_(above, Blocks.f_50083_.m_49966_());
            } else {
                BlockState stateAbove = level.m_8055_(above);
                if (stateAbove.m_60767_() != Material.f_76309_) {
                    pitKiln.emptyFuelContents();
                    PitKilnBlockEntity.convertPitKilnToPlacedItem(level, pos);
                    return;
                }
            }
            if (!PitKilnBlockEntity.isValid(level, pos)) {
                pitKiln.emptyFuelContents();
                PitKilnBlockEntity.convertPitKilnToPlacedItem(level, pos);
                return;
            }
            long remainingTicks = (long)((Integer)TFCConfig.SERVER.pitKilnTicks.get()).intValue() - (Calendars.SERVER.getTicks() - pitKiln.litTick);
            if (remainingTicks <= 0L) {
                pitKiln.updateCache();
            }
            pitKiln.cookContents();
            if (remainingTicks <= 0L) {
                pitKiln.emptyFuelContents();
                level.m_46597_(pos.m_7494_(), Blocks.f_50016_.m_49966_());
                pitKiln.markForBlockUpdate();
                PitKilnBlockEntity.convertPitKilnToPlacedItem(level, pos);
            }
        }
    }

    public static void convertPitKilnToPlacedItem(Level level, BlockPos pos) {
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.PIT_KILN.get()).ifPresent(pitKiln -> {
            NonNullList<ItemStack> items = Helpers.extractAllItems(pitKiln.inventory);
            level.m_7731_(pos, ((Block)TFCBlocks.PLACED_ITEM.get()).m_49966_(), 3);
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.PLACED_ITEM.get()).ifPresent(placedItem -> {
                Helpers.insertAllItems(placedItem.inventory, items);
                placedItem.isHoldingLargeItem = pitKiln.isHoldingLargeItem;
            });
        });
    }

    public static boolean isValid(Level level, BlockPos worldPosition) {
        for (Direction face : Direction.Plane.HORIZONTAL) {
            Direction opposite;
            BlockPos relativePos = worldPosition.m_142300_(face);
            BlockState relativeState = level.m_8055_(relativePos);
            if (relativeState.m_60783_((BlockGetter)level, relativePos, opposite = face.m_122424_()) && !relativeState.isFlammable((BlockGetter)level, relativePos, opposite)) continue;
            return false;
        }
        return level.m_8055_(worldPosition.m_7495_()).m_60783_((BlockGetter)level, worldPosition.m_7495_(), Direction.UP);
    }

    public PitKilnBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.PIT_KILN.get(), pos, state);
    }

    protected PitKilnBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        this.isLit = nbt.m_128471_("isLit");
        this.litTick = nbt.m_128454_("litTick");
        ContainerHelper.m_18980_((CompoundTag)nbt.m_128469_("strawItems"), this.strawItems);
        ContainerHelper.m_18980_((CompoundTag)nbt.m_128469_("logItems"), this.logItems);
        this.updateCache();
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128379_("isLit", this.isLit);
        nbt.m_128356_("litTick", this.litTick);
        nbt.m_128365_("strawItems", (Tag)ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), this.strawItems));
        nbt.m_128365_("logItems", (Tag)ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), this.logItems));
        super.m_183515_(nbt);
    }

    @Override
    public void ejectInventory() {
        assert (this.f_58857_ != null);
        super.ejectInventory();
        this.strawItems.forEach(stack -> Helpers.spawnItem(this.f_58857_, this.f_58858_, stack));
        this.logItems.forEach(stack -> Helpers.spawnItem(this.f_58857_, this.f_58858_, stack));
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, BlockHitResult hit) {
        if (state.m_61138_((Property)PitKilnBlock.STAGE) && (Integer)state.m_61143_((Property)PitKilnBlock.STAGE) > 0) {
            for (ItemStack item : this.logItems) {
                if (item.m_41619_()) continue;
                return item.m_41777_();
            }
            for (ItemStack item : this.strawItems) {
                if (item.m_41619_()) continue;
                return item.m_41777_();
            }
        }
        return super.getCloneItemStack(state, hit);
    }

    public void deleteStraw(int slot) {
        this.strawItems.set(slot, (Object)ItemStack.f_41583_);
    }

    public void deleteLog(int slot) {
        this.logItems.set(slot, (Object)ItemStack.f_41583_);
    }

    public boolean isLit() {
        return this.isLit;
    }

    public long getLitTick() {
        return this.litTick;
    }

    public boolean hasFuel() {
        return !this.logItems.stream().anyMatch(ItemStack::m_41619_) && !this.strawItems.stream().anyMatch(ItemStack::m_41619_);
    }

    public boolean tryLight() {
        BlockPos above;
        this.updateCache();
        if (this.hasFuel() && this.f_58857_ != null && PitKilnBlockEntity.isValid(this.f_58857_, this.f_58858_) && !this.isLit() && BaseFireBlock.m_49255_((Level)this.f_58857_, (BlockPos)(above = this.f_58858_.m_7494_()), (Direction)Direction.UP)) {
            for (Direction facing : Direction.Plane.HORIZONTAL) {
                if (this.f_58857_.m_8055_(this.f_58858_.m_142300_(facing)).m_60783_((BlockGetter)this.f_58857_, this.f_58858_.m_142300_(facing), facing.m_122424_())) continue;
                return false;
            }
            this.isLit = true;
            this.litTick = Calendars.SERVER.getTicks();
            this.markForBlockUpdate();
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)PitKilnBlock.STAGE, (Comparable)Integer.valueOf(16)));
            this.f_58857_.m_46597_(above, Blocks.f_50083_.m_49966_());
            for (Vec3i diagonal : DIAGONALS) {
                BlockPos pitPos = this.f_58858_.m_141952_(diagonal);
                this.f_58857_.m_141902_(pitPos, (BlockEntityType)TFCBlockEntities.PIT_KILN.get()).ifPresent(PitKilnBlockEntity::tryLight);
            }
            return true;
        }
        return false;
    }

    public void emptyFuelContents() {
        this.strawItems.clear();
        this.logItems.clear();
    }

    public void addStraw(ItemStack stack, int slot) {
        this.strawItems.set(slot, (Object)stack);
    }

    public void addLog(ItemStack stack, int slot) {
        this.logItems.set(slot, (Object)stack);
    }

    public NonNullList<ItemStack> getLogs() {
        return this.logItems;
    }

    public NonNullList<ItemStack> getStraws() {
        return this.strawItems;
    }

    private void cookContents() {
        assert (this.f_58857_ != null);
        float progress = Mth.m_184655_((float)Calendars.SERVER.getTicks(), (float)this.litTick, (float)(this.litTick + (long)((Integer)TFCConfig.SERVER.pitKilnTicks.get()).intValue()));
        float eagerProgress = Mth.m_14036_((float)(progress * 1.125f), (float)0.0f, (float)1.0f);
        float targetTemperature = Mth.m_14179_((float)eagerProgress, (float)0.0f, (float)((Integer)TFCConfig.SERVER.pitKilnTemperature.get()).intValue());
        int i = 0;
        while (i < ((ItemStackHandler)this.inventory).getSlots()) {
            ItemStack stack = ((ItemStackHandler)this.inventory).getStackInSlot(i);
            int slot = i++;
            stack.getCapability(HeatCapability.CAPABILITY).ifPresent(heat -> {
                heat.setTemperature(targetTemperature);
                HeatingRecipe recipe = this.cachedRecipes[slot];
                if (recipe != null && recipe.isValidTemperature(targetTemperature)) {
                    ItemStack out = recipe.assemble(new ItemStackInventory(stack));
                    ((ItemStackHandler)this.inventory).setStackInSlot(slot, out);
                }
            });
        }
    }

    private void updateCache() {
        if (this.f_58857_ == null) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            this.cachedRecipes[i] = HeatingRecipe.getRecipe(new ItemStackInventory(((ItemStackHandler)this.inventory).getStackInSlot(i)));
        }
    }
}

