/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.function.Predicate;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.DelegateFluidHandler;
import net.dries007.tfc.common.capabilities.DelegateItemHandler;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.capabilities.SidedHandler;
import net.dries007.tfc.common.container.PotContainer;
import net.dries007.tfc.common.recipes.PotRecipe;
import net.dries007.tfc.common.recipes.TFCRecipeTypes;
import net.dries007.tfc.common.recipes.inventory.EmptyInventory;
import net.dries007.tfc.util.Fuel;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PotBlockEntity
extends AbstractFirepitBlockEntity<PotInventory> {
    public static final int SLOT_EXTRA_INPUT_START = 4;
    public static final int SLOT_EXTRA_INPUT_END = 8;
    private static final Component NAME = Helpers.translatable("tfc.block_entity.pot");
    private final SidedHandler.Builder<IFluidHandler> sidedFluidInventory;
    @Nullable
    private PotRecipe.Output output = null;
    @Nullable
    private PotRecipe cachedRecipe = null;
    private int boilingTicks = 0;

    public PotBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.POT.get(), pos, state, PotInventory::new, NAME);
        this.sidedInventory.on(new PartialItemHandler(this.inventory).insert(3).extract(4, 5, 6, 7, 8), (Predicate<Direction>)Direction.Plane.HORIZONTAL).on(new PartialItemHandler(this.inventory).insert(4, 5, 6, 7, 8), Direction.UP);
        this.sidedFluidInventory = new SidedHandler.Builder<IFluidHandler>((IFluidHandler)this.inventory).on((IFluidHandler)this.inventory, (Predicate<Direction>)Direction.Plane.HORIZONTAL);
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        if (nbt.m_128441_("output")) {
            this.output = PotRecipe.Output.read(nbt.m_128469_("output"));
        }
        this.boilingTicks = nbt.m_128451_("boilingTicks");
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        if (this.output != null) {
            nbt.m_128365_("output", (Tag)PotRecipe.Output.write(this.output));
        }
        nbt.m_128405_("boilingTicks", this.boilingTicks);
        super.m_183515_(nbt);
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot == 3) {
            return Fuel.get(stack) != null;
        }
        return slot >= 4 && slot <= 8;
    }

    @Override
    protected void handleCooking() {
        if (this.isBoiling()) {
            assert (this.cachedRecipe != null);
            if (this.boilingTicks < this.cachedRecipe.getDuration()) {
                ++this.boilingTicks;
                if (this.boilingTicks == 1) {
                    this.markForSync();
                }
            } else {
                PotRecipe recipe = this.cachedRecipe;
                PotRecipe.Output output = recipe.getOutput((PotInventory)this.inventory);
                ((PotInventory)this.inventory).tank.setFluid(FluidStack.EMPTY);
                for (int slot = 4; slot <= 8; ++slot) {
                    ((PotInventory)this.inventory).setStackInSlot(slot, ((PotInventory)this.inventory).getStackInSlot(slot).getContainerItem());
                }
                output.onFinish((PotInventory)this.inventory);
                if (!output.isEmpty()) {
                    this.output = output;
                }
                this.cachedRecipe = null;
                this.boilingTicks = 0;
                this.updateCachedRecipe();
                this.markForSync();
            }
        } else if (this.boilingTicks > 0) {
            this.boilingTicks = 0;
            this.markForSync();
        }
    }

    @Override
    protected void coolInstantly() {
        this.boilingTicks = 0;
        this.markForSync();
    }

    @Override
    protected void updateCachedRecipe() {
        assert (this.f_58857_ != null);
        this.cachedRecipe = this.f_58857_.m_7465_().m_44015_((RecipeType)TFCRecipeTypes.POT.get(), (Container)((PotInventory)this.inventory), this.f_58857_).orElse(null);
    }

    public boolean isBoiling() {
        return this.cachedRecipe != null && this.output == null && this.cachedRecipe.isHotEnough(this.temperature);
    }

    public boolean shouldRenderAsBoiling() {
        return this.boilingTicks > 0;
    }

    public InteractionResult interactWithOutput(Player player, ItemStack stack) {
        if (this.output != null) {
            InteractionResult result = this.output.onInteract(this, player, stack);
            if (this.output.isEmpty()) {
                this.output = null;
                this.markForSync();
            }
            return result;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public PotRecipe.Output getOutput() {
        return this.output;
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.FLUID) {
            return this.sidedFluidInventory.getSidedHandler(side).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory playerInv, Player player) {
        return PotContainer.create(this, playerInv, windowID);
    }

    public static class PotInventory
    implements EmptyInventory,
    DelegateItemHandler,
    DelegateFluidHandler,
    INBTSerializable<CompoundTag> {
        private final PotBlockEntity pot;
        private final ItemStackHandler inventory;
        private final FluidTank tank;

        public PotInventory(InventoryBlockEntity<PotInventory> entity) {
            this.pot = (PotBlockEntity)entity;
            this.inventory = new InventoryItemHandler(entity, 9);
            this.tank = new FluidTank(1000, fluid -> Helpers.isFluid(fluid.getFluid(), TFCTags.Fluids.USABLE_IN_POT));
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.pot.isBoiling() && slot >= 4 ? ItemStack.f_41583_ : this.inventory.extractItem(slot, amount, simulate);
        }

        @Override
        public IFluidHandler getFluidHandler() {
            return this.tank;
        }

        @Override
        public IItemHandlerModifiable getItemHandler() {
            return this.inventory;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
            this.tank.readFromNBT(nbt.m_128469_("tank"));
        }
    }
}

