/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.recipes.QuernRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class QuernBlockEntity
extends InventoryBlockEntity<ItemStackHandler> {
    public static final int SLOT_HANDSTONE = 0;
    public static final int SLOT_INPUT = 1;
    public static final int SLOT_OUTPUT = 2;
    private static final Component NAME = Helpers.translatable("tfc.block_entity.quern");
    private int rotationTimer = 0;

    public static void serverTick(Level level, BlockPos pos, BlockState state, QuernBlockEntity quern) {
        if (quern.rotationTimer > 0) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack inputStack = ((ItemStackHandler)quern.inventory).getStackInSlot(1);
            if (!inputStack.m_41619_()) {
                QuernBlockEntity.sendParticle(serverLevel, pos, inputStack, 1);
            }
            --quern.rotationTimer;
            if (quern.rotationTimer == 0) {
                quern.finishGrinding();
                Helpers.playSound(level, pos, SoundEvents.f_11682_);
                ItemStack handstone = ((ItemStackHandler)quern.inventory).getStackInSlot(0);
                ItemStack undamagedHandstoneStack = handstone.m_41777_();
                Helpers.damageItem(handstone, 1);
                if (!quern.hasHandstone()) {
                    Helpers.playSound(level, pos, SoundEvents.f_12442_);
                    Helpers.playSound(level, pos, SoundEvents.f_12018_);
                    QuernBlockEntity.sendParticle(serverLevel, pos, undamagedHandstoneStack, 15);
                }
                quern.setAndUpdateSlots(0);
            }
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, QuernBlockEntity quern) {
        if (quern.rotationTimer > 0) {
            --quern.rotationTimer;
        }
    }

    private static void sendParticle(ServerLevel level, BlockPos pos, ItemStack item, int count) {
        level.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, item), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.875, (double)pos.m_123343_() + 0.5, count, (double)Helpers.triangle(level.f_46441_) / 2.0, level.f_46441_.nextDouble() / 4.0, (double)Helpers.triangle(level.f_46441_) / 2.0, (double)0.15f);
    }

    public QuernBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.QUERN.get(), pos, state, QuernBlockEntity.defaultInventory(3), NAME);
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return slot == 0 ? 1 : 64;
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return slot != 0 || Helpers.isItem(stack.m_41720_(), TFCTags.Items.HANDSTONE);
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        this.rotationTimer = nbt.m_128451_("rotationTimer");
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("rotationTimer", this.rotationTimer);
        super.m_183515_(nbt);
    }

    @Override
    public boolean canInteractWith(Player player) {
        return super.canInteractWith(player) && this.rotationTimer == 0;
    }

    public int getRotationTimer() {
        return this.rotationTimer;
    }

    public boolean isGrinding() {
        return this.rotationTimer > 0;
    }

    public boolean hasHandstone() {
        return !((ItemStackHandler)this.inventory).getStackInSlot(0).m_41619_();
    }

    public boolean startGrinding() {
        ItemStackInventory wrapper;
        QuernRecipe recipe;
        assert (this.f_58857_ != null);
        ItemStack inputStack = ((ItemStackHandler)this.inventory).getStackInSlot(1);
        if (!inputStack.m_41619_() && (recipe = QuernRecipe.getRecipe(this.f_58857_, wrapper = new ItemStackInventory(inputStack))) != null && recipe.matches(wrapper, this.f_58857_)) {
            this.rotationTimer = 90;
            this.markForSync();
            return true;
        }
        return false;
    }

    private void finishGrinding() {
        ItemStackInventory wrapper;
        QuernRecipe recipe;
        assert (this.f_58857_ != null);
        ItemStack inputStack = ((ItemStackHandler)this.inventory).getStackInSlot(1);
        if (!inputStack.m_41619_() && (recipe = QuernRecipe.getRecipe(this.f_58857_, wrapper = new ItemStackInventory(inputStack))) != null && recipe.matches(wrapper, this.f_58857_)) {
            inputStack.m_41774_(1);
            ItemStack outputStack = recipe.assemble(wrapper);
            outputStack = Helpers.mergeInsertStack((IItemHandler)this.inventory, 2, outputStack);
            if (!outputStack.m_41619_() && !this.f_58857_.f_46443_) {
                Helpers.spawnItem(this.f_58857_, this.f_58858_, outputStack);
            }
            this.markForSync();
        }
    }
}

