/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.recipes.ScrapingRecipe;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class ScrapingBlockEntity
extends InventoryBlockEntity<ItemStackHandler> {
    private static final Component NAME = Helpers.translatable("tfc.block_entity.scraping");
    private ItemStack cachedItem = ItemStack.f_41583_;
    private short positions = 0;

    public ScrapingBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.SCRAPING.get(), pos, state, ScrapingBlockEntity.defaultInventory(1), NAME);
        this.setCachedItem(ItemStack.f_41583_);
    }

    public boolean isComplete() {
        return this.positions == -1;
    }

    public short getScrapedPositions() {
        return this.positions;
    }

    public void onClicked(float hitX, float hitZ) {
        int xPos = (int)(hitX * 4.0f);
        int zPos = (int)(hitZ * 4.0f);
        this.positions = (short)(this.positions | 1 << xPos + zPos * 4);
        assert (this.f_58857_ != null);
        if (!this.f_58857_.f_46443_) {
            ItemStack currentItem;
            ScrapingRecipe recipe;
            if (this.isComplete() && (recipe = this.getRecipe(currentItem = ((ItemStackHandler)this.inventory).getStackInSlot(0))) != null) {
                ((ItemStackHandler)this.inventory).setStackInSlot(0, recipe.assemble(new ItemStackInventory(currentItem)));
            }
            this.markForBlockUpdate();
        }
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        return this.getRecipe(stack) != null;
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        super.loadAdditional(nbt);
        this.positions = nbt.m_128448_("positions");
        this.updateDisplayCache();
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128376_("positions", this.positions);
        super.m_183515_(nbt);
    }

    public ItemStack getCachedItem() {
        return this.cachedItem;
    }

    public void setCachedItem(ItemStack cachedItem) {
        this.cachedItem = cachedItem;
    }

    private void updateDisplayCache() {
        if (!this.isComplete()) {
            ItemStack stack = ((ItemStackHandler)this.inventory).getStackInSlot(0);
            ScrapingRecipe recipe = this.getRecipe(stack);
            this.setCachedItem(recipe == null ? ItemStack.f_41583_ : recipe.m_8043_().m_41777_());
        } else {
            this.setCachedItem(((ItemStackHandler)this.inventory).getStackInSlot(0));
        }
    }

    @Nullable
    private ScrapingRecipe getRecipe(ItemStack stack) {
        assert (this.f_58857_ != null);
        return ScrapingRecipe.getRecipe(this.f_58857_, new ItemStackInventory(stack));
    }
}

