/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import java.util.Arrays;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SheetPileBlockEntity
extends TFCBlockEntity {
    private final ItemStack[] stacks = new ItemStack[6];
    private final Metal[] cachedMetals = new Metal[6];

    public SheetPileBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.SHEET_PILE.get(), pos, state);
        Arrays.fill(this.stacks, ItemStack.f_41583_);
    }

    public void addSheet(Direction direction, ItemStack stack) {
        int index = direction.ordinal();
        this.stacks[index] = stack;
        this.cachedMetals[index] = null;
        this.markForSync();
    }

    public ItemStack removeSheet(Direction direction) {
        int index = direction.ordinal();
        ItemStack stack = this.stacks[index];
        this.stacks[index] = ItemStack.f_41583_;
        this.cachedMetals[index] = null;
        this.markForSync();
        return stack;
    }

    public ItemStack getSheet(Direction direction) {
        return this.stacks[direction.ordinal()].m_41777_();
    }

    public Metal getOrCacheMetal(Direction direction) {
        int index = direction.ordinal();
        ItemStack stack = this.stacks[index];
        Metal metal = this.cachedMetals[index];
        if (metal == null) {
            metal = Metal.getFromSheet(stack);
            if (metal == null) {
                metal = Metal.unknown();
            }
            this.cachedMetals[index] = metal;
        }
        return metal;
    }

    public void setAllMetalsFromOutsideWorld(Metal metal) {
        Arrays.fill(this.cachedMetals, metal);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("stacks", (Tag)Helpers.writeItemStacksToNbt(this.stacks));
        super.m_183515_(tag);
    }

    @Override
    protected void loadAdditional(CompoundTag tag) {
        Helpers.readItemStacksFromNbt(this.stacks, tag.m_128437_("stacks", 10));
        Arrays.fill(this.cachedMetals, null);
        super.loadAdditional(tag);
    }
}

