/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.devices.SluiceBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.items.PanItem;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class SluiceBlockEntity
extends InventoryBlockEntity<ItemStackHandler> {
    public static final int MAX_SOIL = 32;
    private static final Component NAME = Helpers.translatable("tfc.block_entity.sluice");
    private int ticksRemaining = 0;

    public static void serverTick(Level level, BlockPos pos, BlockState state, SluiceBlockEntity sluice) {
        if (!((Boolean)state.m_61143_((Property)SluiceBlock.UPPER)).booleanValue()) {
            return;
        }
        if (sluice.getFlow() != null && --sluice.ticksRemaining <= 0) {
            boolean itemUsed = false;
            for (ItemStack stack : Helpers.iterate((IItemHandler)sluice.inventory)) {
                Item item = stack.m_41720_();
                if (stack.m_41619_() || !(item instanceof BlockItem)) continue;
                BlockItem blockItem = (BlockItem)item;
                PanItem.dropItems((ServerLevel)level, blockItem.m_40614_().m_49966_(), sluice.getWaterOutputPos());
                stack.m_41764_(0);
                itemUsed = true;
                break;
            }
            if (itemUsed) {
                Helpers.playSound(level, sluice.m_58899_(), SoundEvents.f_12019_);
            }
            sluice.ticksRemaining = (Integer)TFCConfig.SERVER.sluiceTicks.get();
            sluice.markForSync();
        } else if (level.m_46467_() % 20L == 0L) {
            BlockPos outputPos;
            Fluid fluid = level.m_6425_(sluice.getWaterInputPos()).m_76152_();
            if (!fluid.m_6212_(Fluids.f_76191_) && Helpers.isFluid(fluid, TFCTags.Fluids.USABLE_IN_SLUICE) && level.m_8055_(outputPos = sluice.getWaterOutputPos()).m_60767_().m_76336_()) {
                FluidHelpers.setSourceBlock(level, outputPos, fluid);
            }
            for (ItemEntity entity2 : level.m_6443_(ItemEntity.class, new AABB(pos).m_82400_(1.0), entity -> !entity.m_146910_())) {
                BlockItem blockItem;
                Block block;
                ItemStack stack = entity2.m_32055_();
                Item item = stack.m_41720_();
                if (!(item instanceof BlockItem) || !Helpers.isBlock((block = (blockItem = (BlockItem)item).m_40614_()).m_49966_(), TFCTags.Blocks.CAN_BE_PANNED)) continue;
                boolean itemUsed = false;
                for (int slot = 0; slot < ((ItemStackHandler)sluice.inventory).getSlots(); ++slot) {
                    if (!((ItemStackHandler)sluice.inventory).getStackInSlot(slot).m_41619_()) continue;
                    ItemStack setStack = stack.m_41777_();
                    setStack.m_41764_(1);
                    ((ItemStackHandler)sluice.inventory).setStackInSlot(slot, setStack);
                    itemUsed = true;
                    break;
                }
                if (!itemUsed) continue;
                sluice.markForSync();
                stack.m_41774_(1);
                if (entity2.m_32055_().m_41613_() > 0) continue;
                entity2.m_142467_(Entity.RemovalReason.DISCARDED);
                break;
            }
        }
    }

    public SluiceBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.SLUICE.get(), pos, state, SluiceBlockEntity.defaultInventory(32), NAME);
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        this.ticksRemaining = nbt.m_128451_("ticksRemaining");
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128405_("ticksRemaining", this.ticksRemaining);
        super.m_183515_(nbt);
    }

    @Override
    public int getSlotStackLimit(int slot) {
        return 1;
    }

    public Direction getFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)SluiceBlock.FACING);
    }

    public BlockPos getWaterOutputPos() {
        return this.m_58899_().m_7495_().m_5484_(this.getFacing(), 2);
    }

    public BlockPos getWaterInputPos() {
        return this.m_58899_().m_7494_().m_142300_(this.getFacing().m_122424_());
    }

    @Nullable
    public Fluid getFlow() {
        assert (this.f_58857_ != null);
        FluidState inputState = this.f_58857_.m_6425_(this.getWaterInputPos());
        Fluid input = inputState.m_76152_();
        Fluid output = this.f_58857_.m_6425_(this.getWaterOutputPos()).m_76152_();
        if (inputState.m_61138_((Property)FlowingFluid.f_75948_) && (Integer)inputState.m_61143_((Property)FlowingFluid.f_75948_) == 1 && Helpers.isFluid(input, TFCTags.Fluids.USABLE_IN_SLUICE) && output.m_6212_(input)) {
            return input;
        }
        return null;
    }
}

