/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TickCounterBlockEntity
extends TFCBlockEntity {
    protected long lastUpdateTick = Integer.MIN_VALUE;

    public static void reset(Level level, BlockPos pos) {
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTER.get()).ifPresent(TickCounterBlockEntity::resetCounter);
    }

    public TickCounterBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TFCBlockEntities.TICK_COUNTER.get(), pos, state);
    }

    protected TickCounterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public long getTicksSinceUpdate() {
        return Calendars.SERVER.getTicks() - this.lastUpdateTick;
    }

    public void setLastUpdateTick(long tick) {
        this.lastUpdateTick = tick;
        this.m_6596_();
    }

    public long getLastUpdateTick() {
        return this.lastUpdateTick;
    }

    public void resetCounter() {
        this.lastUpdateTick = Calendars.SERVER.getTicks();
        this.m_6596_();
    }

    public void reduceCounter(long amount) {
        this.lastUpdateTick += amount;
        this.m_6596_();
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        this.lastUpdateTick = nbt.m_128454_("tick");
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128356_("tick", this.lastUpdateTick);
        super.m_183515_(nbt);
    }
}

