/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blockentities;

import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class ToolRackBlockEntity
extends InventoryBlockEntity<ItemStackHandler> {
    private static final Component NAME = Helpers.translatable("tfc.block_entity.tool_rack");

    public ToolRackBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFCBlockEntities.TOOL_RACK.get(), pos, state, ToolRackBlockEntity.defaultInventory(4), NAME);
    }

    public InteractionResult onRightClick(Player player, int slot) {
        boolean shouldInsert;
        assert (this.f_58857_ != null);
        ItemStack heldItem = player.m_21205_();
        boolean shouldExtract = !((ItemStackHandler)this.inventory).getStackInSlot(slot).m_41619_();
        boolean bl = shouldInsert = !heldItem.m_41619_() && this.isItemValid(slot, heldItem);
        if (shouldExtract) {
            if (shouldInsert) {
                if (!this.f_58857_.f_46443_) {
                    ItemStack extracted = ((ItemStackHandler)this.inventory).extractItem(slot, 1, false);
                    this.insertItem(slot, heldItem.m_41620_(1));
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)extracted, (int)player.m_150109_().f_35977_);
                    this.markForBlockUpdate();
                }
                return InteractionResult.SUCCESS;
            }
            if (!this.f_58857_.f_46443_) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)((ItemStackHandler)this.inventory).extractItem(slot, 1, false), (int)player.m_150109_().f_35977_);
                this.markForBlockUpdate();
            }
            return InteractionResult.SUCCESS;
        }
        if (shouldInsert) {
            if (!this.f_58857_.f_46443_) {
                this.insertItem(slot, heldItem.m_41620_(1));
                this.markForBlockUpdate();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean isItemValid(int i, ItemStack stack) {
        return Helpers.isItem(stack, TFCTags.Items.USABLE_ON_TOOL_RACK);
    }

    @Override
    public int getSlotStackLimit(int i) {
        return 1;
    }

    private void insertItem(int slot, ItemStack stack) {
        ((ItemStackHandler)this.inventory).insertItem(slot, stack, false);
        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)TFCSounds.TOOL_RACK_PLACE.get(), SoundSource.BLOCKS, 1.0f, 1.0f + (this.f_58857_.f_46441_.nextFloat() - this.f_58857_.f_46441_.nextFloat()) / 16.0f);
    }
}

