/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.GroundcoverBlockType;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroundcoverBlock
extends ExtendedBlock
implements IFluidLoggable {
    public static final FluidProperty FLUID = TFCBlockStateProperties.WATER;
    public static final VoxelShape FLAT = GroundcoverBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    public static final VoxelShape SMALL = GroundcoverBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0);
    public static final VoxelShape MEDIUM = GroundcoverBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0);
    public static final VoxelShape PIXEL_HIGH = GroundcoverBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    public static final VoxelShape TWIG = GroundcoverBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0);
    private final VoxelShape shape;
    @Nullable
    private final Supplier<? extends Item> pickBlock;

    public static GroundcoverBlock twig(ExtendedProperties properties) {
        return new GroundcoverBlock(properties.flammable(60, 30), TWIG, null);
    }

    public static GroundcoverBlock looseOre(BlockBehaviour.Properties properties) {
        return new GroundcoverBlock(ExtendedProperties.of(properties), SMALL, null);
    }

    public GroundcoverBlock(GroundcoverBlockType cover) {
        this(ExtendedProperties.of(Material.f_76315_).strength(0.05f, 0.0f).sound(SoundType.f_56761_).noCollission(), cover.getShape(), cover.getVanillaItem());
    }

    public GroundcoverBlock(ExtendedProperties properties, VoxelShape shape, @Nullable Supplier<? extends Item> pickBlock) {
        super(properties);
        this.shape = shape;
        this.pickBlock = pickBlock;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(Fluids.f_76191_)));
    }

    @NotNull
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        BlockState state = this.m_49966_();
        if (this.getFluidProperty().canContain(fluidState.m_76152_())) {
            return (BlockState)state.m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluidState.m_76152_()));
        }
        return state;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.getFluidProperty()});
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        return state.m_60710_((LevelReader)level, currentPos) ? super.m_7417_(state, facing, facingState, level, currentPos, facingPos) : state.m_60819_().m_76188_();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!player.m_7500_() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockEntity entity = state.m_155947_() ? level.m_7702_(pos) : null;
            GroundcoverBlock.m_49874_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)entity, null, (ItemStack)ItemStack.f_41583_).forEach(stackToSpawn -> ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stackToSpawn));
        }
        level.m_7471_(pos, false);
        return InteractionResult.SUCCESS;
    }

    public FluidState m_5888_(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos, Direction.UP);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shape;
    }

    @Override
    public FluidProperty getFluidProperty() {
        return FLUID;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return this.pickBlock != null ? new ItemStack((ItemLike)this.pickBlock.get()) : super.getCloneItemStack(state, target, level, pos, player);
    }
}

