/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.Random;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.Climate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.HitResult;

public class IcePileBlock
extends IceBlock
implements IForgeBlockExtension,
EntityBlockExtension {
    private final ExtendedProperties properties;

    public static void placeIcePileOrIce(LevelAccessor level, BlockPos groundPos, BlockState groundState, boolean skipEdgeCheck) {
        FluidState fluid = groundState.m_60819_();
        boolean icePileAtGround = Helpers.isBlock(groundState.m_60734_(), TFCTags.Blocks.CAN_BE_ICE_PILED);
        if (fluid.m_76152_() == Fluids.f_76193_ && (icePileAtGround || groundState.m_60734_() == Blocks.f_49990_) && (skipEdgeCheck || EnvironmentHelpers.isAdjacentToNotWater(level, groundPos))) {
            BlockPos surfacePos = groundPos.m_7494_();
            BlockState surfaceState = level.m_8055_(surfacePos);
            boolean icePileAtSurface = Helpers.isBlock(surfaceState.m_60734_(), TFCTags.Blocks.CAN_BE_ICE_PILED);
            if (icePileAtGround || icePileAtSurface) {
                BlockState savedGroundState = icePileAtGround ? groundState : Blocks.f_49990_.m_49966_();
                BlockState savedSurfaceState = icePileAtSurface ? surfaceState : null;
                level.m_7731_(groundPos, ((IcePileBlock)TFCBlocks.ICE_PILE.get()).m_49966_(), 18);
                level.m_141902_(groundPos, (BlockEntityType)TFCBlockEntities.PILE.get()).ifPresent(pile -> pile.setHiddenStates(savedGroundState, savedSurfaceState, false));
                if (icePileAtSurface) {
                    Helpers.removeBlock(level, surfacePos, 18);
                }
                level.m_6289_(groundPos, (Block)TFCBlocks.ICE_PILE.get());
                if (icePileAtSurface) {
                    level.m_6289_(surfacePos, Blocks.f_50016_);
                }
            } else {
                level.m_7731_(groundPos, Blocks.f_50126_.m_49966_(), 3);
            }
        }
    }

    public static void removeIcePileOrIce(LevelAccessor level, BlockPos pos, BlockState state) {
        boolean ultrawarm = level.m_6042_().m_63951_();
        Material material = level.m_8055_(pos.m_7495_()).m_60767_();
        if (!ultrawarm && (material.m_76334_() || material.m_76332_())) {
            if (state.m_60734_() == Blocks.f_50126_) {
                level.m_7731_(pos, Blocks.f_49990_.m_49966_(), 3);
            } else {
                level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.PILE.get()).ifPresent(pile -> {
                    if (!level.m_5776_()) {
                        level.m_7731_(pos, pile.getInternalState(), 18);
                        if (pile.getAboveState() != null) {
                            level.m_7731_(pos.m_7494_(), pile.getAboveState(), 18);
                        }
                        level.m_6289_(pos, pile.getInternalState().m_60734_());
                        level.m_186469_(pos, (Fluid)Fluids.f_76193_, 1);
                        if (pile.getAboveState() != null) {
                            level.m_6289_(pos.m_7494_(), pile.getAboveState().m_60734_());
                        }
                    }
                });
            }
        } else if (state.m_60734_() == Blocks.f_50126_ || state.m_60734_() == TFCBlocks.ICE_PILE.get()) {
            level.m_7471_(pos, false);
        }
    }

    public IcePileBlock(ExtendedProperties properties) {
        super(properties.properties());
        this.properties = properties;
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        this.m_5707_(level, pos, state, player);
        IcePileBlock.removeIcePileOrIce((LevelAccessor)level, pos, state);
        return false;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (level.m_5822_().nextInt(200) == 0 && Climate.getTemperature((Level)level, pos) > 2.0f) {
            IcePileBlock.removeIcePileOrIce((LevelAccessor)level, pos, state);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)Blocks.f_50126_);
    }

    public boolean m_6104_(BlockState state, BlockState otherState, Direction facing) {
        return Helpers.isBlock(otherState, Blocks.f_50126_) || super.m_6104_(state, otherState, facing);
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState state, BlockState neighborState, Direction dir) {
        return Helpers.isBlock(neighborState, Blocks.f_50126_);
    }
}

