/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.List;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.blockentities.LargeVesselBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.SealableDeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class LargeVesselBlock
extends SealableDeviceBlock {
    public static final VoxelShape OPENED_SHAPE = LargeVesselBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
    public static final VoxelShape CLOSED_SHAPE = Shapes.m_83124_((VoxelShape)OPENED_SHAPE, (VoxelShape[])new VoxelShape[]{LargeVesselBlock.m_49796_((double)2.5, (double)9.5, (double)2.5, (double)13.5, (double)11.0, (double)13.5), LargeVesselBlock.m_49796_((double)7.0, (double)11.0, (double)7.0, (double)9.0, (double)12.0, (double)9.0)});

    public static <T extends LargeVesselBlockEntity> void toggleSeal(Level level, BlockPos pos, BlockState state, BlockEntityType<T> type) {
        level.m_141902_(pos, type).ifPresent(barrel -> {
            boolean previousSealed = (Boolean)state.m_61143_((Property)SEALED);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SEALED, (Comparable)Boolean.valueOf(!previousSealed)));
            if (previousSealed) {
                barrel.onUnseal();
                Helpers.playSound(level, pos, (SoundEvent)TFCSounds.OPEN_VESSEL.get());
            } else {
                barrel.onSeal();
                Helpers.playSound(level, pos, (SoundEvent)TFCSounds.CLOSE_VESSEL.get());
            }
        });
    }

    public LargeVesselBlock(ExtendedProperties properties) {
        super(properties);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)SEALED) != false ? CLOSED_SHAPE : OPENED_SHAPE;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return this.m_7898_(state, (LevelReader)level, currentPos) ? super.m_7417_(state, facing, facingState, level, currentPos, facingPos) : Blocks.f_50016_.m_49966_();
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = level.m_8055_(belowPos);
        return !belowState.m_60795_() && belowState.m_60783_((BlockGetter)level, belowPos, Direction.UP) && super.m_7898_(state, level, pos);
    }

    @Override
    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null) {
            CompoundTag inventoryTag = tag.m_128469_("inventory");
            ItemStackHandler inventory = new ItemStackHandler();
            inventory.deserializeNBT(inventoryTag);
            if (!Helpers.isEmpty((IItemHandler)inventory)) {
                tooltip.add((Component)Helpers.translatable("tfc.tooltip.contents").m_130940_(ChatFormatting.DARK_GREEN));
                Helpers.addInventoryTooltipInfo((IItemHandler)inventory, tooltip);
            }
            this.addExtraInfo(tooltip, inventoryTag);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_6144_()) {
            LargeVesselBlock.toggleSeal(level, pos, state, this.getExtendedProperties().blockEntity());
        } else {
            level.m_141902_(pos, this.getExtendedProperties().blockEntity()).ifPresent(vessel -> {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)vessel, (BlockPos)pos);
                }
            });
        }
        return InteractionResult.SUCCESS;
    }
}

