/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCItemGroup;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.BellowsBlockEntity;
import net.dries007.tfc.common.blockentities.BlastFurnaceBlockEntity;
import net.dries007.tfc.common.blockentities.BloomeryBlockEntity;
import net.dries007.tfc.common.blockentities.BurningLogPileBlockEntity;
import net.dries007.tfc.common.blockentities.CharcoalForgeBlockEntity;
import net.dries007.tfc.common.blockentities.CrucibleBlockEntity;
import net.dries007.tfc.common.blockentities.DecayingBlockEntity;
import net.dries007.tfc.common.blockentities.NestBoxBlockEntity;
import net.dries007.tfc.common.blockentities.PitKilnBlockEntity;
import net.dries007.tfc.common.blockentities.PowderkegBlockEntity;
import net.dries007.tfc.common.blockentities.QuernBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.BloomBlock;
import net.dries007.tfc.common.blocks.CharcoalPileBlock;
import net.dries007.tfc.common.blocks.DeadTorchBlock;
import net.dries007.tfc.common.blocks.DeadWallTorchBlock;
import net.dries007.tfc.common.blocks.DecorationBlockRegistryObject;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.FluidCauldronBlock;
import net.dries007.tfc.common.blocks.GroundcoverBlock;
import net.dries007.tfc.common.blocks.GroundcoverBlockType;
import net.dries007.tfc.common.blocks.HotWaterBlock;
import net.dries007.tfc.common.blocks.IcePileBlock;
import net.dries007.tfc.common.blocks.IcicleBlock;
import net.dries007.tfc.common.blocks.LargeVesselBlock;
import net.dries007.tfc.common.blocks.MoltenBlock;
import net.dries007.tfc.common.blocks.OreDeposit;
import net.dries007.tfc.common.blocks.OreDepositBlock;
import net.dries007.tfc.common.blocks.RiverWaterBlock;
import net.dries007.tfc.common.blocks.SandstoneBlockType;
import net.dries007.tfc.common.blocks.SeaIceBlock;
import net.dries007.tfc.common.blocks.SnowPileBlock;
import net.dries007.tfc.common.blocks.StainedWattleBlock;
import net.dries007.tfc.common.blocks.TFCBubbleColumnBlock;
import net.dries007.tfc.common.blocks.TFCCandleBlock;
import net.dries007.tfc.common.blocks.TFCLightBlock;
import net.dries007.tfc.common.blocks.TFCMagmaBlock;
import net.dries007.tfc.common.blocks.TFCMaterials;
import net.dries007.tfc.common.blocks.TFCTorchBlock;
import net.dries007.tfc.common.blocks.TFCWallTorchBlock;
import net.dries007.tfc.common.blocks.ThatchBedBlock;
import net.dries007.tfc.common.blocks.ThatchBlock;
import net.dries007.tfc.common.blocks.ThinSpikeBlock;
import net.dries007.tfc.common.blocks.WattleBlock;
import net.dries007.tfc.common.blocks.crop.Crop;
import net.dries007.tfc.common.blocks.crop.DecayingBlock;
import net.dries007.tfc.common.blocks.crop.TFCPumpkinBlock;
import net.dries007.tfc.common.blocks.devices.BellowsBlock;
import net.dries007.tfc.common.blocks.devices.BlastFurnaceBlock;
import net.dries007.tfc.common.blocks.devices.BloomeryBlock;
import net.dries007.tfc.common.blocks.devices.BurningLogPileBlock;
import net.dries007.tfc.common.blocks.devices.CharcoalForgeBlock;
import net.dries007.tfc.common.blocks.devices.CrucibleBlock;
import net.dries007.tfc.common.blocks.devices.FirepitBlock;
import net.dries007.tfc.common.blocks.devices.GrillBlock;
import net.dries007.tfc.common.blocks.devices.IngotPileBlock;
import net.dries007.tfc.common.blocks.devices.JackOLanternBlock;
import net.dries007.tfc.common.blocks.devices.LogPileBlock;
import net.dries007.tfc.common.blocks.devices.NestBoxBlock;
import net.dries007.tfc.common.blocks.devices.PitKilnBlock;
import net.dries007.tfc.common.blocks.devices.PlacedItemBlock;
import net.dries007.tfc.common.blocks.devices.PotBlock;
import net.dries007.tfc.common.blocks.devices.PowderkegBlock;
import net.dries007.tfc.common.blocks.devices.QuernBlock;
import net.dries007.tfc.common.blocks.devices.ScrapingBlock;
import net.dries007.tfc.common.blocks.devices.SheetPileBlock;
import net.dries007.tfc.common.blocks.devices.TFCComposterBlock;
import net.dries007.tfc.common.blocks.plant.Plant;
import net.dries007.tfc.common.blocks.plant.coral.Coral;
import net.dries007.tfc.common.blocks.plant.coral.TFCSeaPickleBlock;
import net.dries007.tfc.common.blocks.plant.fruit.DeadBananaPlantBlock;
import net.dries007.tfc.common.blocks.plant.fruit.DeadBerryBushBlock;
import net.dries007.tfc.common.blocks.plant.fruit.DeadCaneBlock;
import net.dries007.tfc.common.blocks.plant.fruit.FruitBlocks;
import net.dries007.tfc.common.blocks.rock.Ore;
import net.dries007.tfc.common.blocks.rock.Rock;
import net.dries007.tfc.common.blocks.rock.RockAnvilBlock;
import net.dries007.tfc.common.blocks.rock.RockCategory;
import net.dries007.tfc.common.blocks.soil.ConnectedGrassBlock;
import net.dries007.tfc.common.blocks.soil.SandBlockType;
import net.dries007.tfc.common.blocks.soil.SoilBlockType;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.common.fluids.Alcohol;
import net.dries007.tfc.common.fluids.FluidType;
import net.dries007.tfc.common.fluids.SimpleFluid;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.registry.RegistrationHelpers;
import net.dries007.tfc.util.registry.RegistryMetal;
import net.dries007.tfc.util.registry.RegistryRock;
import net.dries007.tfc.util.registry.RegistrySoilVariant;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.GravelBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public final class TFCBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"tfc");
    public static final Map<SoilBlockType, Map<SoilBlockType.Variant, RegistryObject<Block>>> SOIL = Helpers.mapOfKeys(SoilBlockType.class, type -> Helpers.mapOfKeys(SoilBlockType.Variant.class, variant -> TFCBlocks.register(type.name() + "/" + variant.name(), () -> type.create((RegistrySoilVariant)variant), type == SoilBlockType.MUD_BRICKS ? TFCItemGroup.DECORATIONS : TFCItemGroup.EARTH)));
    public static final Map<SoilBlockType.Variant, DecorationBlockRegistryObject> MUD_BRICK_DECORATIONS = Helpers.mapOfKeys(SoilBlockType.Variant.class, variant -> new DecorationBlockRegistryObject(TFCBlocks.register("mud_bricks/" + variant.name() + "_slab", () -> new SlabBlock(SoilBlockType.mudProperties()), TFCItemGroup.DECORATIONS), TFCBlocks.register("mud_bricks/" + variant.name() + "_stairs", () -> new StairBlock(() -> ((Block)SOIL.get((Object)SoilBlockType.MUD_BRICKS).get(variant).get()).m_49966_(), SoilBlockType.mudProperties()), TFCItemGroup.DECORATIONS), TFCBlocks.register("mud_bricks/" + variant.name() + "_wall", () -> new WallBlock(SoilBlockType.mudProperties()), TFCItemGroup.DECORATIONS)));
    public static final RegistryObject<Block> PEAT = TFCBlocks.register("peat", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76314_, (MaterialColor)MaterialColor.f_76388_).m_60978_(3.0f).m_60918_((SoundType)TFCSounds.PEAT)), TFCItemGroup.EARTH);
    public static final RegistryObject<Block> PEAT_GRASS = TFCBlocks.register("peat_grass", () -> new ConnectedGrassBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76315_).m_60977_().m_60978_(3.0f).m_60918_((SoundType)TFCSounds.PEAT), (Supplier<? extends Block>)PEAT, null, null), TFCItemGroup.EARTH);
    public static final Map<SandBlockType, RegistryObject<Block>> SAND = Helpers.mapOfKeys(SandBlockType.class, type -> TFCBlocks.register("sand/" + type.name(), type::create, TFCItemGroup.EARTH));
    public static final Map<SandBlockType, Map<SandstoneBlockType, RegistryObject<Block>>> SANDSTONE = Helpers.mapOfKeys(SandBlockType.class, color -> Helpers.mapOfKeys(SandstoneBlockType.class, type -> TFCBlocks.register(type.name() + "_sandstone/" + color.name(), () -> new Block(type.properties((SandBlockType)((Object)color))), TFCItemGroup.DECORATIONS)));
    public static final Map<SandBlockType, Map<SandstoneBlockType, DecorationBlockRegistryObject>> SANDSTONE_DECORATIONS = Helpers.mapOfKeys(SandBlockType.class, color -> Helpers.mapOfKeys(SandstoneBlockType.class, type -> new DecorationBlockRegistryObject(TFCBlocks.register(type.name() + "_sandstone/" + color.name() + "_slab", () -> new SlabBlock(type.properties((SandBlockType)((Object)color))), TFCItemGroup.DECORATIONS), TFCBlocks.register(type.name() + "_sandstone/" + color.name() + "_stairs", () -> new StairBlock(() -> ((Block)SANDSTONE.get(color).get(type).get()).m_49966_(), type.properties((SandBlockType)((Object)color))), TFCItemGroup.DECORATIONS), TFCBlocks.register(type.name() + "_sandstone/" + color.name() + "_wall", () -> new WallBlock(type.properties((SandBlockType)((Object)color))), TFCItemGroup.DECORATIONS))));
    public static final Map<GroundcoverBlockType, RegistryObject<Block>> GROUNDCOVER = Helpers.mapOfKeys(GroundcoverBlockType.class, type -> TFCBlocks.register("groundcover/" + type.name(), () -> new GroundcoverBlock((GroundcoverBlockType)((Object)type)), type.createBlockItem()));
    public static final RegistryObject<Block> SEA_ICE = TFCBlocks.register("sea_ice", () -> new SeaIceBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76276_).m_60911_(0.98f).m_60977_().m_60978_(0.5f).m_60918_(SoundType.f_56744_).m_60955_().m_60922_(TFCBlocks::onlyColdMobs)), TFCItemGroup.EARTH);
    public static final RegistryObject<SnowPileBlock> SNOW_PILE = TFCBlocks.register("snow_pile", () -> new SnowPileBlock(ExtendedProperties.of((BlockBehaviour)Blocks.f_50125_).randomTicks().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.PILE)), TFCItemGroup.EARTH);
    public static final RegistryObject<IcePileBlock> ICE_PILE = TFCBlocks.register("ice_pile", () -> new IcePileBlock(ExtendedProperties.of((BlockBehaviour)Blocks.f_50126_).randomTicks().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.PILE)), TFCItemGroup.EARTH);
    public static final RegistryObject<ThinSpikeBlock> ICICLE = TFCBlocks.register("icicle", () -> new IcicleBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76276_).m_60993_().m_60978_(0.4f).m_60918_(SoundType.f_56744_).m_60955_().m_60977_()), TFCItemGroup.EARTH);
    public static final RegistryObject<ThinSpikeBlock> CALCITE = TFCBlocks.register("calcite", () -> new ThinSpikeBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60993_().m_60978_(0.2f).m_60918_((SoundType)TFCSounds.THIN)), TFCItemGroup.EARTH);
    public static final Map<Rock, Map<Ore, RegistryObject<Block>>> ORES = Helpers.mapOfKeys(Rock.class, rock -> Helpers.mapOfKeys(Ore.class, ore -> !ore.isGraded(), ore -> TFCBlocks.register("ore/" + ore.name() + "/" + rock.name(), ore::create, TFCItemGroup.ORES)));
    public static final Map<Rock, Map<Ore, Map<Ore.Grade, RegistryObject<Block>>>> GRADED_ORES = Helpers.mapOfKeys(Rock.class, rock -> Helpers.mapOfKeys(Ore.class, Ore::isGraded, ore -> Helpers.mapOfKeys(Ore.Grade.class, grade -> TFCBlocks.register("ore/" + grade.name() + "_" + ore.name() + "/" + rock.name(), ore::create, TFCItemGroup.ORES))));
    public static final Map<Ore, RegistryObject<Block>> SMALL_ORES = Helpers.mapOfKeys(Ore.class, Ore::isGraded, type -> TFCBlocks.register("ore/small_" + type.name(), () -> GroundcoverBlock.looseOre(BlockBehaviour.Properties.m_60939_((Material)Material.f_76315_).m_60913_(0.05f, 0.0f).m_60918_(SoundType.f_56723_).m_60910_()), TFCItemGroup.ORES));
    public static final Map<Rock, Map<OreDeposit, RegistryObject<Block>>> ORE_DEPOSITS = Helpers.mapOfKeys(Rock.class, rock -> Helpers.mapOfKeys(OreDeposit.class, ore -> TFCBlocks.register("deposit/" + ore.name() + "/" + rock.name(), () -> new OreDepositBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76317_, (MaterialColor)MaterialColor.f_76409_).m_60918_(SoundType.f_56739_).m_60978_(0.8f), (Rock)rock, (OreDeposit)((Object)((Object)ore))), TFCItemGroup.ORES)));
    public static final Map<Rock, Map<Rock.BlockType, RegistryObject<Block>>> ROCK_BLOCKS = Helpers.mapOfKeys(Rock.class, rock -> Helpers.mapOfKeys(Rock.BlockType.class, type -> TFCBlocks.register("rock/" + type.name() + "/" + rock.name(), () -> type.create((RegistryRock)rock), TFCItemGroup.ROCK_STUFFS)));
    public static final Map<Rock, Map<Rock.BlockType, DecorationBlockRegistryObject>> ROCK_DECORATIONS = Helpers.mapOfKeys(Rock.class, rock -> Helpers.mapOfKeys(Rock.BlockType.class, Rock.BlockType::hasVariants, type -> new DecorationBlockRegistryObject(TFCBlocks.register("rock/" + type.name() + "/" + rock.name() + "_slab", () -> type.createSlab((RegistryRock)rock), TFCItemGroup.ROCK_STUFFS), TFCBlocks.register("rock/" + type.name() + "/" + rock.name() + "_stairs", () -> type.createStairs((RegistryRock)rock), TFCItemGroup.ROCK_STUFFS), TFCBlocks.register("rock/" + type.name() + "/" + rock.name() + "_wall", () -> type.createWall((RegistryRock)rock), TFCItemGroup.ROCK_STUFFS))));
    public static final Map<Rock, RegistryObject<Block>> ROCK_ANVILS = Helpers.mapOfKeys(Rock.class, rock -> rock.category() == RockCategory.IGNEOUS_EXTRUSIVE || rock.category() == RockCategory.IGNEOUS_INTRUSIVE, rock -> TFCBlocks.register("rock/anvil/" + rock.name(), () -> new RockAnvilBlock(ExtendedProperties.of(Material.f_76278_).sound(SoundType.f_56742_).strength(2.0f, 10.0f).requiresCorrectToolForDrops().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.ANVIL), (Supplier)ROCK_BLOCKS.get(rock).get((Object)Rock.BlockType.RAW)), TFCItemGroup.ROCK_STUFFS));
    public static final Map<Rock, RegistryObject<Block>> MAGMA_BLOCKS = Helpers.mapOfKeys(Rock.class, rock -> rock.category() == RockCategory.IGNEOUS_EXTRUSIVE || rock.category() == RockCategory.IGNEOUS_INTRUSIVE, rock -> TFCBlocks.register("rock/magma/" + rock.name(), () -> new TFCMagmaBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76371_).m_60999_().m_60953_(s -> 6).m_60977_().m_60978_(0.5f).m_60922_((state, level, pos, type) -> type.m_20672_()).m_60982_(TFCBlocks::always)), TFCItemGroup.ROCK_STUFFS));
    public static final Map<Metal.Default, Map<Metal.BlockType, RegistryObject<Block>>> METALS = Helpers.mapOfKeys(Metal.Default.class, metal -> Helpers.mapOfKeys(Metal.BlockType.class, type -> type.has((Metal.Default)metal), type -> TFCBlocks.register("metal/" + type.name() + "/" + metal.name(), type.create((RegistryMetal)metal), type.createBlockItem(new Item.Properties().m_41491_(TFCItemGroup.METAL)))));
    public static final Map<FluidType, RegistryObject<FluidCauldronBlock>> CAULDRONS = FluidType.mapOf(fluid -> TFCBlocks.register("cauldron/" + fluid.name(), () -> new FluidCauldronBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50256_))));
    public static final Map<Wood, Map<Wood.BlockType, RegistryObject<Block>>> WOODS = Helpers.mapOfKeys(Wood.class, wood -> Helpers.mapOfKeys(Wood.BlockType.class, type -> TFCBlocks.register(type.nameFor((RegistryWood)wood), type.create((RegistryWood)wood), type.createBlockItem(new Item.Properties().m_41491_(TFCItemGroup.WOOD)))));
    public static final Map<Plant, RegistryObject<Block>> PLANTS = Helpers.mapOfKeys(Plant.class, plant -> TFCBlocks.register("plant/" + plant.name(), plant::create, plant.createBlockItem(new Item.Properties().m_41491_(TFCItemGroup.FLORA))));
    public static final Map<Crop, RegistryObject<Block>> CROPS = Helpers.mapOfKeys(Crop.class, crop -> TFCBlocks.register("crop/" + crop.name(), crop::create));
    public static final Map<Crop, RegistryObject<Block>> DEAD_CROPS = Helpers.mapOfKeys(Crop.class, crop -> TFCBlocks.register("dead_crop/" + crop.name(), crop::createDead));
    public static final Map<Crop, RegistryObject<Block>> WILD_CROPS = Helpers.mapOfKeys(Crop.class, crop -> TFCBlocks.register("wild_crop/" + crop.name(), crop::createWild, TFCItemGroup.FLORA));
    public static final Map<Coral, Map<Coral.BlockType, RegistryObject<Block>>> CORAL = Helpers.mapOfKeys(Coral.class, color -> Helpers.mapOfKeys(Coral.BlockType.class, type -> TFCBlocks.register("coral/" + color.toString() + "_" + type.toString(), type.create((Coral)((Object)color)), type.createBlockItem(new Item.Properties().m_41491_(TFCItemGroup.FLORA)))));
    public static final RegistryObject<Block> ROTTEN_PUMPKIN = TFCBlocks.register("rotten_pumpkin", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76285_, (MaterialColor)MaterialColor.f_76413_).m_60978_(1.0f).m_60918_(SoundType.f_56736_)), TFCItemGroup.FLORA);
    public static final RegistryObject<Block> ROTTEN_MELON = TFCBlocks.register("rotten_melon", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76285_, (MaterialColor)MaterialColor.f_76363_).m_60978_(1.0f).m_60918_(SoundType.f_56736_)), TFCItemGroup.FLORA);
    public static final RegistryObject<Block> PUMPKIN = TFCBlocks.register("pumpkin", () -> new TFCPumpkinBlock(ExtendedProperties.of(Material.f_76285_, MaterialColor.f_76413_).strength(1.0f).sound(SoundType.f_56736_).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.DECAYING).serverTicks(DecayingBlockEntity::serverTick), (Supplier<? extends Block>)ROTTEN_PUMPKIN), TFCItemGroup.FLORA);
    public static final RegistryObject<Block> MELON = TFCBlocks.register("melon", () -> new DecayingBlock(ExtendedProperties.of(Material.f_76285_, MaterialColor.f_76363_).strength(1.0f).sound(SoundType.f_56736_).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.DECAYING).serverTicks(DecayingBlockEntity::serverTick), (Supplier<? extends Block>)ROTTEN_MELON), TFCItemGroup.FLORA);
    public static final RegistryObject<Block> SEA_PICKLE = TFCBlocks.register("sea_pickle", () -> new TFCSeaPickleBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76301_, (MaterialColor)MaterialColor.f_76363_).m_60953_(state -> TFCSeaPickleBlock.isDead(state) ? 0 : 3 + 3 * (Integer)state.m_61143_((Property)SeaPickleBlock.f_56074_)).m_60918_(SoundType.f_56750_).m_60955_()), TFCItemGroup.FLORA);
    public static final Map<FruitBlocks.StationaryBush, RegistryObject<Block>> STATIONARY_BUSHES = Helpers.mapOfKeys(FruitBlocks.StationaryBush.class, bush -> TFCBlocks.register("plant/" + bush.name() + "_bush", bush::create, TFCItemGroup.FLORA));
    public static final Map<FruitBlocks.SpreadingBush, RegistryObject<Block>> SPREADING_CANES = Helpers.mapOfKeys(FruitBlocks.SpreadingBush.class, bush -> TFCBlocks.register("plant/" + bush.name() + "_bush_cane", bush::createCane));
    public static final Map<FruitBlocks.SpreadingBush, RegistryObject<Block>> SPREADING_BUSHES = Helpers.mapOfKeys(FruitBlocks.SpreadingBush.class, bush -> TFCBlocks.register("plant/" + bush.name() + "_bush", bush::createBush, TFCItemGroup.FLORA));
    public static final RegistryObject<Block> CRANBERRY_BUSH = TFCBlocks.register("plant/cranberry_bush", FruitBlocks::createCranberry, TFCItemGroup.FLORA);
    public static final RegistryObject<Block> DEAD_BERRY_BUSH = TFCBlocks.register("plant/dead_berry_bush", () -> new DeadBerryBushBlock(ExtendedProperties.of(Material.f_76274_).strength(0.6f).noOcclusion().sound(SoundType.f_56757_).randomTicks().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.TICK_COUNTER).flammable(120, 90)));
    public static final RegistryObject<Block> DEAD_BANANA_PLANT = TFCBlocks.register("plant/dead_banana_plant", () -> new DeadBananaPlantBlock(ExtendedProperties.of(Material.f_76274_).strength(0.6f).noOcclusion().sound(SoundType.f_56757_).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.TICK_COUNTER).flammable(120, 90)));
    public static final RegistryObject<Block> DEAD_CANE = TFCBlocks.register("plant/dead_cane", () -> new DeadCaneBlock(ExtendedProperties.of(Material.f_76274_).strength(0.6f).noOcclusion().sound(SoundType.f_56757_).randomTicks().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.TICK_COUNTER).flammable(120, 90)));
    public static final Map<FruitBlocks.Tree, RegistryObject<Block>> FRUIT_TREE_LEAVES = Helpers.mapOfKeys(FruitBlocks.Tree.class, tree -> TFCBlocks.register("plant/" + tree.name() + "_leaves", tree::createLeaves, TFCItemGroup.FLORA));
    public static final Map<FruitBlocks.Tree, RegistryObject<Block>> FRUIT_TREE_BRANCHES = Helpers.mapOfKeys(FruitBlocks.Tree.class, tree -> TFCBlocks.register("plant/" + tree.name() + "_branch", tree::createBranch));
    public static final Map<FruitBlocks.Tree, RegistryObject<Block>> FRUIT_TREE_GROWING_BRANCHES = Helpers.mapOfKeys(FruitBlocks.Tree.class, tree -> TFCBlocks.register("plant/" + tree.name() + "_growing_branch", tree::createGrowingBranch));
    public static final Map<FruitBlocks.Tree, RegistryObject<Block>> FRUIT_TREE_SAPLINGS = Helpers.mapOfKeys(FruitBlocks.Tree.class, tree -> TFCBlocks.register("plant/" + tree.name() + "_sapling", tree::createSapling, TFCItemGroup.FLORA));
    public static final RegistryObject<Block> BANANA_PLANT = TFCBlocks.register("plant/banana_plant", FruitBlocks::createBananaPlant);
    public static final RegistryObject<Block> BANANA_SAPLING = TFCBlocks.register("plant/banana_sapling", FruitBlocks::createBananaSapling, TFCItemGroup.FLORA);
    public static final RegistryObject<Block> PLAIN_ALABASTER = TFCBlocks.register("alabaster/raw", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60999_().m_60913_(1.5f, 6.0f)), TFCItemGroup.DECORATIONS);
    public static final RegistryObject<Block> PLAIN_ALABASTER_BRICKS = TFCBlocks.register("alabaster/bricks", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60999_().m_60913_(1.5f, 6.0f)), TFCItemGroup.DECORATIONS);
    public static final RegistryObject<Block> PLAIN_POLISHED_ALABASTER = TFCBlocks.register("alabaster/polished", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60999_().m_60913_(1.5f, 6.0f)), TFCItemGroup.DECORATIONS);
    public static final RegistryObject<Block> AGGREGATE = TFCBlocks.register("aggregate", () -> new GravelBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76317_, (MaterialColor)MaterialColor.f_76409_).m_60978_(0.6f).m_60918_(SoundType.f_56739_)), TFCItemGroup.DECORATIONS);
    public static final Map<DyeColor, RegistryObject<Block>> RAW_ALABASTER = Helpers.mapOfKeys(DyeColor.class, color -> TFCBlocks.register("alabaster/raw/" + color.m_41065_(), () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)color.m_41069_()).m_60999_().m_60913_(1.0f, 6.0f)), TFCItemGroup.DECORATIONS));
    public static final Map<DyeColor, RegistryObject<Block>> ALABASTER_BRICKS = Helpers.mapOfKeys(DyeColor.class, color -> TFCBlocks.register("alabaster/bricks/" + color.m_41065_(), () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)color.m_41069_()).m_60999_().m_60913_(1.5f, 6.0f)), TFCItemGroup.DECORATIONS));
    public static final Map<DyeColor, RegistryObject<Block>> POLISHED_ALABASTER = Helpers.mapOfKeys(DyeColor.class, color -> TFCBlocks.register("alabaster/polished/" + color.m_41065_(), () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)color.m_41069_()).m_60999_().m_60913_(1.5f, 6.0f)), TFCItemGroup.DECORATIONS));
    public static final Map<DyeColor, DecorationBlockRegistryObject> ALABASTER_BRICK_DECORATIONS = Helpers.mapOfKeys(DyeColor.class, color -> new DecorationBlockRegistryObject(TFCBlocks.register("alabaster/bricks/" + color.m_41065_() + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)color.m_41069_()).m_60999_().m_60913_(1.5f, 6.0f)), TFCItemGroup.DECORATIONS), TFCBlocks.register("alabaster/bricks/" + color.m_41065_() + "_stairs", () -> new StairBlock(() -> ((Block)ALABASTER_BRICKS.get(color).get()).m_49966_(), BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)color.m_41069_()).m_60999_().m_60913_(1.5f, 6.0f)), TFCItemGroup.DECORATIONS), TFCBlocks.register("alabaster/bricks/" + color.m_41065_() + "_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)color.m_41069_()).m_60999_().m_60913_(1.5f, 6.0f)), TFCItemGroup.DECORATIONS)));
    public static final Map<DyeColor, DecorationBlockRegistryObject> ALABASTER_POLISHED_DECORATIONS = Helpers.mapOfKeys(DyeColor.class, color -> new DecorationBlockRegistryObject(TFCBlocks.register("alabaster/polished/" + color.m_41065_() + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)color.m_41069_()).m_60999_().m_60913_(1.5f, 6.0f)), TFCItemGroup.DECORATIONS), TFCBlocks.register("alabaster/polished/" + color.m_41065_() + "_stairs", () -> new StairBlock(() -> ((Block)ALABASTER_BRICKS.get(color).get()).m_49966_(), BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)color.m_41069_()).m_60999_().m_60913_(1.5f, 6.0f)), TFCItemGroup.DECORATIONS), TFCBlocks.register("alabaster/polished/" + color.m_41065_() + "_wall", () -> new WallBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)color.m_41069_()).m_60999_().m_60913_(1.5f, 6.0f)), TFCItemGroup.DECORATIONS)));
    public static final RegistryObject<Block> FIRE_BRICKS = TFCBlocks.register("fire_bricks", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76364_).m_60999_().m_60913_(2.0f, 6.0f)), TFCItemGroup.DECORATIONS);
    public static final RegistryObject<Block> FIRE_CLAY_BLOCK = TFCBlocks.register("fire_clay_block", () -> new Block(BlockBehaviour.Properties.m_60939_((Material)Material.f_76313_).m_60978_(0.6f).m_60918_(SoundType.f_56739_)), TFCItemGroup.DECORATIONS);
    public static final RegistryObject<Block> WATTLE = TFCBlocks.register("wattle", () -> new WattleBlock(ExtendedProperties.of(Material.f_76320_).strength(0.3f).noOcclusion().sound(SoundType.f_56756_).flammable(60, 30)), TFCItemGroup.DECORATIONS);
    public static final RegistryObject<Block> UNSTAINED_WATTLE = TFCBlocks.register("wattle/unstained", () -> new StainedWattleBlock(ExtendedProperties.of(Material.f_76320_).strength(0.3f).sound(SoundType.f_56756_).flammable(60, 30)), TFCItemGroup.DECORATIONS);
    public static final Map<DyeColor, RegistryObject<Block>> STAINED_WATTLE = Helpers.mapOfKeys(DyeColor.class, color -> TFCBlocks.register("wattle/" + color.m_41065_(), () -> new StainedWattleBlock(ExtendedProperties.of(Material.f_76320_).strength(0.3f).sound(SoundType.f_56756_).flammable(60, 30)), TFCItemGroup.DECORATIONS));
    public static final RegistryObject<Block> THATCH = TFCBlocks.register("thatch", () -> new ThatchBlock(ExtendedProperties.of(Material.f_76274_).strength(0.6f, 0.4f).noOcclusion().isViewBlocking(TFCBlocks::never).sound((SoundType)TFCSounds.THATCH).flammable(50, 100)), TFCItemGroup.MISC);
    public static final RegistryObject<Block> THATCH_BED = TFCBlocks.register("thatch_bed", () -> new ThatchBedBlock(ExtendedProperties.of(Material.f_76302_).sound((SoundType)TFCSounds.THATCH).strength(0.6f, 0.4f).flammable(50, 100).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.THATCH_BED)));
    public static final RegistryObject<Block> LOG_PILE = TFCBlocks.register("log_pile", () -> new LogPileBlock(ExtendedProperties.of(Material.f_76320_).strength(0.6f).sound(SoundType.f_56736_).flammable(60, 30).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.LOG_PILE)));
    public static final RegistryObject<Block> BURNING_LOG_PILE = TFCBlocks.register("burning_log_pile", () -> new BurningLogPileBlock(ExtendedProperties.of(Material.f_76320_).randomTicks().strength(0.6f).sound(SoundType.f_56736_).flammable(60, 30).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.BURNING_LOG_PILE).serverTicks(BurningLogPileBlockEntity::serverTick)));
    public static final RegistryObject<Block> FIREPIT = TFCBlocks.register("firepit", () -> new FirepitBlock(ExtendedProperties.of(Material.f_76314_).strength(0.4f, 0.4f).sound(SoundType.f_56761_).randomTicks().noOcclusion().lightLevel(TFCBlocks.litBlockEmission(15)).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.FIREPIT).pathType(BlockPathTypes.DAMAGE_FIRE).serverTicks(AbstractFirepitBlockEntity::serverTick)), TFCItemGroup.MISC);
    public static final RegistryObject<Block> GRILL = TFCBlocks.register("grill", () -> new GrillBlock(ExtendedProperties.of(Material.f_76314_).strength(0.4f, 0.4f).sound(SoundType.f_56761_).randomTicks().noOcclusion().lightLevel(TFCBlocks.litBlockEmission(15)).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.GRILL).pathType(BlockPathTypes.DAMAGE_FIRE).serverTicks(AbstractFirepitBlockEntity::serverTick)), TFCItemGroup.MISC);
    public static final RegistryObject<Block> POT = TFCBlocks.register("pot", () -> new PotBlock(ExtendedProperties.of(Material.f_76314_).strength(0.4f, 0.4f).sound(SoundType.f_56761_).randomTicks().noOcclusion().lightLevel(TFCBlocks.litBlockEmission(15)).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.POT).pathType(BlockPathTypes.DAMAGE_FIRE).serverTicks(AbstractFirepitBlockEntity::serverTick)), TFCItemGroup.MISC);
    public static final RegistryObject<Block> BELLOWS = TFCBlocks.register("bellows", () -> new BellowsBlock(ExtendedProperties.of(Material.f_76320_).noOcclusion().dynamicShape().sound(SoundType.f_56736_).strength(3.0f).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.BELLOWS).ticks(BellowsBlockEntity::tickBoth)), TFCItemGroup.MISC);
    public static final RegistryObject<Block> POWDERKEG = TFCBlocks.register("powderkeg", () -> new PowderkegBlock(ExtendedProperties.of(Material.f_76320_).noOcclusion().dynamicShape().sound(SoundType.f_56736_).strength(2.5f).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.POWDERKEG).serverTicks(PowderkegBlockEntity::serverTick)), TFCItemGroup.MISC);
    public static final RegistryObject<Block> PLACED_ITEM = TFCBlocks.register("placed_item", () -> new PlacedItemBlock(ExtendedProperties.of(Material.f_76310_).instabreak().sound(SoundType.f_56763_).noOcclusion().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.PLACED_ITEM)));
    public static final RegistryObject<Block> SCRAPING = TFCBlocks.register("scraping", () -> new ScrapingBlock(ExtendedProperties.of(Material.f_76310_).strength(0.2f).sound(SoundType.f_56763_).noOcclusion().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.SCRAPING)));
    public static final RegistryObject<Block> PIT_KILN = TFCBlocks.register("pit_kiln", () -> new PitKilnBlock(ExtendedProperties.of(Material.f_76275_).sound(SoundType.f_56736_).strength(0.6f).noOcclusion().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.PIT_KILN).serverTicks(PitKilnBlockEntity::serverTick)));
    public static final RegistryObject<Block> QUERN = TFCBlocks.register("quern", () -> new QuernBlock(ExtendedProperties.of(Material.f_76278_).strength(0.5f, 2.0f).sound(SoundType.f_56718_).noOcclusion().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.QUERN).ticks(QuernBlockEntity::serverTick, QuernBlockEntity::clientTick)), TFCItemGroup.MISC);
    public static final RegistryObject<Block> CHARCOAL_PILE = TFCBlocks.register("charcoal_pile", () -> new CharcoalPileBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76314_, (MaterialColor)MaterialColor.f_76365_).m_60978_(0.2f).m_60918_((SoundType)TFCSounds.CHARCOAL).m_60971_((state, level, pos) -> (Integer)state.m_61143_((Property)CharcoalPileBlock.LAYERS) >= 8).m_60960_((state, level, pos) -> (Integer)state.m_61143_((Property)CharcoalPileBlock.LAYERS) >= 8)));
    public static final RegistryObject<Block> CHARCOAL_FORGE = TFCBlocks.register("charcoal_forge", () -> new CharcoalForgeBlock(ExtendedProperties.of(Material.f_76314_, MaterialColor.f_76365_).strength(0.2f).randomTicks().sound((SoundType)TFCSounds.CHARCOAL).lightLevel(state -> (Integer)state.m_61143_((Property)CharcoalForgeBlock.HEAT) * 2).pathType(BlockPathTypes.DAMAGE_FIRE).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.CHARCOAL_FORGE).serverTicks(CharcoalForgeBlockEntity::serverTick)));
    public static final RegistryObject<Block> TORCH = TFCBlocks.register("torch", () -> new TFCTorchBlock(ExtendedProperties.of(Material.f_76310_).noCollission().instabreak().randomTicks().lightLevel(state -> 14).sound(SoundType.f_56736_).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.TICK_COUNTER), (ParticleOptions)ParticleTypes.f_123744_));
    public static final RegistryObject<Block> WALL_TORCH = TFCBlocks.register("wall_torch", () -> new TFCWallTorchBlock(ExtendedProperties.of(Material.f_76310_).noCollission().instabreak().randomTicks().lightLevel(state -> 14).sound(SoundType.f_56736_).dropsLike((Supplier<Block>)TORCH).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.TICK_COUNTER), (ParticleOptions)ParticleTypes.f_123744_));
    public static final RegistryObject<Block> DEAD_TORCH = TFCBlocks.register("dead_torch", () -> new DeadTorchBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_().m_60918_(SoundType.f_56736_), (ParticleOptions)ParticleTypes.f_123744_));
    public static final RegistryObject<Block> DEAD_WALL_TORCH = TFCBlocks.register("dead_wall_torch", () -> new DeadWallTorchBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60966_().m_60918_(SoundType.f_56736_).lootFrom(DEAD_TORCH), (ParticleOptions)ParticleTypes.f_123744_));
    public static final RegistryObject<Block> JACK_O_LANTERN = TFCBlocks.register("jack_o_lantern", () -> new JackOLanternBlock(ExtendedProperties.of(Material.f_76285_, MaterialColor.f_76413_).strength(1.0f).sound(SoundType.f_56736_).randomTicks().lightLevel(TFCBlocks.alwaysLit()).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.TICK_COUNTER), () -> Blocks.f_50143_), TFCItemGroup.MISC);
    public static final RegistryObject<Block> CRUCIBLE = TFCBlocks.register("crucible", () -> new CrucibleBlock(ExtendedProperties.of(Material.f_76279_).strength(3.0f).sound(SoundType.f_56743_).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.CRUCIBLE).serverTicks(CrucibleBlockEntity::serverTick)), TFCItemGroup.DECORATIONS);
    public static final RegistryObject<Block> COMPOSTER = TFCBlocks.register("composter", () -> new TFCComposterBlock(ExtendedProperties.of(Material.f_76320_).strength(0.6f).noOcclusion().sound(SoundType.f_56736_).randomTicks().flammable(60, 90).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.COMPOSTER)), TFCItemGroup.DECORATIONS);
    public static final RegistryObject<Block> BLOOMERY = TFCBlocks.register("bloomery", () -> new BloomeryBlock(ExtendedProperties.of(Material.f_76279_).strength(3.0f).sound(SoundType.f_56743_).lightLevel(TFCBlocks.litBlockEmission(15)).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.BLOOMERY).serverTicks(BloomeryBlockEntity::serverTick)), TFCItemGroup.MISC);
    public static final RegistryObject<Block> BLAST_FURNACE = TFCBlocks.register("blast_furnace", () -> new BlastFurnaceBlock(ExtendedProperties.of(Material.f_76279_).strength(5.0f).sound(SoundType.f_56743_).lightLevel(TFCBlocks.litBlockEmission(15)).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.BLAST_FURNACE).serverTicks(BlastFurnaceBlockEntity::serverTick)), TFCItemGroup.MISC);
    public static final RegistryObject<Block> BLOOM = TFCBlocks.register("bloom", () -> new BloomBlock(ExtendedProperties.of(Material.f_76278_).requiresCorrectToolForDrops().strength(3.0f, 6.0f).noOcclusion().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.BLOOM)), TFCItemGroup.MISC);
    public static final RegistryObject<Block> MOLTEN = TFCBlocks.register("molten", () -> new MoltenBlock(ExtendedProperties.of(Material.f_76278_).requiresCorrectToolForDrops().strength(-1.0f, 3600000.0f).noOcclusion().lightLevel(TFCBlocks.litBlockEmission(15)).pathType(BlockPathTypes.DAMAGE_FIRE)), TFCItemGroup.MISC);
    public static final RegistryObject<Block> NEST_BOX = TFCBlocks.register("nest_box", () -> new NestBoxBlock(ExtendedProperties.of(Material.f_76320_).strength(3.0f).noOcclusion().sound((SoundType)TFCSounds.THATCH).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.NEST_BOX).serverTicks(NestBoxBlockEntity::serverTick).flammable(60, 30)), TFCItemGroup.DECORATIONS);
    public static final RegistryObject<Block> LIGHT = TFCBlocks.register("light", () -> new TFCLightBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76296_).m_60913_(-1.0f, 3600000.8f).m_60993_().m_60955_().m_60953_(state -> (Integer)state.m_61143_((Property)TFCLightBlock.LEVEL)).m_60977_()), TFCItemGroup.MISC);
    public static final RegistryObject<Block> FRESHWATER_BUBBLE_COLUMN = TFCBlocks.register("freshwater_bubble_column", () -> new TFCBubbleColumnBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76306_).m_60910_().m_60993_(), () -> Fluids.f_76193_));
    public static final RegistryObject<Block> SALTWATER_BUBBLE_COLUMN = TFCBlocks.register("saltwater_bubble_column", () -> new TFCBubbleColumnBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76306_).m_60910_().m_60993_(), TFCFluids.SALT_WATER::getSource));
    public static final RegistryObject<Block> SHEET_PILE = TFCBlocks.register("sheet_pile", () -> new SheetPileBlock(ExtendedProperties.of(Material.f_76279_).strength(4.0f, 60.0f).sound(SoundType.f_56743_).noOcclusion().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.SHEET_PILE)));
    public static final RegistryObject<Block> INGOT_PILE = TFCBlocks.register("ingot_pile", () -> new IngotPileBlock(ExtendedProperties.of(Material.f_76279_).strength(4.0f, 60.0f).sound(SoundType.f_56743_).noOcclusion().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.INGOT_PILE)));
    public static final RegistryObject<Block> CANDLE = TFCBlocks.register("candle", () -> new TFCCandleBlock(ExtendedProperties.of(Material.f_76310_, MaterialColor.f_76400_).randomTicks().noOcclusion().strength(0.1f).sound(SoundType.f_154653_).lightLevel(CandleBlock.f_152793_).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.TICK_COUNTER)), TFCItemGroup.MISC);
    public static final Map<DyeColor, RegistryObject<Block>> DYED_CANDLE = Helpers.mapOfKeys(DyeColor.class, color -> TFCBlocks.register("candle/" + color.m_41065_(), () -> new TFCCandleBlock(ExtendedProperties.of(Material.f_76310_, MaterialColor.f_76400_).randomTicks().noOcclusion().strength(0.1f).sound(SoundType.f_154653_).lightLevel(CandleBlock.f_152793_).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.TICK_COUNTER)), TFCItemGroup.MISC));
    public static final RegistryObject<Block> LARGE_VESSEL = TFCBlocks.register("ceramic/large_vessel", () -> new LargeVesselBlock(ExtendedProperties.of(Material.f_76313_).strength(2.5f).noOcclusion().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.LARGE_VESSEL)), TFCItemGroup.MISC);
    public static final Map<DyeColor, RegistryObject<Block>> GLAZED_LARGE_VESSELS = Helpers.mapOfKeys(DyeColor.class, color -> TFCBlocks.register("ceramic/large_vessel/" + color.m_41065_(), () -> new LargeVesselBlock(ExtendedProperties.of(Material.f_76313_).strength(2.5f).noOcclusion().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.LARGE_VESSEL)), TFCItemGroup.MISC));
    public static final Map<Metal.Default, RegistryObject<LiquidBlock>> METAL_FLUIDS = Helpers.mapOfKeys(Metal.Default.class, metal -> TFCBlocks.register("fluid/metal/" + metal.name(), () -> new LiquidBlock(TFCFluids.METALS.get(metal).source(), BlockBehaviour.Properties.m_60939_((Material)TFCMaterials.MOLTEN_METAL).m_60910_().m_60978_(100.0f).m_60993_())));
    public static final Map<SimpleFluid, RegistryObject<LiquidBlock>> SIMPLE_FLUIDS = Helpers.mapOfKeys(SimpleFluid.class, fluid -> TFCBlocks.register("fluid/" + fluid.getId(), () -> new LiquidBlock(TFCFluids.SIMPLE_FLUIDS.get(fluid).source(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60910_().m_60978_(100.0f).m_60993_())));
    public static final Map<DyeColor, RegistryObject<LiquidBlock>> COLORED_FLUIDS = Helpers.mapOfKeys(DyeColor.class, fluid -> TFCBlocks.register("fluid/" + fluid.m_41065_() + "_dye", () -> new LiquidBlock(TFCFluids.COLORED_FLUIDS.get(fluid).source(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60910_().m_60978_(100.0f).m_60993_())));
    public static final Map<Alcohol, RegistryObject<LiquidBlock>> ALCOHOLS = Helpers.mapOfKeys(Alcohol.class, fluid -> TFCBlocks.register("fluid/" + fluid.getId(), () -> new LiquidBlock(TFCFluids.ALCOHOLS.get(fluid).source(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60910_().m_60978_(100.0f).m_60993_())));
    public static final RegistryObject<LiquidBlock> SALT_WATER = TFCBlocks.register("fluid/salt_water", () -> new LiquidBlock(TFCFluids.SALT_WATER.flowing(), BlockBehaviour.Properties.m_60939_((Material)TFCMaterials.SALT_WATER).m_60910_().m_60978_(100.0f).m_60993_()));
    public static final RegistryObject<LiquidBlock> SPRING_WATER = TFCBlocks.register("fluid/spring_water", () -> new HotWaterBlock((Supplier<? extends FlowingFluid>)TFCFluids.SPRING_WATER.source(), BlockBehaviour.Properties.m_60939_((Material)TFCMaterials.SPRING_WATER).m_60910_().m_60978_(100.0f).m_60993_()));
    public static final RegistryObject<RiverWaterBlock> RIVER_WATER = TFCBlocks.register("fluid/river_water", () -> new RiverWaterBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_60910_().m_60978_(100.0f).m_60993_()));

    public static boolean always(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public static boolean never(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public static boolean never(BlockState state, BlockGetter world, BlockPos pos, EntityType<?> type) {
        return false;
    }

    public static boolean onlyColdMobs(BlockState state, BlockGetter world, BlockPos pos, EntityType<?> type) {
        return Helpers.isEntity(type, TFCTags.Entities.SPAWNS_ON_COLD_BLOCKS);
    }

    private static ToIntFunction<BlockState> alwaysLit() {
        return s -> 15;
    }

    private static ToIntFunction<BlockState> litBlockEmission(int lightValue) {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? lightValue : 0;
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockSupplier) {
        return TFCBlocks.register(name, blockSupplier, (Function)null);
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockSupplier, CreativeModeTab group) {
        return TFCBlocks.register(name, blockSupplier, (T block) -> new BlockItem(block, new Item.Properties().m_41491_(group)));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockSupplier, Item.Properties blockItemProperties) {
        return TFCBlocks.register(name, blockSupplier, (T block) -> new BlockItem(block, blockItemProperties));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockSupplier, @Nullable Function<T, ? extends BlockItem> blockItemFactory) {
        return RegistrationHelpers.registerBlock(BLOCKS, TFCItems.ITEMS, name, blockSupplier, blockItemFactory);
    }
}

