/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks;

import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.ThatchBedBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ThatchBedBlock
extends HorizontalDirectionalBlock
implements EntityBlockExtension,
IForgeBlockExtension {
    public static final EnumProperty<BedPart> PART = BlockStateProperties.f_61391_;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;
    private static final VoxelShape BED_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    private final ExtendedProperties properties;

    public static Direction getNeighbourDirection(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.m_122424_();
    }

    public ThatchBedBlock(ExtendedProperties properties) {
        super(properties.properties());
        this.properties = properties;
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return state.m_61143_(PART) == BedPart.HEAD ? this.getExtendedProperties().newBlockEntity(pos, state) : null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (BedBlock.m_49488_((Level)level)) {
            if (!level.m_46470_()) {
                ServerPlayer serverPlayer;
                boolean willSleep = (Boolean)TFCConfig.SERVER.enableThatchBedSleeping.get();
                boolean spawnPoint = (Boolean)TFCConfig.SERVER.enableThatchBedSpawnSetting.get();
                if (!willSleep) {
                    player.m_5661_((Component)Helpers.translatable("tfc.thatch_bed.use"), true);
                }
                if (spawnPoint && !level.f_46443_ && player instanceof ServerPlayer && ((serverPlayer = (ServerPlayer)player).m_8963_() != level.m_46472_() || !pos.equals((Object)serverPlayer.m_8961_()))) {
                    serverPlayer.m_9158_(level.m_46472_(), pos, 0.0f, false, false);
                }
                if (willSleep && !level.f_46443_) {
                    player.m_7720_(pos).ifLeft(problem -> {
                        if (problem.m_36423_() != null) {
                            player.m_5661_(problem.m_36423_(), true);
                        }
                    });
                }
            } else {
                player.m_5661_((Component)Helpers.translatable("tfc.thatch_bed.thundering"), true);
            }
        } else if (!level.f_46443_) {
            level.m_7703_(null, DamageSource.m_19334_(), null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 7.0f, true, Explosion.BlockInteraction.DESTROY);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return BED_SHAPE;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return context.m_43725_().m_8055_(context.m_8083_().m_142300_(context.m_8125_())).m_60629_(context) ? (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_()) : null;
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.m_142072_(level, state, pos, entity, fallDistance * 0.5f);
    }

    public void m_5548_(BlockGetter level, Entity entity) {
        if (entity.m_20162_()) {
            super.m_5548_(level, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos neighbourPos;
        BlockState neighbourState;
        BedPart part;
        if (!level.f_46443_ && player.m_7500_() && (part = (BedPart)state.m_61143_(PART)) == BedPart.FOOT && Helpers.isBlock(neighbourState = level.m_8055_(neighbourPos = pos.m_142300_(ThatchBedBlock.getNeighbourDirection(part, (Direction)state.m_61143_((Property)f_54117_)))), (Block)this) && neighbourState.m_61143_(PART) == BedPart.HEAD) {
            level.m_7731_(neighbourPos, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, neighbourPos, Block.m_49956_((BlockState)neighbourState));
        }
        super.m_5707_(level, pos, state, player);
    }

    private void bounceUp(Entity entity) {
        Vec3 v = entity.m_20184_();
        if (v.f_82480_ < 0.0) {
            double factor = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(v.f_82479_, -v.f_82480_ * (double)0.66f * factor, v.f_82481_);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (facing == ThatchBedBlock.getNeighbourDirection((BedPart)state.m_61143_(PART), (Direction)state.m_61143_((Property)f_54117_))) {
            return Helpers.isBlock(facingState, (Block)this) && facingState.m_61143_(PART) != state.m_61143_(PART) ? (BlockState)state.m_61124_((Property)OCCUPIED, (Comparable)((Boolean)facingState.m_61143_((Property)OCCUPIED))) : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    public boolean isBed(BlockState state, BlockGetter world, BlockPos pos, @Nullable Entity player) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.THATCH_BED.get()).map(bed -> bed.getCapability(Capabilities.ITEM).map(inv -> inv.getStackInSlot(0).m_41777_()).orElse(ItemStack.f_41583_)).orElse(ItemStack.f_41583_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{PART, f_54117_, OCCUPIED}));
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_61143_(PART) == BedPart.HEAD) {
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.THATCH_BED.get()).ifPresent(ThatchBedBlockEntity::destroyBed);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }
}

