/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import java.util.function.Supplier;
import net.dries007.tfc.client.IGhostBlockHandler;
import net.dries007.tfc.common.blockentities.FarmlandBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.crop.Crop;
import net.dries007.tfc.common.blocks.crop.CropHelpers;
import net.dries007.tfc.common.blocks.crop.DeadCropBlock;
import net.dries007.tfc.common.blocks.crop.DeadDoubleCropBlock;
import net.dries007.tfc.common.blocks.crop.DoubleCropBlock;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.climate.ClimateRanges;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public abstract class ClimbingCropBlock
extends DoubleCropBlock
implements IGhostBlockHandler {
    public static final BooleanProperty STICK = TFCBlockStateProperties.STICK;

    public static ClimbingCropBlock create(ExtendedProperties properties, int singleStages, int doubleStages, Crop crop) {
        final IntegerProperty property = TFCBlockStateProperties.getAgeProperty(singleStages + doubleStages - 1);
        return new ClimbingCropBlock(properties, singleStages - 1, singleStages + doubleStages - 1, (Supplier)TFCBlocks.DEAD_CROPS.get((Object)crop), (Supplier)TFCItems.CROP_SEEDS.get((Object)crop), crop.getPrimaryNutrient(), ClimateRanges.CROPS.get((Object)crop)){

            @Override
            public IntegerProperty m_7959_() {
                return property;
            }
        };
    }

    protected ClimbingCropBlock(ExtendedProperties properties, int maxSingleAge, int maxAge, Supplier<? extends Block> dead, Supplier<? extends Item> seeds, FarmlandBlockEntity.NutrientType primaryNutrient, Supplier<ClimateRange> climateRange) {
        super(properties, maxSingleAge, maxAge, dead, seeds, primaryNutrient, climateRange);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)STICK, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PART, (Comparable)((Object)DoubleCropBlock.Part.BOTTOM)));
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        BlockPos posAbove = pos.m_7494_();
        if (Helpers.isItem(heldStack.m_41720_(), (TagKey<Item>)Tags.Items.RODS_WOODEN) && !((Boolean)state.m_61143_((Property)STICK)).booleanValue() && level.m_46859_(posAbove) && posAbove.m_123342_() <= level.m_151558_()) {
            if (!level.m_5776_()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)STICK, (Comparable)Boolean.valueOf(true)), 2);
                level.m_7731_(pos.m_7494_(), (BlockState)((BlockState)state.m_61124_((Property)STICK, (Comparable)Boolean.valueOf(true))).m_61124_((Property)PART, (Comparable)((Object)DoubleCropBlock.Part.TOP)), 3);
                if (!player.m_7500_()) {
                    heldStack.m_41774_(1);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{STICK}));
    }

    @Override
    public float getGrowthLimit(Level level, BlockPos pos, BlockState state) {
        if (!CropHelpers.lightValid(level, pos)) {
            return 0.0f;
        }
        BlockState stateAbove = level.m_8055_(pos.m_7494_());
        return stateAbove.m_60734_() == this && (Boolean)stateAbove.m_61143_((Property)STICK) != false && stateAbove.m_61143_((Property)PART) == DoubleCropBlock.Part.TOP ? 1.0f : this.maxSingleGrowth;
    }

    @Override
    public void die(Level level, BlockPos pos, BlockState state, boolean fullyGrown) {
        BlockPos posAbove = pos.m_7494_();
        BlockState stateAbove = level.m_8055_(posAbove);
        boolean hasTop = stateAbove.m_60734_() == this;
        BlockState deadState = (BlockState)((BlockState)((Block)this.dead.get()).m_49966_().m_61124_((Property)DeadCropBlock.MATURE, (Comparable)Boolean.valueOf(fullyGrown || hasTop))).m_61124_((Property)STICK, (Comparable)((Boolean)state.m_61143_((Property)STICK)));
        if (hasTop || stateAbove.m_60795_() && ((Boolean)state.m_61143_((Property)STICK)).booleanValue()) {
            level.m_7731_(posAbove, (BlockState)deadState.m_61124_(DeadDoubleCropBlock.PART, (Comparable)((Object)DoubleCropBlock.Part.TOP)), 2);
        } else {
            level.m_46961_(posAbove, false);
        }
        level.m_46597_(pos, (BlockState)deadState.m_61124_(DeadDoubleCropBlock.PART, (Comparable)((Object)DoubleCropBlock.Part.BOTTOM)));
    }

    @Override
    @Nullable
    public BlockState getStateToDraw(Level level, Player player, BlockState state, Direction direction, BlockPos pos, double x, double y, double z, ItemStack item) {
        BlockPos abovePos = pos.m_7494_();
        if (Helpers.isItem(item.m_41720_(), (TagKey<Item>)Tags.Items.RODS_WOODEN) && !((Boolean)state.m_61143_((Property)STICK)).booleanValue() && level.m_46859_(abovePos) && abovePos.m_123342_() <= level.m_151558_()) {
            return (BlockState)state.m_61124_((Property)STICK, (Comparable)Boolean.valueOf(true));
        }
        return null;
    }
}

