/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.CropBlockEntity;
import net.dries007.tfc.common.blockentities.FarmlandBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.crop.CropHelpers;
import net.dries007.tfc.common.blocks.crop.ICropBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class CropBlock
extends net.minecraft.world.level.block.CropBlock
implements HoeOverlayBlock,
ICropBlock,
IForgeBlockExtension,
EntityBlockExtension {
    public static final VoxelShape QUARTER_SHAPE = CropBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    public static final VoxelShape HALF_SHAPE = CropBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    public static final VoxelShape FULL_SHAPE = CropBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected final FarmlandBlockEntity.NutrientType primaryNutrient;
    protected final Supplier<? extends Block> dead;
    protected final Supplier<? extends Item> seeds;
    protected final Supplier<ClimateRange> climateRange;
    private final ExtendedProperties extendedProperties;
    private final int maxAge;

    protected CropBlock(ExtendedProperties properties, int maxAge, Supplier<? extends Block> dead, Supplier<? extends Item> seeds, FarmlandBlockEntity.NutrientType primaryNutrient, Supplier<ClimateRange> climateRange) {
        super(properties.properties());
        this.extendedProperties = properties;
        this.maxAge = maxAge;
        this.dead = dead;
        this.seeds = seeds;
        this.primaryNutrient = primaryNutrient;
        this.climateRange = climateRange;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(0)));
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.extendedProperties;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        float growth = (float)((Integer)state.m_61143_((Property)this.m_7959_())).intValue() / (float)this.m_7419_();
        if (growth <= 0.25f) {
            return QUARTER_SHAPE;
        }
        if (growth <= 0.5f) {
            return HALF_SHAPE;
        }
        return FULL_SHAPE;
    }

    public abstract IntegerProperty m_7959_();

    public int m_7419_() {
        return this.maxAge;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        this.m_7458_(state, level, pos, random);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : state;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return Helpers.isBlock(level.m_8055_(pos.m_7495_()), TFCTags.Blocks.FARMLAND);
    }

    protected ItemLike m_6404_() {
        return (ItemLike)this.seeds.get();
    }

    public boolean m_7370_(BlockGetter level, BlockPos pos, BlockState state, boolean isClient) {
        return false;
    }

    public boolean m_5491_(Level level, Random rand, BlockPos pos, BlockState state) {
        return false;
    }

    public void m_7719_(ServerLevel level, Random rand, BlockPos pos, BlockState state) {
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.m_7959_()});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return CropHelpers.useFertilizer(level, player, hand, pos.m_7495_()) ? InteractionResult.SUCCESS : super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        if (!level.m_5776_()) {
            if (this.m_7898_(state, (LevelReader)level, pos)) {
                level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.CROP.get()).ifPresent(crop -> this.growthTick((Level)level, pos, state, (CropBlockEntity)crop));
            } else {
                level.m_46961_(pos, true);
            }
        }
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, List<Component> text, boolean isDebug) {
        ClimateRange range = this.climateRange.get();
        BlockPos sourcePos = pos.m_7495_();
        text.add(FarmlandBlock.getTemperatureTooltip(level, pos, range, false));
        text.add(FarmlandBlock.getHydrationTooltip((LevelAccessor)level, sourcePos, range, false));
        level.m_141902_(sourcePos, (BlockEntityType)TFCBlockEntities.FARMLAND.get()).or(() -> level.m_141902_(sourcePos.m_7495_(), (BlockEntityType)TFCBlockEntities.FARMLAND.get())).ifPresent(farmland -> farmland.addHoeOverlayInfo(level, farmland.m_58899_(), text, false, true));
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.CROP.get()).ifPresent(crop -> {
            if (isDebug) {
                text.add((Component)Helpers.literal(String.format("[Debug] Growth = %.4f Yield = %.4f Last Tick = %d Delta = %d", Float.valueOf(crop.getGrowth()), Float.valueOf(crop.getYield()), crop.getLastGrowthTick(), Calendars.get((LevelReader)level).getTicks() - crop.getLastGrowthTick())));
            }
            if (crop.getGrowth() >= 1.0f) {
                text.add((Component)Helpers.translatable("tfc.tooltip.farmland.mature"));
            }
        });
    }

    @Override
    public void growthTick(Level level, BlockPos pos, BlockState state, CropBlockEntity crop) {
        if (!level.m_5776_() && CropHelpers.growthTick(level, pos, state, crop)) {
            this.postGrowthTick(level, pos, state, crop);
        }
    }

    @Override
    public ClimateRange getClimateRange() {
        return this.climateRange.get();
    }

    @Override
    public FarmlandBlockEntity.NutrientType getPrimaryNutrient() {
        return this.primaryNutrient;
    }

    protected abstract void postGrowthTick(Level var1, BlockPos var2, BlockState var3, CropBlockEntity var4);
}

