/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import java.util.Random;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.blockentities.CropBlockEntity;
import net.dries007.tfc.common.blockentities.FarmlandBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.crop.ICropBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.util.Fertilizer;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.advancements.TFCAdvancements;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public final class CropHelpers {
    public static final long UPDATE_INTERVAL = 48000L;
    public static final float GROWTH_FACTOR = 1.7361111E-6f;
    public static final float NUTRIENT_CONSUMPTION = 3.4722223E-6f;
    public static final float NUTRIENT_GROWTH_FACTOR = 0.5f;
    public static final float GROWTH_LIMIT = 1.0f;
    public static final float EXPIRY_LIMIT = 2.0f;
    public static final float YIELD_MIN = 0.2f;
    public static final float YIELD_LIMIT = 1.0f;

    public static boolean lightValid(Level level, BlockPos pos) {
        return level.m_45524_(pos, 0) >= 12;
    }

    public static boolean growthTick(Level level, BlockPos pos, BlockState state, CropBlockEntity crop) {
        long firstTick = crop.getLastGrowthTick();
        long thisTick = Calendars.SERVER.getTicks();
        long lastTick = firstTick;
        for (long tick = firstTick + 48000L; tick < thisTick; tick += 48000L) {
            if (!CropHelpers.growthTickStep(level, pos, state, level.m_5822_(), lastTick, tick, crop)) {
                return false;
            }
            lastTick = tick;
        }
        return lastTick >= thisTick || CropHelpers.growthTickStep(level, pos, state, level.m_5822_(), lastTick, thisTick, crop);
    }

    public static boolean growthTickStep(Level level, BlockPos pos, BlockState state, Random random, long fromTick, long toTick, CropBlockEntity crop) {
        float growthDelta;
        float delta;
        float initialGrowth;
        ICalendar calendar = Calendars.get((LevelReader)level);
        BlockPos sourcePos = pos.m_7495_();
        int hydration = FarmlandBlock.getHydration((LevelAccessor)level, sourcePos);
        float startTemperature = Climate.getTemperature(level, pos, calendar, Calendars.SERVER.ticksToCalendarTicks(fromTick));
        float endTemperature = Climate.getTemperature(level, pos, calendar, Calendars.SERVER.ticksToCalendarTicks(toTick));
        long tickDelta = toTick - fromTick;
        ICropBlock cropBlock = (ICropBlock)state.m_60734_();
        ClimateRange range = cropBlock.getClimateRange();
        boolean growing = CropHelpers.checkClimate(range, hydration, startTemperature, endTemperature, false);
        boolean healthy = growing || CropHelpers.checkClimate(range, hydration, startTemperature, endTemperature, true);
        FarmlandBlockEntity farmland = level.m_141902_(sourcePos, (BlockEntityType)TFCBlockEntities.FARMLAND.get()).orElse(null);
        FarmlandBlockEntity.NutrientType primaryNutrient = cropBlock.getPrimaryNutrient();
        float nutrientsAvailable = 0.0f;
        float nutrientsRequired = 3.4722223E-6f * (float)tickDelta;
        float nutrientsConsumed = 0.0f;
        if (farmland != null) {
            nutrientsAvailable = farmland.getNutrient(primaryNutrient);
            nutrientsConsumed = farmland.consumeNutrientAndResupplyOthers(primaryNutrient, nutrientsRequired);
        }
        float totalGrowthDelta = Helpers.uniform(random, 0.9f, 1.1f) * (float)tickDelta * 1.7361111E-6f + nutrientsConsumed * 0.5f;
        float growth = initialGrowth = crop.getGrowth();
        float expiry = crop.getExpiry();
        float actualYield = crop.getYield();
        float growthLimit = cropBlock.getGrowthLimit(level, pos, state);
        if (totalGrowthDelta > 0.0f && growing && growth < growthLimit) {
            delta = Math.min(totalGrowthDelta, growthLimit - growth);
            growth += delta;
            totalGrowthDelta -= delta;
        }
        if (totalGrowthDelta > 0.0f) {
            delta = Math.min(totalGrowthDelta, 2.0f - expiry);
            expiry += delta;
            totalGrowthDelta -= delta;
        }
        float nutrientSatisfaction = (growthDelta = growth - initialGrowth) <= 0.0f || nutrientsRequired <= 0.0f ? 1.0f : Math.min(1.0f, totalGrowthDelta / growthDelta * (nutrientsAvailable / nutrientsRequired));
        actualYield += growthDelta * Helpers.lerp(nutrientSatisfaction, 0.2f, 1.0f);
        if (expiry >= 2.0f || !healthy) {
            cropBlock.die(level, pos, state, growth >= 1.0f);
            return false;
        }
        crop.setGrowth(growth);
        crop.setYield(actualYield);
        crop.setExpiry(expiry);
        crop.setLastGrowthTick(calendar.getTicks());
        return true;
    }

    private static boolean checkClimate(ClimateRange range, int hydration, float firstTemperature, float secondTemperature, boolean allowWiggle) {
        return range.checkBoth(hydration, firstTemperature, allowWiggle) && range.checkTemperature(secondTemperature, allowWiggle) == ClimateRange.Result.VALID;
    }

    public static boolean useFertilizer(Level level, Player player, InteractionHand hand, BlockPos farmlandPos) {
        ItemStack stack;
        Fertilizer fertilizer;
        if (!level.m_5776_() && (fertilizer = Fertilizer.get(stack = player.m_21120_(hand))) != null) {
            level.m_141902_(farmlandPos, (BlockEntityType)TFCBlockEntities.FARMLAND.get()).ifPresent(farmland -> {
                farmland.addNutrients(fertilizer);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                CropHelpers.addNutrientParticles((ServerLevel)level, farmlandPos.m_7494_(), fertilizer);
                if (farmland.isMaxedOut() && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    TFCAdvancements.FULL_FERTILIZER.trigger(serverPlayer);
                }
            });
            return true;
        }
        return false;
    }

    private static void addNutrientParticles(ServerLevel level, BlockPos pos, Fertilizer fertilizer) {
        int i;
        float n = fertilizer.getNitrogen();
        float p = fertilizer.getPhosphorus();
        float k = fertilizer.getPotassium();
        for (i = 0; i < (int)(n > 0.0f ? Mth.m_14036_((float)(n * 10.0f), (float)1.0f, (float)5.0f) : 0.0f); ++i) {
            level.m_8767_((ParticleOptions)((SimpleParticleType)TFCParticles.NITROGEN.get()), (double)((float)pos.m_123341_() + level.f_46441_.nextFloat()), (double)pos.m_123342_() + (double)level.f_46441_.nextFloat() / 5.0, (double)((float)pos.m_123343_() + level.f_46441_.nextFloat()), 0, 0.0, 0.0, 0.0, 1.0);
        }
        for (i = 0; i < (int)(p > 0.0f ? Mth.m_14036_((float)(p * 10.0f), (float)1.0f, (float)5.0f) : 0.0f); ++i) {
            level.m_8767_((ParticleOptions)((SimpleParticleType)TFCParticles.PHOSPHORUS.get()), (double)((float)pos.m_123341_() + level.f_46441_.nextFloat()), (double)pos.m_123342_() + (double)level.f_46441_.nextFloat() / 5.0, (double)((float)pos.m_123343_() + level.f_46441_.nextFloat()), 0, 0.0, 0.0, 0.0, 1.0);
        }
        for (i = 0; i < (int)(k > 0.0f ? Mth.m_14036_((float)(k * 10.0f), (float)1.0f, (float)5.0f) : 0.0f); ++i) {
            level.m_8767_((ParticleOptions)((SimpleParticleType)TFCParticles.POTASSIUM.get()), (double)((float)pos.m_123341_() + level.f_46441_.nextFloat()), (double)pos.m_123342_() + (double)level.f_46441_.nextFloat() / 5.0, (double)((float)pos.m_123343_() + level.f_46441_.nextFloat()), 0, 0.0, 0.0, 0.0, 1.0);
        }
    }
}

