/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.CropBlockEntity;
import net.dries007.tfc.common.blockentities.FarmlandBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.crop.Crop;
import net.dries007.tfc.common.blocks.crop.CropBlock;
import net.dries007.tfc.common.blocks.crop.DeadCropBlock;
import net.dries007.tfc.common.blocks.crop.DeadDoubleCropBlock;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.climate.ClimateRanges;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class DoubleCropBlock
extends CropBlock {
    public static final EnumProperty<Part> PART = TFCBlockStateProperties.DOUBLE_CROP_PART;
    protected final int maxSingleAge;
    protected final float maxSingleGrowth;

    public static DoubleCropBlock create(ExtendedProperties properties, int singleStages, int doubleStages, Crop crop) {
        final IntegerProperty property = TFCBlockStateProperties.getAgeProperty(singleStages + doubleStages - 1);
        return new DoubleCropBlock(properties, singleStages - 1, singleStages + doubleStages - 1, (Supplier)TFCBlocks.DEAD_CROPS.get((Object)crop), (Supplier)TFCItems.CROP_SEEDS.get((Object)crop), crop.getPrimaryNutrient(), ClimateRanges.CROPS.get((Object)crop)){

            @Override
            public IntegerProperty m_7959_() {
                return property;
            }
        };
    }

    protected DoubleCropBlock(ExtendedProperties properties, int maxSingleAge, int maxAge, Supplier<? extends Block> dead, Supplier<? extends Item> seeds, FarmlandBlockEntity.NutrientType primaryNutrient, Supplier<ClimateRange> climateRange) {
        super(properties, maxAge, dead, seeds, primaryNutrient, climateRange);
        this.maxSingleAge = maxSingleAge;
        this.maxSingleGrowth = (float)maxSingleAge / (float)maxAge;
        this.m_49959_((BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)Part.BOTTOM)));
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Part part = (Part)((Object)state.m_61143_(PART));
        BlockState belowState = level.m_8055_(pos.m_7495_());
        if (part == Part.BOTTOM) {
            return Helpers.isBlock(belowState.m_60734_(), TFCTags.Blocks.FARMLAND);
        }
        return Helpers.isBlock(belowState, (Block)this) && belowState.m_61143_(PART) == Part.BOTTOM;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{PART}));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(PART) == Part.TOP) {
            return HALF_SHAPE;
        }
        float growth = (float)((Integer)state.m_61143_((Property)this.m_7959_())).intValue() / (float)this.maxSingleAge;
        if (growth <= 0.25f) {
            return QUARTER_SHAPE;
        }
        if (growth <= 0.5f) {
            return HALF_SHAPE;
        }
        return FULL_SHAPE;
    }

    @Override
    public void growthTick(Level level, BlockPos pos, BlockState state, CropBlockEntity crop) {
        if (state.m_61143_(PART) == Part.BOTTOM) {
            super.growthTick(level, pos, state, crop);
        }
    }

    @Override
    protected void postGrowthTick(Level level, BlockPos pos, BlockState state, CropBlockEntity crop) {
        BlockPos posAbove = pos.m_7494_();
        BlockState stateAbove = level.m_8055_(posAbove);
        int age = Mth.m_14045_((int)((int)(crop.getGrowth() * (float)this.m_7419_())), (int)0, (int)this.m_7419_());
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(age)), 2);
        if (age > this.maxSingleAge && (stateAbove.m_60795_() || stateAbove.m_60734_() == this)) {
            level.m_7731_(posAbove, (BlockState)((BlockState)state.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(age))).m_61124_(PART, (Comparable)((Object)Part.TOP)), 3);
        }
    }

    @Override
    public float getGrowthLimit(Level level, BlockPos pos, BlockState state) {
        return this.isSameOrAir(level.m_8055_(pos.m_7494_())) ? super.getGrowthLimit(level, pos, state) : this.maxSingleGrowth;
    }

    @Override
    public void die(Level level, BlockPos pos, BlockState state, boolean fullyGrown) {
        BlockPos posAbove = pos.m_7494_();
        BlockState stateAbove = level.m_8055_(posAbove);
        BlockState deadState = (BlockState)((Block)this.dead.get()).m_49966_().m_61124_((Property)DeadCropBlock.MATURE, (Comparable)Boolean.valueOf(fullyGrown));
        if (fullyGrown && this.isSameOrAir(stateAbove)) {
            level.m_7731_(posAbove, (BlockState)deadState.m_61124_(DeadDoubleCropBlock.PART, (Comparable)((Object)Part.TOP)), 2);
        } else if (stateAbove.m_60734_() == this) {
            level.m_46961_(posAbove, false);
        }
        level.m_46597_(pos, (BlockState)deadState.m_61124_(DeadDoubleCropBlock.PART, (Comparable)((Object)Part.BOTTOM)));
    }

    protected boolean isSameOrAir(BlockState state) {
        return state.m_60795_() || state.m_60734_() == this;
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, List<Component> text, boolean isDebug) {
        super.addHoeOverlayInfo(level, state.m_61143_(PART) == Part.TOP ? pos.m_7495_() : pos, state, text, isDebug);
    }

    public static enum Part implements StringRepresentable
    {
        BOTTOM,
        TOP;

        private final String serializedName = this.name().toLowerCase(Locale.ROOT);

        public String m_7912_() {
            return this.serializedName;
        }
    }
}

