/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.crop;

import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.CropBlockEntity;
import net.dries007.tfc.common.blockentities.DecayingBlockEntity;
import net.dries007.tfc.common.blockentities.FarmlandBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.crop.Crop;
import net.dries007.tfc.common.blocks.crop.DefaultCropBlock;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.ClimateRange;
import net.dries007.tfc.util.climate.ClimateRanges;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;

public abstract class SpreadingCropBlock
extends DefaultCropBlock {
    private final Supplier<Supplier<? extends Block>> fruit;

    public static SpreadingCropBlock create(ExtendedProperties properties, int stages, Crop crop, Supplier<Supplier<? extends Block>> fruit) {
        final IntegerProperty property = TFCBlockStateProperties.getAgeProperty(stages - 1);
        return new SpreadingCropBlock(properties, stages - 1, (Supplier)TFCBlocks.DEAD_CROPS.get((Object)crop), (Supplier)TFCItems.CROP_SEEDS.get((Object)crop), crop.getPrimaryNutrient(), ClimateRanges.CROPS.get((Object)crop), fruit){

            @Override
            public IntegerProperty m_7959_() {
                return property;
            }
        };
    }

    protected SpreadingCropBlock(ExtendedProperties properties, int maxAge, Supplier<? extends Block> dead, Supplier<? extends Item> seeds, FarmlandBlockEntity.NutrientType primaryNutrient, Supplier<ClimateRange> climateRange, Supplier<Supplier<? extends Block>> fruit) {
        super(properties, maxAge, dead, seeds, primaryNutrient, climateRange);
        this.fruit = fruit;
    }

    @Override
    public float getGrowthLimit(Level level, BlockPos pos, BlockState state) {
        int fruitAround = 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        Block fruit = this.fruit.get().get();
        for (Direction d : Direction.Plane.HORIZONTAL) {
            mutable.m_122159_((Vec3i)pos, d);
            BlockState offsetState = level.m_8055_((BlockPos)mutable);
            if (!Helpers.isBlock(offsetState, fruit) || ++fruitAround <= 2) continue;
            return 0.9f;
        }
        return super.getGrowthLimit(level, pos, state);
    }

    @Override
    protected void postGrowthTick(Level level, BlockPos pos, BlockState state, CropBlockEntity crop) {
        super.postGrowthTick(level, pos, state, crop);
        if (crop.getGrowth() >= 1.0f) {
            Direction offset = Direction.Plane.HORIZONTAL.m_122560_(level.m_5822_());
            BlockPos fruitPos = pos.m_142300_(offset);
            Block fruitBlock = this.fruit.get().get();
            BlockState fruitState = fruitBlock.m_49966_();
            if (fruitState.m_60710_((LevelReader)level, fruitPos) && level.m_8055_(fruitPos).m_60767_().m_76336_()) {
                level.m_46597_(fruitPos, fruitState);
                BlockEntity blockEntity = level.m_7702_(fruitPos);
                if (blockEntity instanceof DecayingBlockEntity) {
                    DecayingBlockEntity decaying = (DecayingBlockEntity)blockEntity;
                    decaying.setStack(new ItemStack((ItemLike)fruitBlock));
                }
                crop.setGrowth(Mth.m_14068_((Random)level.m_5822_(), (float)0.8f, (float)0.87f));
            }
        }
    }
}

