/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.Random;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.AnvilBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.blocks.devices.Tiered;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;

public class AnvilBlock
extends DeviceBlock
implements Tiered {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape SHAPE_X = AnvilBlock.m_49796_((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)11.0, (double)13.0);
    private static final VoxelShape SHAPE_Z = AnvilBlock.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)11.0, (double)16.0);
    private final int tier;

    public static InteractionResult interactWithAnvil(Level level, BlockPos pos, Player player, InteractionHand hand) {
        AnvilBlockEntity anvil = level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.ANVIL.get()).orElse(null);
        if (anvil == null) {
            return InteractionResult.PASS;
        }
        IItemHandler inventory = anvil.getCapability(Capabilities.ITEM).resolve().orElse(null);
        if (inventory == null) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_()) {
            ItemStack playerStack = player.m_21120_(hand);
            if (playerStack.m_41619_()) {
                for (int slot : AnvilBlockEntity.SLOTS_BY_HAND_EXTRACT) {
                    ItemStack anvilStack = inventory.getStackInSlot(slot);
                    if (anvilStack.m_41619_()) continue;
                    ItemStack result = inventory.extractItem(slot, 1, false);
                    player.m_21008_(hand, result);
                    return InteractionResult.SUCCESS;
                }
            } else if (Helpers.isItem(playerStack, TFCTags.Items.HAMMERS)) {
                InteractionResult weldResult = anvil.weld(player);
                if (weldResult == InteractionResult.SUCCESS) {
                    if (level instanceof ServerLevel) {
                        ServerLevel server = (ServerLevel)level;
                        double x = (double)pos.m_123341_() + Mth.m_14064_((Random)level.f_46441_, (double)0.2, (double)0.8);
                        double z = (double)pos.m_123341_() + Mth.m_14064_((Random)level.f_46441_, (double)0.2, (double)0.8);
                        double y = (double)pos.m_123342_() + Mth.m_14064_((Random)level.f_46441_, (double)0.8, (double)1.0);
                        server.m_8767_((ParticleOptions)((SimpleParticleType)TFCParticles.SPARK.get()), x, y, z, 5, (double)Helpers.uniform(level.f_46441_, -5.0f, 5.0f), 1.5 + (double)level.f_46441_.nextFloat(), (double)Helpers.uniform(level.f_46441_, -5.0f, 5.0f), 5.0);
                    }
                    level.m_5594_(null, pos, SoundEvents.f_11671_, SoundSource.PLAYERS, 0.6f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                if (weldResult == InteractionResult.FAIL) {
                    return InteractionResult.SUCCESS;
                }
            } else {
                ItemStack insertStack = playerStack.m_41777_();
                for (int slot : AnvilBlockEntity.SLOTS_BY_HAND_INSERT) {
                    ItemStack resultStack = inventory.insertItem(slot, insertStack, false);
                    if (insertStack.m_41613_() <= resultStack.m_41613_()) continue;
                    player.m_21008_(hand, resultStack);
                    return InteractionResult.SUCCESS;
                }
            }
        } else {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)anvil.anvilProvider(), (BlockPos)pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public AnvilBlock(ExtendedProperties properties, Metal.Tier tier) {
        this(properties, tier.ordinal());
    }

    public AnvilBlock(ExtendedProperties properties, int tier) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.tier = tier;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return AnvilBlock.interactWithAnvil(level, pos, player, hand);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X ? SHAPE_X : SHAPE_Z;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122427_());
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{FACING}));
    }
}

