/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.List;
import net.dries007.tfc.common.blockentities.BarrelBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.SealableDeviceBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.network.NetworkHooks;

public class BarrelBlock
extends SealableDeviceBlock {
    public static void toggleSeal(Level level, BlockPos pos, BlockState state) {
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.BARREL.get()).ifPresent(barrel -> {
            boolean previousSealed = (Boolean)state.m_61143_((Property)SEALED);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SEALED, (Comparable)Boolean.valueOf(!previousSealed)));
            if (previousSealed) {
                barrel.onUnseal();
            } else {
                barrel.onSeal();
            }
        });
    }

    public BarrelBlock(ExtendedProperties properties) {
        super(properties);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BarrelBlockEntity barrel = level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.BARREL.get()).orElse(null);
        if (barrel != null) {
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41619_() && player.m_6144_()) {
                BarrelBlock.toggleSeal(level, pos, state);
                level.m_5594_(null, pos, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 0.85f);
                return InteractionResult.SUCCESS;
            }
            if (FluidHelpers.transferBetweenBlockEntityAndItem(stack, barrel, player, hand)) {
                return InteractionResult.SUCCESS;
            }
            if (!level.m_5776_() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)barrel, (BlockPos)barrel.m_58899_());
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void addExtraInfo(List<Component> tooltip, CompoundTag inventoryTag) {
        FluidTank tank = new FluidTank(((Integer)TFCConfig.SERVER.barrelCapacity.get()).intValue());
        tank.readFromNBT(inventoryTag.m_128469_("tank"));
        if (!tank.isEmpty()) {
            Helpers.addFluidStackTooltipInfo(tank.getFluid(), tooltip);
        }
    }
}

