/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.function.BiPredicate;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.BlastFurnaceBlockEntity;
import net.dries007.tfc.common.blockentities.SheetPileBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.blocks.devices.IBellowsConsumer;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.Metal;
import net.dries007.tfc.util.MultiBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class BlastFurnaceBlock
extends DeviceBlock
implements IBellowsConsumer {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    private static final MultiBlock BLAST_FURNACE_CHIMNEY = new MultiBlock().match(new BlockPos(0, 0, 0), state -> state.m_60795_() || Helpers.isBlock(state, (Block)TFCBlocks.MOLTEN.get())).match(new BlockPos(0, 0, 1), TFCTags.Blocks.BLAST_FURNACE_INSULATION).match(new BlockPos(0, 0, -1), TFCTags.Blocks.BLAST_FURNACE_INSULATION).match(new BlockPos(1, 0, 0), TFCTags.Blocks.BLAST_FURNACE_INSULATION).match(new BlockPos(-1, 0, 0), TFCTags.Blocks.BLAST_FURNACE_INSULATION).match(new BlockPos(0, 0, -2), BlastFurnaceBlock.matchSheet(Direction.SOUTH)).match(new BlockPos(0, 0, 2), BlastFurnaceBlock.matchSheet(Direction.NORTH)).match(new BlockPos(2, 0, 0), BlastFurnaceBlock.matchSheet(Direction.WEST)).match(new BlockPos(-2, 0, 0), BlastFurnaceBlock.matchSheet(Direction.EAST)).match(new BlockPos(-1, 0, -1), BlastFurnaceBlock.matchSheet(Direction.SOUTH, Direction.EAST)).match(new BlockPos(1, 0, -1), BlastFurnaceBlock.matchSheet(Direction.SOUTH, Direction.WEST)).match(new BlockPos(-1, 0, 1), BlastFurnaceBlock.matchSheet(Direction.NORTH, Direction.EAST)).match(new BlockPos(1, 0, 1), BlastFurnaceBlock.matchSheet(Direction.NORTH, Direction.WEST));

    public static boolean isBlastFurnaceInsulationBlock(BlockState state) {
        return state.m_204336_(TFCTags.Blocks.BLAST_FURNACE_INSULATION);
    }

    public static int getChimneyLevels(Level level, BlockPos pos) {
        int maxHeight = (Integer)TFCConfig.SERVER.blastFurnaceMaxChimneyHeight.get();
        for (int i = 0; i < maxHeight; ++i) {
            BlockPos center = pos.m_6630_(i + 1);
            if (BLAST_FURNACE_CHIMNEY.test((LevelAccessor)level, center)) continue;
            return i;
        }
        return maxHeight;
    }

    private static BiPredicate<LevelAccessor, BlockPos> matchSheet(Direction face) {
        return (level, pos) -> {
            BlockState state = level.m_8055_(pos);
            SheetPileBlockEntity pile = level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.SHEET_PILE.get()).orElse(null);
            return Helpers.isBlock(state, (Block)TFCBlocks.SHEET_PILE.get()) && pile != null && BlastFurnaceBlock.isTier3SheetOrHigherInDirection(state, pile, face);
        };
    }

    private static BiPredicate<LevelAccessor, BlockPos> matchSheet(Direction face, Direction secondFace) {
        return (level, pos) -> {
            BlockState state = level.m_8055_(pos);
            SheetPileBlockEntity pile = level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.SHEET_PILE.get()).orElse(null);
            return Helpers.isBlock(state, (Block)TFCBlocks.SHEET_PILE.get()) && pile != null && BlastFurnaceBlock.isTier3SheetOrHigherInDirection(state, pile, face) && BlastFurnaceBlock.isTier3SheetOrHigherInDirection(state, pile, secondFace);
        };
    }

    private static boolean isTier3SheetOrHigherInDirection(BlockState state, SheetPileBlockEntity pile, Direction face) {
        return (Boolean)state.m_61143_((Property)DirectionPropertyBlock.getProperty(face)) != false && pile.getOrCacheMetal(face).getTier() >= Metal.Tier.TIER_III.ordinal();
    }

    public BlastFurnaceBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlastFurnaceBlockEntity blastFurnace = level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.BLAST_FURNACE.get()).orElse(null);
        if (blastFurnace != null) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)blastFurnace, (BlockPos)pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean canAcceptAir(Level level, BlockPos pos, BlockState state) {
        return level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.BLAST_FURNACE.get()).map(BlastFurnaceBlockEntity::hasTuyere).orElse(false);
    }

    @Override
    public void intakeAir(Level level, BlockPos pos, BlockState state, int amount) {
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.BLAST_FURNACE.get()).ifPresent(blastFurnace -> blastFurnace.intakeAir(amount));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{LIT}));
    }
}

