/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.EnumMap;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.MultiBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BloomeryBlock
extends DeviceBlock
implements EntityBlockExtension {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final VoxelShape OPEN_NORTH_SHAPE = Shapes.m_83124_((VoxelShape)BloomeryBlock.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), (VoxelShape[])new VoxelShape[]{BloomeryBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)2.0), BloomeryBlock.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0), BloomeryBlock.m_49796_((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), BloomeryBlock.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)8.0), BloomeryBlock.m_49796_((double)14.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)8.0)});
    public static final VoxelShape OPEN_SOUTH_SHAPE = Shapes.m_83124_((VoxelShape)BloomeryBlock.m_49796_((double)0.0, (double)15.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BloomeryBlock.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)1.0, (double)16.0), BloomeryBlock.m_49796_((double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0), BloomeryBlock.m_49796_((double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), BloomeryBlock.m_49796_((double)0.0, (double)1.0, (double)8.0, (double)2.0, (double)15.0, (double)15.0), BloomeryBlock.m_49796_((double)14.0, (double)1.0, (double)8.0, (double)16.0, (double)15.0, (double)15.0)});
    public static final VoxelShape OPEN_WEST_SHAPE = Shapes.m_83124_((VoxelShape)BloomeryBlock.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BloomeryBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)1.0, (double)16.0), BloomeryBlock.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0), BloomeryBlock.m_49796_((double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0), BloomeryBlock.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)8.0, (double)15.0, (double)2.0), BloomeryBlock.m_49796_((double)1.0, (double)1.0, (double)14.0, (double)8.0, (double)15.0, (double)16.0)});
    public static final VoxelShape OPEN_EAST_SHAPE = Shapes.m_83124_((VoxelShape)BloomeryBlock.m_49796_((double)14.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{BloomeryBlock.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), BloomeryBlock.m_49796_((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), BloomeryBlock.m_49796_((double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), BloomeryBlock.m_49796_((double)8.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)2.0), BloomeryBlock.m_49796_((double)8.0, (double)1.0, (double)14.0, (double)15.0, (double)15.0, (double)16.0)});
    public static final VoxelShape CLOSED_NORTH_SHAPE = BloomeryBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    public static final VoxelShape CLOSED_SOUTH_SHAPE = BloomeryBlock.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape CLOSED_WEST_SHAPE = BloomeryBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    public static final VoxelShape CLOSED_EAST_SHAPE = BloomeryBlock.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final MultiBlock BLOOMERY_CHIMNEY;
    private static final EnumMap<Direction, MultiBlock> BASE_MULTIBLOCKS;
    private static final MultiBlock GATE_Z;
    private static final MultiBlock GATE_X;
    private static final Direction[] NORTH_SOUTH_DOWN;
    private static final Direction[] EAST_WEST_DOWN;

    public static boolean isBloomeryInsulationBlock(BlockState state) {
        return Helpers.isBlock(state, TFCTags.Blocks.BLOOMERY_INSULATION);
    }

    public static int getChimneyLevels(Level level, BlockPos centerPos) {
        for (int i = 1; i < 1 + (Integer)TFCConfig.SERVER.bloomeryMaxChimneyHeight.get(); ++i) {
            BlockPos center = centerPos.m_6630_(i);
            if (BLOOMERY_CHIMNEY.test((LevelAccessor)level, center)) continue;
            return i - 1;
        }
        return (Integer)TFCConfig.SERVER.bloomeryMaxChimneyHeight.get();
    }

    public static boolean canGateStayInPlace(LevelAccessor level, BlockPos pos, Direction.Axis axis) {
        if (axis == Direction.Axis.X) {
            return GATE_X.test(level, pos);
        }
        return GATE_Z.test(level, pos);
    }

    public static boolean isFormed(Level level, BlockPos centerPos, Direction facing) {
        return facing.m_122434_() != Direction.Axis.Y && BASE_MULTIBLOCKS.get(facing).test((LevelAccessor)level, centerPos);
    }

    public BloomeryBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            return;
        }
        double x = pos.m_123341_();
        double y = pos.m_123342_();
        double z = pos.m_123343_();
        level.m_7785_(x, y, z, SoundEvents.f_11715_, SoundSource.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
        level.m_7106_((ParticleOptions)ParticleTypes.f_175834_, x + (double)random.nextFloat(), y + (double)random.nextFloat(), z + (double)random.nextFloat(), 0.0, 0.0, 0.0);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            state = (BlockState)state.m_61122_((Property)OPEN);
            level.m_46597_(pos, state);
            Helpers.playSound(level, pos, (Boolean)state.m_61143_((Property)OPEN) != false ? SoundEvents.f_11873_ : SoundEvents.f_11872_);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        return BloomeryBlock.canGateStayInPlace(level, pos, ((Direction)state.m_61143_((Property)FACING)).m_122434_()) ? state : Blocks.f_50016_.m_49966_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction placeDirection = null;
        for (Direction d : context.m_6232_()) {
            if (d.m_122434_() == Direction.Axis.Y || !BloomeryBlock.canGateStayInPlace((LevelAccessor)context.m_43725_(), context.m_8083_(), d.m_122434_())) continue;
            placeDirection = d;
            break;
        }
        if (placeDirection == null) {
            return Blocks.f_50016_.m_49966_();
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placeDirection.m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{LIT}).m_61104_(new Property[]{OPEN}));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return switch ((Direction)state.m_61143_((Property)FACING)) {
                case Direction.NORTH -> OPEN_NORTH_SHAPE;
                case Direction.SOUTH -> OPEN_SOUTH_SHAPE;
                case Direction.WEST -> OPEN_WEST_SHAPE;
                case Direction.EAST -> OPEN_EAST_SHAPE;
                default -> throw new IllegalArgumentException("Bloomery has no facing direction");
            };
        }
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> CLOSED_NORTH_SHAPE;
            case Direction.SOUTH -> CLOSED_SOUTH_SHAPE;
            case Direction.WEST -> CLOSED_WEST_SHAPE;
            case Direction.EAST -> CLOSED_EAST_SHAPE;
            default -> throw new IllegalArgumentException("Bloomery has no facing direction");
        };
    }

    static {
        NORTH_SOUTH_DOWN = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.DOWN};
        EAST_WEST_DOWN = new Direction[]{Direction.EAST, Direction.WEST, Direction.DOWN};
        BiPredicate<LevelAccessor, BlockPos> stoneMatcher = (level, pos) -> BloomeryBlock.isBloomeryInsulationBlock(level.m_8055_(pos));
        Predicate<BlockState> insideChimney = state -> state.m_60734_() == TFCBlocks.MOLTEN.get() || state.m_60795_();
        Predicate<BlockState> center = state -> state.m_60713_((Block)TFCBlocks.MOLTEN.get()) || state.m_60713_((Block)TFCBlocks.BLOOM.get()) || state.m_60795_();
        BlockPos origin = BlockPos.f_121853_;
        BASE_MULTIBLOCKS = new EnumMap(Direction.class);
        MultiBlock commonMultiblock = new MultiBlock().match(origin, center).match(origin.m_7495_(), stoneMatcher);
        for (Direction d : Direction.Plane.HORIZONTAL) {
            BASE_MULTIBLOCKS.put(d, commonMultiblock.copy().match(origin.m_142300_(d), state -> Helpers.isBlock(state, (Block)TFCBlocks.BLOOMERY.get())).matchEachDirection(origin, stoneMatcher, (Direction[])Direction.Plane.HORIZONTAL.m_122557_().filter(direction -> direction != d).toArray(Direction[]::new), 1).matchEachDirection(origin.m_142300_(d), stoneMatcher, d.m_122434_() == Direction.Axis.Z ? EAST_WEST_DOWN : NORTH_SOUTH_DOWN, 1).matchHorizontal(origin.m_7494_(), stoneMatcher, 1));
        }
        BLOOMERY_CHIMNEY = new MultiBlock().match(origin, insideChimney).matchHorizontal(origin, stoneMatcher, 1);
        GATE_Z = new MultiBlock().match(origin, state -> state.m_60713_((Block)TFCBlocks.BLOOMERY.get()) || state.m_60795_()).matchEachDirection(origin, stoneMatcher, new Direction[]{Direction.WEST, Direction.EAST, Direction.UP, Direction.DOWN}, 1);
        GATE_X = new MultiBlock().match(origin, state -> state.m_60713_((Block)TFCBlocks.BLOOMERY.get()) || state.m_60795_()).matchEachDirection(origin, stoneMatcher, new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.UP, Direction.DOWN}, 1);
    }
}

