/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.List;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.capabilities.size.IItemSize;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.capabilities.size.Weight;
import net.dries007.tfc.util.Alloy;
import net.dries007.tfc.util.Helpers;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class CrucibleBlock
extends DeviceBlock
implements EntityBlockExtension,
IItemSize {
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)CrucibleBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), (VoxelShape[])new VoxelShape[]{CrucibleBlock.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)3.0), CrucibleBlock.m_49796_((double)1.0, (double)1.0, (double)13.0, (double)15.0, (double)16.0, (double)15.0), CrucibleBlock.m_49796_((double)13.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), CrucibleBlock.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)3.0, (double)16.0, (double)15.0)});
    private static final VoxelShape INTERACTION_SHAPE = Shapes.m_83110_((VoxelShape)CrucibleBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), (VoxelShape)CrucibleBlock.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0));

    public CrucibleBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.SAVE);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!player.m_6144_()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.CRUCIBLE.get()).ifPresent(crucible -> NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)crucible, (BlockPos)crucible.m_58899_()));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        return INTERACTION_SHAPE;
    }

    @Override
    public Size getSize(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null && tag.m_128441_("empty") && !tag.m_128471_("empty")) {
            return Size.HUGE;
        }
        return Size.LARGE;
    }

    @Override
    public Weight getWeight(ItemStack stack) {
        return Weight.VERY_HEAVY;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null && tag.m_128441_("empty") && !tag.m_128471_("empty")) {
            CompoundTag inventoryTag = tag.m_128469_("inventory");
            Alloy alloy = new Alloy();
            ItemStackHandler inventory = new ItemStackHandler();
            alloy.deserializeNBT(inventoryTag.m_128469_("alloy"));
            inventory.deserializeNBT(inventoryTag.m_128469_("inventory"));
            tooltip.add((Component)Helpers.translatable("tfc.tooltip.small_vessel.contents").m_130940_(ChatFormatting.DARK_GREEN));
            Helpers.addInventoryTooltipInfo((IItemHandler)inventory, tooltip);
            Helpers.addFluidStackTooltipInfo(alloy.getResultAsFluidStack(), tooltip);
        }
    }
}

