/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class DryingBricksBlock
extends DeviceBlock {
    public static final IntegerProperty COUNT = TFCBlockStateProperties.COUNT_1_4;
    public static final BooleanProperty DRIED = TFCBlockStateProperties.DRIED;
    public static final VoxelShape SHAPE = DryingBricksBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private final Supplier<? extends Item> dryItem;

    public DryingBricksBlock(ExtendedProperties properties, Supplier<? extends Item> dryItem) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.NOOP);
        this.dryItem = dryItem;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)COUNT, (Comparable)Integer.valueOf(1))).m_61124_((Property)DRIED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        return level.m_8055_(pos).m_60734_() == this || !this.canSurvive(level, pos) ? null : super.m_5573_(context);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack held = player.m_21120_(hand);
        if (Helpers.isItem(held, this.m_5456_()) && !player.m_6144_() && !((Boolean)state.m_61143_((Property)DRIED)).booleanValue()) {
            int count = (Integer)state.m_61143_((Property)COUNT);
            if (count < 4) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)COUNT, (Comparable)Integer.valueOf(count + 1)));
                SoundType soundType = this.getSoundType(state, (LevelReader)level, pos, (Entity)player);
                level.m_5594_(null, pos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
                TickCounterBlockEntity.reset(level, pos);
                if (!player.m_7500_()) {
                    held.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        } else if (held.m_41619_() && player.m_6144_()) {
            int count = (Integer)state.m_61143_((Property)COUNT);
            ItemStack drop = new ItemStack((ItemLike)((Boolean)state.m_61143_((Property)DRIED) != false ? (ItemLike)this.dryItem.get() : this.m_5456_()));
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)drop);
            if (count > 1) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)COUNT, (Comparable)Integer.valueOf(count - 1)));
            } else {
                level.m_46961_(pos, false);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Override
    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TickCounterBlockEntity.reset(level, pos);
        super.m_6402_(level, pos, state, placer, stack);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return facing == Direction.DOWN && !facingState.m_60783_((BlockGetter)level, facingPos, Direction.UP) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)DRIED) == false;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTER.get()).ifPresent(counter -> {
            if (level.m_46758_(pos.m_7494_())) {
                counter.resetCounter();
            } else if (counter.getTicksSinceUpdate() > 24000L) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)DRIED, (Comparable)Boolean.valueOf(true)));
            }
        });
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{COUNT, DRIED}));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    private boolean canSurvive(Level level, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        return level.m_8055_(below).m_60783_((BlockGetter)level, below, Direction.UP);
    }
}

