/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.Random;
import net.dries007.tfc.common.TFCDamageSources;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.FirepitBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;

public class GrillBlock
extends FirepitBlock {
    private static final VoxelShape GRILL_SHAPE = Shapes.m_83124_((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{GrillBlock.m_49796_((double)2.0, (double)9.5, (double)3.0, (double)14.0, (double)10.0, (double)13.0), GrillBlock.m_49796_((double)2.0, (double)0.0, (double)13.0, (double)3.0, (double)11.0, (double)14.0), GrillBlock.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)14.0, (double)11.0, (double)14.0), GrillBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)3.0, (double)11.0, (double)3.0), GrillBlock.m_49796_((double)13.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)3.0)});

    public GrillBlock(ExtendedProperties properties) {
        super(properties);
    }

    @Override
    public void m_7100_(BlockState state, Level level, BlockPos pos, Random rand) {
        super.m_7100_(state, level, pos, rand);
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.GRILL.get()).flatMap(grill -> grill.getCapability(Capabilities.ITEM).resolve()).ifPresent(cap -> {
                for (int i = 4; i <= 8; ++i) {
                    if (cap.getStackInSlot(i).m_41619_()) continue;
                    double x = (double)pos.m_123341_() + 0.5;
                    double y = (double)pos.m_123342_() + 0.5;
                    double z = (double)pos.m_123343_() + 0.5;
                    level.m_7785_(x, y, z, SoundEvents.f_11907_, SoundSource.BLOCKS, 0.25f, rand.nextFloat() * 0.7f + 0.4f, false);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + (double)(rand.nextFloat() / 2.0f) - 0.25, y + 0.1, z + (double)(rand.nextFloat() / 2.0f) - 0.25, 0.0, 0.1, 0.0);
                    break;
                }
            });
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        AbstractFirepitBlockEntity firepit = level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.GRILL.get()).orElse(null);
        if (firepit != null) {
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41619_() && player.m_6144_()) {
                if (!level.f_46443_) {
                    if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                        player.m_6469_(TFCDamageSources.GRILL, 1.0f);
                        Helpers.playSound(level, pos, SoundEvents.f_12031_);
                    } else {
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)TFCItems.WROUGHT_IRON_GRILL.get()));
                        AbstractFirepitBlockEntity.convertTo((LevelAccessor)level, pos, state, firepit, (Block)TFCBlocks.FIREPIT.get());
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (Helpers.isItem(stack.m_41720_(), TFCTags.Items.EXTINGUISHER)) {
                firepit.extinguish(state);
                return InteractionResult.SUCCESS;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)firepit, (BlockPos)pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return GRILL_SHAPE;
    }

    @Override
    protected double getParticleHeightOffset() {
        return 0.8;
    }
}

