/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.PitKilnBlockEntity;
import net.dries007.tfc.common.blockentities.PlacedItemBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PlacedItemBlock
extends DeviceBlock
implements IForgeBlockExtension,
EntityBlockExtension {
    public static final BooleanProperty ITEM_0 = TFCBlockStateProperties.ITEM_0;
    public static final BooleanProperty ITEM_1 = TFCBlockStateProperties.ITEM_1;
    public static final BooleanProperty ITEM_2 = TFCBlockStateProperties.ITEM_2;
    public static final BooleanProperty ITEM_3 = TFCBlockStateProperties.ITEM_3;
    public static final BooleanProperty[] ITEM_PROPERTIES = new BooleanProperty[]{ITEM_0, ITEM_1, ITEM_2, ITEM_3};
    private static final VoxelShape SHAPE_0 = PlacedItemBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)1.0, (double)8.0);
    private static final VoxelShape SHAPE_1 = PlacedItemBlock.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)8.0);
    private static final VoxelShape SHAPE_2 = PlacedItemBlock.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)1.0, (double)16.0);
    private static final VoxelShape SHAPE_3 = PlacedItemBlock.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_0, SHAPE_1, SHAPE_2, SHAPE_3};
    private final Map<BlockState, VoxelShape> cachedShapes;

    public static boolean isEmpty(BlockState state) {
        for (int i = 0; i < 4; ++i) {
            if (!((Boolean)state.m_61143_((Property)ITEM_PROPERTIES[i])).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static BlockState updateStateValues(LevelAccessor level, BlockPos pos, BlockState state) {
        for (int i = 0; i < 4; ++i) {
            state = (BlockState)state.m_61124_((Property)ITEM_PROPERTIES[i], (Comparable)Boolean.valueOf(PlacedItemBlock.isSlotSupportedOn(level, pos, level.m_8055_(pos), i)));
        }
        return state;
    }

    public static boolean isSlotSupportedOn(LevelAccessor level, BlockPos pos, BlockState state, int slot) {
        VoxelShape supportShape = state.m_60816_((BlockGetter)level, pos).m_83263_(Direction.UP);
        return !Shapes.m_83157_((VoxelShape)supportShape, (VoxelShape)SHAPES[slot], (BooleanOp)BooleanOp.f_82683_);
    }

    private static Map<BlockState, VoxelShape> makeShapes(ImmutableList<BlockState> possibleStates) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : possibleStates) {
            VoxelShape shape = Shapes.m_83040_();
            for (int i = 0; i < 4; ++i) {
                if (!((Boolean)state.m_61143_((Property)ITEM_PROPERTIES[i])).booleanValue()) continue;
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SHAPES[i]);
            }
            builder.put((Object)state, (Object)shape);
        }
        return builder.build();
    }

    public PlacedItemBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ITEM_0, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ITEM_1, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ITEM_2, (Comparable)Boolean.valueOf(true))).m_61124_((Property)ITEM_3, (Comparable)Boolean.valueOf(true)));
        this.cachedShapes = PlacedItemBlock.makeShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        BlockState updateState = PlacedItemBlock.updateStateValues(level, pos.m_7495_(), state);
        PlacedItemBlockEntity placedItem = level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.PLACED_ITEM.get()).orElse(null);
        if (placedItem != null && PlacedItemBlock.isEmpty(updateState)) {
            return Blocks.f_50016_.m_49966_();
        }
        return updateState;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        PlacedItemBlockEntity placedItem;
        if (!level.m_5776_() && (placedItem = (PlacedItemBlockEntity)level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.PLACED_ITEM.get()).orElse(null)) != null) {
            ItemStack held = player.m_21120_(hand);
            if (Helpers.isItem(held.m_41720_(), TFCTags.Items.PIT_KILN_STRAW) && !held.m_41619_() && PitKilnBlockEntity.isValid(level, pos)) {
                PlacedItemBlockEntity.convertPlacedItemToPitKiln(level, pos, held.m_41620_(1));
                return InteractionResult.SUCCESS;
            }
            return placedItem.onRightClick(player, held, hit) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.cachedShapes.get(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ITEM_0, ITEM_1, ITEM_2, ITEM_3});
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult result, BlockGetter level, BlockPos pos, Player player) {
        if (result instanceof BlockHitResult) {
            BlockHitResult blockResult = (BlockHitResult)result;
            return level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.PLACED_ITEM.get()).map(placedItem -> placedItem.getCloneItemStack(state, blockResult)).orElse(ItemStack.f_41583_);
        }
        return ItemStack.f_41583_;
    }
}

