/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.Random;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.TFCDamageSources;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.FirepitBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;

public class PotBlock
extends FirepitBlock {
    private static final VoxelShape POT_SHAPE = Shapes.m_83124_((VoxelShape)BASE_SHAPE, (VoxelShape[])new VoxelShape[]{PotBlock.m_49796_((double)4.0, (double)6.0, (double)3.0, (double)12.0, (double)9.0, (double)4.0), PotBlock.m_49796_((double)5.0, (double)9.0, (double)4.0, (double)12.0, (double)10.0, (double)5.0), PotBlock.m_49796_((double)4.0, (double)10.0, (double)3.0, (double)12.0, (double)11.0, (double)4.0), PotBlock.m_49796_((double)12.0, (double)6.0, (double)4.0, (double)13.0, (double)9.0, (double)12.0), PotBlock.m_49796_((double)11.0, (double)9.0, (double)5.0, (double)12.0, (double)10.0, (double)12.0), PotBlock.m_49796_((double)12.0, (double)10.0, (double)4.0, (double)13.0, (double)11.0, (double)12.0), PotBlock.m_49796_((double)4.0, (double)6.0, (double)12.0, (double)12.0, (double)9.0, (double)13.0), PotBlock.m_49796_((double)4.0, (double)9.0, (double)11.0, (double)11.0, (double)10.0, (double)12.0), PotBlock.m_49796_((double)4.0, (double)10.0, (double)12.0, (double)12.0, (double)11.0, (double)13.0), PotBlock.m_49796_((double)3.0, (double)6.0, (double)4.0, (double)4.0, (double)9.0, (double)12.0), PotBlock.m_49796_((double)4.0, (double)9.0, (double)4.0, (double)5.0, (double)10.0, (double)11.0), PotBlock.m_49796_((double)3.0, (double)10.0, (double)4.0, (double)4.0, (double)11.0, (double)12.0), PotBlock.m_49796_((double)4.0, (double)5.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0), PotBlock.m_49796_((double)0.0, (double)12.0, (double)7.5, (double)16.0, (double)13.0, (double)8.5), PotBlock.m_49796_((double)1.0, (double)0.0, (double)7.5, (double)2.0, (double)12.0, (double)8.5), PotBlock.m_49796_((double)14.0, (double)0.0, (double)7.5, (double)15.0, (double)12.0, (double)8.5), PotBlock.m_49796_((double)7.5, (double)11.0, (double)3.0, (double)8.5, (double)13.0, (double)4.0), PotBlock.m_49796_((double)7.5, (double)13.0, (double)4.0, (double)8.5, (double)14.0, (double)12.0), PotBlock.m_49796_((double)7.5, (double)11.0, (double)12.0, (double)8.5, (double)13.0, (double)13.0)});

    public PotBlock(ExtendedProperties properties) {
        super(properties);
    }

    @Override
    public void m_7100_(BlockState state, Level level, BlockPos pos, Random rand) {
        super.m_7100_(state, level, pos, rand);
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.POT.get()).ifPresent(pot -> {
            if (!pot.shouldRenderAsBoiling()) {
                return;
            }
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5;
            for (int i = 0; i < rand.nextInt(5) + 4; ++i) {
                level.m_6493_((ParticleOptions)TFCParticles.BUBBLE.get(), false, x + (double)rand.nextFloat() * 0.375 - 0.1875, y + 0.625, z + (double)rand.nextFloat() * 0.375 - 0.1875, 0.0, 0.05, 0.0);
            }
            level.m_6493_((ParticleOptions)TFCParticles.STEAM.get(), false, x, y + 0.8, z, (double)Helpers.triangle(rand), 0.5, (double)Helpers.triangle(rand));
            level.m_7785_(x, y, z, SoundEvents.f_12540_, SoundSource.BLOCKS, 1.0f, rand.nextFloat() * 0.7f + 0.4f, false);
        });
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.POT.get()).map(pot -> {
            InteractionResult interactResult;
            ItemStack stack = player.m_21120_(hand);
            if (!pot.isBoiling() && stack.m_41619_() && player.m_6144_()) {
                if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                    player.m_6469_(TFCDamageSources.POT, 1.0f);
                    Helpers.playSound(level, pos, SoundEvents.f_12031_);
                } else {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)TFCItems.POT.get()));
                    AbstractFirepitBlockEntity.convertTo((LevelAccessor)level, pos, state, pot, (Block)TFCBlocks.FIREPIT.get());
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (Helpers.isItem(stack.m_41720_(), TFCTags.Items.EXTINGUISHER)) {
                pot.extinguish(state);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (!pot.isBoiling() && FluidHelpers.transferBetweenBlockEntityAndItem(stack, pot, player, hand)) {
                pot.markForSync();
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (!pot.isBoiling() && (interactResult = pot.interactWithOutput(player, stack)) != InteractionResult.PASS) {
                return interactResult;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)pot, (BlockPos)pos);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }).orElse(InteractionResult.PASS);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return POT_SHAPE;
    }

    @Override
    protected double getParticleHeightOffset() {
        return 0.8;
    }
}

