/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.Random;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.SealableDeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class PowderkegBlock
extends SealableDeviceBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public static void toggleSeal(Level level, BlockPos pos, BlockState state) {
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.POWDERKEG.get()).ifPresent(powderkeg -> {
            boolean previousSealed = (Boolean)state.m_61143_((Property)SEALED);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SEALED, (Comparable)Boolean.valueOf(!previousSealed)));
            if (previousSealed) {
                powderkeg.onUnseal();
            } else {
                powderkeg.onSeal();
            }
        });
    }

    public PowderkegBlock(ExtendedProperties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)SEALED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.POWDERKEG.get()).map(powderkeg -> {
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41619_() && player.m_6144_()) {
                if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                    powderkeg.setLit(false, (Entity)player);
                    Helpers.playSound(level, pos, SoundEvents.f_11937_);
                } else {
                    PowderkegBlock.toggleSeal(level, pos, state);
                    Helpers.playSound(level, pos, SoundEvents.f_12635_);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (!level.m_5776_() && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)powderkeg, (BlockPos)powderkeg.m_58899_());
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        }).orElse(InteractionResult.PASS);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (!((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.POWDERKEG.get()).ifPresent(keg -> keg.setLit(true, explosion.getExploder()));
        }
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            int count = random.nextInt(3) + 5;
            for (int i = 0; i < count; ++i) {
                double x = (float)pos.m_123341_() + random.nextFloat();
                double z = (float)pos.m_123343_() + random.nextFloat();
                double y = (float)pos.m_123342_() + 0.98f + random.nextFloat() / 5.0f;
                level.m_7106_((ParticleOptions)TFCParticles.SPARK.get(), x, y, z, (double)Helpers.uniform(random, -5.0f, 5.0f), (double)(3.0f + random.nextFloat()), (double)Helpers.uniform(random, -5.0f, 5.0f));
            }
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{LIT}));
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return false;
    }
}

