/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ScrapingBlock
extends DeviceBlock {
    private static final VoxelShape SHAPE = ScrapingBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    private static Vec3 calculatePoint(Vec3 rayVector, Vec3 rayPoint) {
        Vec3 planeNormal = new Vec3(0.0, 1.0, 0.0);
        return rayPoint.m_82546_(rayVector.m_82490_(rayPoint.m_82526_(planeNormal) / rayVector.m_82526_(planeNormal)));
    }

    public ScrapingBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN && !Helpers.isBlock(facingState, TFCTags.Blocks.SCRAPING_SURFACE)) {
            return Blocks.f_50016_.m_49966_();
        }
        return stateIn;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.SCRAPING.get()).map(scraping -> {
            ItemStack stack = player.m_21120_(hand);
            if (Helpers.isItem(stack.m_41720_(), TFCTags.Items.KNIVES)) {
                Vec3 point = ScrapingBlock.calculatePoint(player.m_20154_(), hit.m_82450_().m_82546_(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())));
                scraping.onClicked((float)point.f_82479_, (float)point.f_82481_);
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                if (level instanceof ServerLevel) {
                    ServerLevel server = (ServerLevel)level;
                    scraping.getCapability(Capabilities.ITEM).ifPresent(cap -> server.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, cap.getStackInSlot(0)), (double)pos.m_123341_() + point.f_82479_, (double)pos.m_123342_() + 0.0625, (double)pos.m_123343_() + point.f_82481_, 2, (double)Helpers.triangle(level.f_46441_) / 2.0, level.f_46441_.nextDouble() / 4.0, (double)Helpers.triangle(level.f_46441_) / 2.0, (double)0.15f));
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.PASS;
        }).orElse(InteractionResult.PASS);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

