/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.List;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.capabilities.size.IItemSize;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.capabilities.size.Weight;
import net.dries007.tfc.util.Helpers;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class SealableDeviceBlock
extends DeviceBlock
implements IItemSize {
    public static final BooleanProperty SEALED = TFCBlockStateProperties.SEALED;
    private static final VoxelShape SHAPE = SealableDeviceBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public SealableDeviceBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)SEALED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return context.m_43722_().m_41783_() != null ? (BlockState)this.m_49966_().m_61124_((Property)SEALED, (Comparable)Boolean.valueOf(true)) : this.m_49966_();
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null) {
            CompoundTag inventoryTag = tag.m_128469_("inventory");
            ItemStackHandler inventory = new ItemStackHandler();
            inventory.deserializeNBT(inventoryTag.m_128469_("inventory"));
            if (!Helpers.isEmpty((IItemHandler)inventory)) {
                tooltip.add((Component)Helpers.translatable("tfc.tooltip.contents").m_130940_(ChatFormatting.DARK_GREEN));
                Helpers.addInventoryTooltipInfo((IItemHandler)inventory, tooltip);
            }
            this.addExtraInfo(tooltip, inventoryTag);
        }
    }

    protected void addExtraInfo(List<Component> tooltip, CompoundTag inventoryTag) {
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{SEALED}));
    }

    @Override
    public Size getSize(ItemStack stack) {
        return stack.m_41783_() == null ? Size.VERY_LARGE : Size.HUGE;
    }

    @Override
    public Weight getWeight(ItemStack stack) {
        return Weight.VERY_HEAVY;
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity entity;
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        if (((Boolean)state.m_61143_((Property)SEALED)).booleanValue() && (entity = level.m_7702_(pos)) instanceof InventoryBlockEntity) {
            InventoryBlockEntity inv = (InventoryBlockEntity)entity;
            inv.m_187476_(stack);
        }
        return stack;
    }

    @Override
    protected void beforeRemove(InventoryBlockEntity<?> entity) {
        if (!((Boolean)entity.m_58900_().m_61143_((Property)SEALED)).booleanValue()) {
            entity.ejectInventory();
        }
        entity.invalidateCapabilities();
    }
}

