/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.DirectionPropertyBlock;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SheetPileBlock
extends ExtendedBlock
implements EntityBlockExtension,
DirectionPropertyBlock {
    private static final Map<BooleanProperty, VoxelShape> SHAPES = new ImmutableMap.Builder().put((Object)NORTH, (Object)SheetPileBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0)).put((Object)SOUTH, (Object)SheetPileBlock.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0)).put((Object)EAST, (Object)SheetPileBlock.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).put((Object)WEST, (Object)SheetPileBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0)).put((Object)UP, (Object)SheetPileBlock.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)).put((Object)DOWN, (Object)SheetPileBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)).build();
    private final Map<BlockState, VoxelShape> shapeCache;

    public static void removeSheet(Level level, BlockPos pos, BlockState state, Direction face, @Nullable Player player, boolean doDrops) {
        BlockState newState = (BlockState)state.m_61124_((Property)PROPERTY_BY_DIRECTION.get((Object)face), (Comparable)Boolean.valueOf(false));
        level.m_5594_(null, pos, SoundEvents.f_12062_, SoundSource.BLOCKS, 0.7f, 0.9f + 0.2f * level.m_5822_().nextFloat());
        if (doDrops && (player == null || !player.m_7500_())) {
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.SHEET_PILE.get()).ifPresent(pile -> {
                ItemStack stack = pile.removeSheet(face);
                SheetPileBlock.m_152435_((Level)level, (BlockPos)pos, (Direction)face, (ItemStack)stack);
            });
        }
        if (SheetPileBlock.isEmpty(newState)) {
            level.m_46961_(pos, false);
        } else {
            level.m_7731_(pos, newState, 2);
            level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        }
    }

    public static void addSheet(LevelAccessor level, BlockPos pos, BlockState state, Direction face, ItemStack stack) {
        BlockState newState = (BlockState)state.m_61124_((Property)PROPERTY_BY_DIRECTION.get((Object)face), (Comparable)Boolean.valueOf(true));
        level.m_7731_(pos, newState, 2);
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.SHEET_PILE.get()).ifPresent(pile -> pile.addSheet(face, stack));
        SoundType placementSound = state.getSoundType((LevelReader)level, pos, null);
        level.m_5594_(null, pos, state.getSoundType((LevelReader)level, pos, null).m_56777_(), SoundSource.BLOCKS, (placementSound.m_56773_() + 1.0f) / 2.0f, placementSound.m_56774_() * 0.8f);
    }

    @Nullable
    public static Direction getTargetedFace(Level level, BlockState state, Player player) {
        BlockHitResult result = Helpers.rayTracePlayer(level, player, ClipContext.Fluid.NONE);
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            Vec3 hit = result.m_82450_();
            Direction firstDirection = null;
            for (Map.Entry<BooleanProperty, VoxelShape> entry : SHAPES.entrySet()) {
                BooleanProperty property = entry.getKey();
                if (!((Boolean)state.m_61143_((Property)property)).booleanValue()) continue;
                if (firstDirection == null) {
                    firstDirection = DirectionPropertyBlock.getDirection(property);
                }
                if (!entry.getValue().m_83215_().m_82338_(result.m_82425_()).m_82400_(0.01).m_82390_(hit)) continue;
                return DirectionPropertyBlock.getDirection(property);
            }
            return firstDirection;
        }
        return null;
    }

    public static VoxelShape getShapeForSingleFace(Direction direction) {
        return SHAPES.get(DirectionPropertyBlock.getProperty(direction));
    }

    public static int countSheets(BlockState state, Predicate<Direction> onlyTheseDirections) {
        int count = 0;
        for (Direction direction : Helpers.DIRECTIONS) {
            if (!onlyTheseDirections.test(direction) || !((Boolean)state.m_61143_((Property)DirectionPropertyBlock.getProperty(direction))).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    public static boolean isEmpty(BlockState state) {
        for (BooleanProperty property : PROPERTIES) {
            if (!((Boolean)state.m_61143_((Property)property)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public SheetPileBlock(ExtendedProperties properties) {
        super(properties);
        this.m_49959_(DirectionPropertyBlock.setAllDirections((BlockState)this.m_49965_().m_61090_(), false));
        this.shapeCache = DirectionPropertyBlock.makeShapeCache((StateDefinition<Block, BlockState>)this.m_49965_(), SHAPES::get);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (!neighborState.m_60783_((BlockGetter)level, neighborPos, direction.m_122424_())) {
            level.m_186460_(currentPos, (Block)this, 0);
        }
        return state;
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        for (Direction direction : Helpers.DIRECTIONS) {
            BlockPos adjacentPos;
            BlockState adjacentState;
            if (!((Boolean)state.m_61143_((Property)PROPERTY_BY_DIRECTION.get((Object)direction))).booleanValue() || (adjacentState = level.m_8055_(adjacentPos = pos.m_142300_(direction))).m_60783_((BlockGetter)level, adjacentPos, direction.m_122424_())) continue;
            SheetPileBlock.removeSheet((Level)level, pos, state, direction, null, true);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        for (Direction direction : Helpers.DIRECTIONS) {
            BlockPos adjacentPos;
            BlockState adjacentState;
            if (!((Boolean)state.m_61143_((Property)PROPERTY_BY_DIRECTION.get((Object)direction))).booleanValue() || (adjacentState = level.m_8055_(adjacentPos = pos.m_142300_(direction))).m_60783_((BlockGetter)level, adjacentPos, direction.m_122424_())) continue;
            return false;
        }
        return true;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        Level realLevel;
        Direction targetFace;
        if (level instanceof Level && (targetFace = SheetPileBlock.getTargetedFace(realLevel = (Level)level, state, player)) != null) {
            return level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.SHEET_PILE.get()).map(pile -> pile.getSheet(targetFace)).orElse(ItemStack.f_41583_);
        }
        return ItemStack.f_41583_;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        boolean canActuallyHarvest = state.canHarvestBlock((BlockGetter)level, pos, player);
        Direction targetFace = SheetPileBlock.getTargetedFace(level, state, player);
        this.m_5707_(level, pos, state, player);
        if (targetFace == null) {
            level.m_46961_(pos, false);
        } else {
            SheetPileBlock.removeSheet(level, pos, state, targetFace, player, canActuallyHarvest);
        }
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_((Property[])PROPERTIES));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapeCache.get(state);
    }
}

