/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.devices;

import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.common.blockentities.ComposterBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedBlock;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TFCComposterBlock
extends ExtendedBlock
implements EntityBlockExtension,
HoeOverlayBlock {
    public static final IntegerProperty STAGE = TFCBlockStateProperties.STAGE_8;
    public static final EnumProperty<CompostType> TYPE = TFCBlockStateProperties.COMPOST_TYPE;
    private static final VoxelShape[] SHAPES = (VoxelShape[])Util.m_137469_((Object)new VoxelShape[9], shapes -> {
        shapes[0] = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        for (int i = 1; i < 9; ++i) {
            shapes[i] = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)1.0, (double)Math.max(2, i * 2), (double)1.0, (double)15.0, (double)16.0, (double)15.0), (BooleanOp)BooleanOp.f_82685_);
        }
    });

    public TFCComposterBlock(ExtendedProperties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0))).m_61124_(TYPE, (Comparable)((Object)CompostType.NORMAL)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.COMPOSTER.get()).map(composter -> composter.use(player.m_21120_(hand), player, level.f_46443_)).orElse(InteractionResult.PASS);
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.COMPOSTER.get()).ifPresent(ComposterBlockEntity::randomTick);
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        CompostType type = (CompostType)((Object)state.m_61143_(TYPE));
        if (type == CompostType.NORMAL) {
            return;
        }
        SimpleParticleType particle = type == CompostType.READY ? ((SimpleParticleType)TFCParticles.COMPOST_READY.get()).m_6012_() : ((SimpleParticleType)TFCParticles.COMPOST_ROTTEN.get()).m_6012_();
        double x = (double)pos.m_123341_() + random.nextDouble();
        double y = (double)(pos.m_123342_() + 1) + random.nextDouble() / 5.0;
        double z = (double)pos.m_123343_() + random.nextDouble();
        int count = Mth.m_14072_((Random)random, (int)0, (int)4);
        for (int i = 0; i < count; ++i) {
            level.m_7106_((ParticleOptions)particle, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[(Integer)state.m_61143_((Property)STAGE)];
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return state.m_60710_((LevelReader)level, currentPos) ? state : Blocks.f_50016_.m_49966_();
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos, Direction.UP);
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, List<Component> text, boolean isDebug) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ComposterBlockEntity) {
            ComposterBlockEntity composter = (ComposterBlockEntity)blockEntity;
            if (state.m_61143_(TYPE) != CompostType.ROTTEN) {
                text.add((Component)Helpers.translatable("tfc.composter.green_items", composter.getGreen()).m_130940_(ChatFormatting.GREEN));
                text.add((Component)Helpers.translatable("tfc.composter.brown_items", composter.getBrown()).m_130940_(ChatFormatting.GOLD));
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{STAGE, TYPE}));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.COMPOSTER.get()).ifPresent(TickCounterBlockEntity::resetCounter);
        super.m_6402_(level, pos, state, placer, stack);
    }

    public boolean m_6724_(BlockState state) {
        return state.m_61143_(TYPE) != CompostType.ROTTEN;
    }

    public static enum CompostType implements StringRepresentable
    {
        NORMAL,
        READY,
        ROTTEN;

        private final String serializedName = this.name().toLowerCase(Locale.ROOT);

        public String m_7912_() {
            return this.serializedName;
        }
    }
}

