/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.plant.PlantBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class EpiphytePlantBlock
extends PlantBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final VoxelShape NORTH_SHAPE = EpiphytePlantBlock.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = EpiphytePlantBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0);
    protected static final VoxelShape WEST_SHAPE = EpiphytePlantBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = EpiphytePlantBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    protected static final Map<Direction, VoxelShape> SHAPES = ImmutableMap.of((Object)Direction.NORTH, (Object)NORTH_SHAPE, (Object)Direction.SOUTH, (Object)SOUTH_SHAPE, (Object)Direction.WEST, (Object)WEST_SHAPE, (Object)Direction.EAST, (Object)EAST_SHAPE);

    public static EpiphytePlantBlock create(final RegistryPlant plant, ExtendedProperties properties) {
        return new EpiphytePlantBlock(properties){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }
        };
    }

    protected EpiphytePlantBlock(ExtendedProperties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            level.m_46961_(pos, false);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (direction.m_122424_() == state.m_61143_((Property)FACING) && !Helpers.isBlock(facingState, (TagKey<Block>)BlockTags.f_13106_)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState attachedState = level.m_8055_(pos.m_142300_(((Direction)state.m_61143_((Property)FACING)).m_122424_()));
        return Helpers.isBlock(attachedState, (TagKey<Block>)BlockTags.f_13106_);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_((Property)FACING));
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_();
        if (direction.m_122434_() != Direction.Axis.Y) {
            return (BlockState)this.updateStateWithCurrentMonth(this.m_49966_()).m_61124_((Property)FACING, (Comparable)direction);
        }
        return null;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{FACING}));
    }
}

