/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.plant.PlantBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class FloatingWaterPlantBlock
extends PlantBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)1.5, (double)15.0);
    private final Supplier<? extends Fluid> fluid;

    public static FloatingWaterPlantBlock create(final RegistryPlant plant, Supplier<? extends Fluid> fluid, BlockBehaviour.Properties properties) {
        return new FloatingWaterPlantBlock(ExtendedProperties.of(properties), fluid){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }
        };
    }

    protected FloatingWaterPlantBlock(ExtendedProperties properties, Supplier<? extends Fluid> fluid) {
        super(properties);
        this.fluid = fluid;
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_6425_(pos.m_7495_()).m_76152_().m_6212_(this.fluid.get());
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.m_7892_(state, level, pos, entity);
        if (level instanceof ServerLevel && Helpers.isEntity(entity, TFCTags.Entities.DESTROYS_FLOATING_PLANTS)) {
            level.m_46953_(new BlockPos((Vec3i)pos), true, entity);
        }
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

