/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.plant.PlantBlock;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class HangingPlantBlock
extends PlantBlock {
    protected static final BooleanProperty HANGING = BlockStateProperties.f_61435_;
    protected static final VoxelShape NOT_HANGING_SHAPE = HangingPlantBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public static HangingPlantBlock create(final RegistryPlant plant, ExtendedProperties properties) {
        return new HangingPlantBlock(properties){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }
        };
    }

    protected HangingPlantBlock(ExtendedProperties properties) {
        super(properties);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        for (Direction direction : Direction.Plane.VERTICAL) {
            BlockState attach = level.m_8055_(currentPos.m_142300_(direction));
            if (attach.m_60767_() != Material.f_76274_) continue;
            return (BlockState)state.m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP));
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        for (Direction direction : Direction.Plane.VERTICAL) {
            if (level.m_8055_(pos.m_142300_(direction)).m_60767_() != Material.f_76274_) continue;
            return true;
        }
        return false;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)HANGING)).booleanValue()) {
            return super.m_5940_(state, level, pos, context);
        }
        return NOT_HANGING_SHAPE;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43725_().m_8055_(context.m_8083_().m_142300_(Direction.UP)).m_60767_() == Material.f_76274_) {
            return (BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(true));
        }
        if (context.m_43725_().m_8055_(context.m_8083_().m_142300_(Direction.DOWN)).m_60767_() == Material.f_76274_) {
            return (BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false));
        }
        return null;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HANGING});
    }
}

