/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.KelpTreeBlock;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.fluids.FluidProperty;
import net.dries007.tfc.common.fluids.IFluidLoggable;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;

public abstract class KelpTreeFlowerBlock
extends Block
implements IFluidLoggable {
    public static final IntegerProperty AGE = BlockStateProperties.f_61408_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    private final Supplier<? extends Block> bodyBlock;

    public static KelpTreeFlowerBlock create(BlockBehaviour.Properties builder, Supplier<? extends Block> plant) {
        return new KelpTreeFlowerBlock(builder, (Supplier)plant){

            @Override
            public FluidProperty getFluidProperty() {
                return TFCBlockStateProperties.SALT_WATER;
            }
        };
    }

    protected KelpTreeFlowerBlock(BlockBehaviour.Properties builder, Supplier<? extends Block> bodyBlock) {
        super(builder);
        this.bodyBlock = bodyBlock;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(Fluids.f_76191_))).m_61124_((Property)FACING, (Comparable)Direction.UP));
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 5;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.getFluidProperty(), AGE, FACING});
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        FluidHelpers.tickFluid(level, currentPos, state);
        if (facing != Direction.UP && !state.m_60710_((LevelReader)level, currentPos)) {
            level.m_186460_(currentPos, (Block)this, 1);
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public FluidState m_5888_(BlockState state) {
        return IFluidLoggable.super.getFluidState(state);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        KelpTreeBlock body = (KelpTreeBlock)this.getBodyBlock().get();
        BlockState blockstate = level.m_8055_(pos.m_7495_());
        if (blockstate.m_60734_() != body && !Helpers.isBlock(blockstate, TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON)) {
            if (!this.isEmptyWaterBlock(level, pos.m_7495_())) {
                return false;
            }
            boolean isValid = false;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState relativeState = level.m_8055_(pos.m_142300_(direction));
                if (Helpers.isBlock(relativeState, (Block)body)) {
                    if (isValid) {
                        return false;
                    }
                    isValid = true;
                    continue;
                }
                if (this.isEmptyWaterBlock(level, pos.m_142300_(direction))) continue;
                return false;
            }
            return isValid;
        }
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        int i;
        KelpTreeBlock body = (KelpTreeBlock)this.getBodyBlock().get();
        Fluid fluid = ((FluidProperty.FluidKey)state.m_61143_((Property)this.getFluidProperty())).getFluid();
        BlockPos abovePos = pos.m_7494_();
        if (this.isEmptyWaterBlock((LevelReader)level, abovePos) && abovePos.m_123342_() < level.m_151558_() && (Double)TFCConfig.SERVER.plantGrowthChance.get() > random.nextDouble() && (i = ((Integer)state.m_61143_((Property)AGE)).intValue()) < 5 && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)abovePos, (BlockState)state, (boolean)true)) {
            boolean shouldPlaceNewBody = false;
            boolean foundGroundFurtherDown = false;
            BlockState belowState = level.m_8055_(pos.m_7495_());
            Block belowBlock = belowState.m_60734_();
            if (Helpers.isBlock(belowBlock, TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON)) {
                shouldPlaceNewBody = true;
            } else if (belowBlock == body) {
                int j = 1;
                for (int k = 0; k < 4; ++k) {
                    Block belowBlockOffset = level.m_8055_(pos.m_6625_(j + 1)).m_60734_();
                    if (belowBlockOffset != body) {
                        if (!Helpers.isBlock(belowBlockOffset, TFCTags.Blocks.SEA_BUSH_PLANTABLE_ON)) break;
                        foundGroundFurtherDown = true;
                        break;
                    }
                    ++j;
                }
                if (j < 2 || j <= random.nextInt(foundGroundFurtherDown ? 5 : 4)) {
                    shouldPlaceNewBody = true;
                }
            } else if (this.isEmptyWaterBlock((LevelReader)level, pos.m_7495_())) {
                shouldPlaceNewBody = true;
            }
            if (shouldPlaceNewBody && this.allNeighborsEmpty((LevelReader)level, abovePos, null) && this.isEmptyWaterBlock((LevelReader)level, pos.m_6630_(2))) {
                this.setBodyBlockWithFluid((LevelAccessor)level, pos, fluid);
                this.placeGrownFlower((LevelAccessor)level, abovePos, i, Direction.UP);
            } else if (i < 4) {
                int l = random.nextInt(4);
                if (foundGroundFurtherDown) {
                    ++l;
                }
                boolean foundValidGrowthSpace = false;
                for (int i1 = 0; i1 < l; ++i1) {
                    Direction direction = Direction.Plane.HORIZONTAL.m_122560_(random);
                    BlockPos relativePos = pos.m_142300_(direction);
                    if (!this.isEmptyWaterBlock((LevelReader)level, relativePos) || !this.isEmptyWaterBlock((LevelReader)level, relativePos.m_7495_()) || !this.allNeighborsEmpty((LevelReader)level, relativePos, direction.m_122424_())) continue;
                    this.placeGrownFlower((LevelAccessor)level, relativePos, i + 1, direction);
                    foundValidGrowthSpace = true;
                }
                if (foundValidGrowthSpace) {
                    this.setBodyBlockWithFluid((LevelAccessor)level, pos, fluid);
                } else {
                    this.placeDeadFlower((LevelAccessor)level, pos, (Direction)level.m_8055_(pos).m_61143_((Property)FACING));
                }
            } else {
                this.placeDeadFlower((LevelAccessor)level, pos, (Direction)level.m_8055_(pos).m_61143_((Property)FACING));
            }
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public boolean generatePlant(LevelAccessor level, BlockPos pos, Random rand, int maxHorizontalDistance, Fluid fluid, int seaLevel) {
        if (this.getFluidProperty().canContain(fluid)) {
            BlockState originalState = level.m_8055_(pos);
            this.setBodyBlockWithFluid(level, pos, fluid);
            if (this.growTreeRecursive(level, pos, rand, pos, maxHorizontalDistance, 0, fluid, seaLevel)) {
                return true;
            }
            level.m_7731_(pos, originalState, 3);
        }
        return false;
    }

    public boolean growTreeRecursive(LevelAccessor level, BlockPos branchPos, Random rand, BlockPos originalBranchPos, int maxHorizontalDistance, int iterations, Fluid fluid, int seaLevel) {
        boolean any = false;
        int i = rand.nextInt(5) + 1;
        if (iterations == 0) {
            ++i;
        }
        for (int j = 0; j < i; ++j) {
            BlockPos blockpos = branchPos.m_6630_(j + 1);
            if (!this.allNeighborsEmpty((LevelReader)level, blockpos, null) || blockpos.m_123342_() >= seaLevel - 2) {
                return any;
            }
            if (blockpos.m_123342_() == seaLevel - 3) {
                this.placeGrownFlower(level, blockpos, 5, Direction.UP);
            } else {
                this.setBodyBlockWithFluid(level, blockpos, fluid);
            }
            this.setBodyBlockWithFluid(level, blockpos.m_7495_(), fluid);
        }
        boolean willContinue = false;
        if (iterations < 4) {
            int branchAttempts = rand.nextInt(4);
            if (iterations == 0) {
                ++branchAttempts;
            }
            for (int k = 0; k < branchAttempts; ++k) {
                Direction direction = Direction.Plane.HORIZONTAL.m_122560_(rand);
                BlockPos aboveRelativePos = branchPos.m_6630_(i).m_142300_(direction);
                if (Math.abs(aboveRelativePos.m_123341_() - originalBranchPos.m_123341_()) >= maxHorizontalDistance || Math.abs(aboveRelativePos.m_123343_() - originalBranchPos.m_123343_()) >= maxHorizontalDistance || !this.isEmptyWaterBlock((LevelReader)level, aboveRelativePos) || !this.isEmptyWaterBlock((LevelReader)level, aboveRelativePos.m_7495_()) || !this.allNeighborsEmpty((LevelReader)level, aboveRelativePos, direction.m_122424_())) continue;
                willContinue = true;
                this.setBodyBlockWithFluid(level, aboveRelativePos, fluid);
                this.setBodyBlockWithFluid(level, aboveRelativePos.m_142300_(direction.m_122424_()), fluid);
                this.growTreeRecursive(level, aboveRelativePos, rand, originalBranchPos, maxHorizontalDistance, iterations + 1, fluid, seaLevel);
            }
        }
        if (!willContinue) {
            level.m_7731_(branchPos.m_6630_(i), (BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(rand.nextInt(10) == 1 ? 3 : 5))).m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluid)), 2);
        }
        return true;
    }

    protected boolean isEmptyWaterBlock(LevelReader level, BlockPos pos) {
        return level.m_8055_(pos).m_60734_() == TFCBlocks.SALT_WATER.get();
    }

    protected boolean allNeighborsEmpty(LevelReader level, BlockPos pos, @Nullable Direction excludingSide) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (direction == excludingSide || this.isEmptyWaterBlock(level, pos.m_142300_(direction))) continue;
            return false;
        }
        return true;
    }

    protected void placeGrownFlower(LevelAccessor level, BlockPos pos, int age, Direction facing) {
        Fluid fluid = level.m_6425_(pos).m_76152_();
        level.m_7731_(pos, (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluid))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(age))).m_61124_((Property)FACING, (Comparable)facing), 2);
        level.m_46796_(1033, pos, 0);
    }

    protected void placeDeadFlower(LevelAccessor level, BlockPos pos, Direction facing) {
        Fluid fluid = level.m_6425_(pos).m_76152_();
        level.m_7731_(pos, (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluid))).m_61124_((Property)AGE, (Comparable)Integer.valueOf(5))).m_61124_((Property)FACING, (Comparable)facing), 2);
        level.m_46796_(1034, pos, 0);
    }

    protected void setBodyBlockWithFluid(LevelAccessor level, BlockPos pos, Fluid fluid) {
        BlockState state = this.getBodyStateWithFluid(level, pos, fluid);
        level.m_7731_(pos, state, 2);
    }

    protected BlockState getBodyStateWithFluid(LevelAccessor level, BlockPos pos, Fluid fluid) {
        KelpTreeBlock plant = (KelpTreeBlock)this.getBodyBlock().get();
        return (BlockState)plant.getStateForPlacement((BlockGetter)level, pos).m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluid));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState;
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockState state = this.m_49966_();
        if (world.m_8055_(pos.m_142300_(direction.m_122424_())).m_60713_(this.getBodyBlock().get())) {
            state = (BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_43719_());
        }
        if (!(fluidState = world.m_6425_(context.m_8083_())).m_76178_() && this.getFluidProperty().canContain(fluidState.m_76152_())) {
            return (BlockState)state.m_61124_((Property)this.getFluidProperty(), (Comparable)this.getFluidProperty().keyFor(fluidState.m_76152_()));
        }
        return null;
    }

    protected Supplier<? extends Block> getBodyBlock() {
        return this.bodyBlock;
    }
}

