/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.BodyPlantBlock;
import net.dries007.tfc.common.blocks.plant.CreepingPlantBlock;
import net.dries007.tfc.common.blocks.plant.DryPlantBlock;
import net.dries007.tfc.common.blocks.plant.EpiphytePlantBlock;
import net.dries007.tfc.common.blocks.plant.FloatingWaterPlantBlock;
import net.dries007.tfc.common.blocks.plant.HangingPlantBlock;
import net.dries007.tfc.common.blocks.plant.KelpTreeBlock;
import net.dries007.tfc.common.blocks.plant.KelpTreeFlowerBlock;
import net.dries007.tfc.common.blocks.plant.PlantBlock;
import net.dries007.tfc.common.blocks.plant.ShortGrassBlock;
import net.dries007.tfc.common.blocks.plant.TFCCactusBlock;
import net.dries007.tfc.common.blocks.plant.TFCKelpBlock;
import net.dries007.tfc.common.blocks.plant.TFCKelpTopBlock;
import net.dries007.tfc.common.blocks.plant.TFCSeagrassBlock;
import net.dries007.tfc.common.blocks.plant.TFCTallGrassBlock;
import net.dries007.tfc.common.blocks.plant.TFCVineBlock;
import net.dries007.tfc.common.blocks.plant.TallWaterPlantBlock;
import net.dries007.tfc.common.blocks.plant.TopPlantBlock;
import net.dries007.tfc.common.blocks.plant.WaterPlantBlock;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.WaterLilyBlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;

public final class Plant
extends Enum<Plant>
implements RegistryPlant {
    public static final /* enum */ Plant ATHYRIUM_FERN = new Plant(BlockType.STANDARD, 0.8f);
    public static final /* enum */ Plant CANNA = new Plant(BlockType.STANDARD, 0.8f, new int[]{0, 0, 0, 0, 0, 1, 2, 3, 3, 3, 3, 0});
    public static final /* enum */ Plant GOLDENROD = new Plant(BlockType.STANDARD, 0.6f, new int[]{4, 4, 4, 0, 0, 0, 1, 2, 2, 2, 2, 3});
    public static final /* enum */ Plant PAMPAS_GRASS = new Plant(BlockType.TALL_GRASS, 0.6f);
    public static final /* enum */ Plant PEROVSKIA = new Plant(BlockType.DRY, 0.8f, new int[]{5, 5, 0, 0, 1, 2, 2, 3, 3, 3, 3, 4});
    public static final /* enum */ Plant BLUEGRASS = new Plant(BlockType.SHORT_GRASS, 0.8f, new int[]{0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0});
    public static final /* enum */ Plant BROMEGRASS = new Plant(BlockType.SHORT_GRASS, 0.8f, new int[]{0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0});
    public static final /* enum */ Plant FOUNTAIN_GRASS = new Plant(BlockType.SHORT_GRASS, 0.8f);
    public static final /* enum */ Plant MANATEE_GRASS = new Plant(BlockType.GRASS_WATER, 0.9f, new int[]{3, 0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 2});
    public static final /* enum */ Plant ORCHARD_GRASS = new Plant(BlockType.SHORT_GRASS, 0.8f);
    public static final /* enum */ Plant RYEGRASS = new Plant(BlockType.SHORT_GRASS, 0.8f, new int[]{0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0});
    public static final /* enum */ Plant SCUTCH_GRASS = new Plant(BlockType.SHORT_GRASS, 0.7f);
    public static final /* enum */ Plant STAR_GRASS = new Plant(BlockType.GRASS_WATER, 0.9f, new int[]{3, 0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 2});
    public static final /* enum */ Plant TIMOTHY_GRASS = new Plant(BlockType.SHORT_GRASS, 0.8f);
    public static final /* enum */ Plant RADDIA_GRASS = new Plant(BlockType.SHORT_GRASS, 0.9f, new int[]{3, 0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 2});
    public static final /* enum */ Plant ALLIUM = new Plant(BlockType.STANDARD, 0.8f, new int[]{6, 6, 7, 0, 1, 1, 2, 2, 3, 4, 5, 6});
    public static final /* enum */ Plant ANTHURIUM = new Plant(BlockType.STANDARD, 0.8f, new int[]{0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1});
    public static final /* enum */ Plant ARROWHEAD = new Plant(BlockType.TALL_WATER_FRESH, 0.6f);
    public static final /* enum */ Plant HOUSTONIA = new Plant(BlockType.STANDARD, 0.9f, new int[]{2, 2, 2, 0, 1, 1, 1, 2, 2, 2, 2, 2});
    public static final /* enum */ Plant BADDERLOCKS = new Plant(BlockType.TALL_WATER, 0.8f);
    public static final /* enum */ Plant BARREL_CACTUS = new Plant(BlockType.CACTUS, 0.0f, new int[]{0, 0, 0, 0, 1, 2, 2, 2, 2, 3, 3, 0});
    public static final /* enum */ Plant BLOOD_LILY = new Plant(BlockType.STANDARD, 0.9f, new int[]{3, 0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 2});
    public static final /* enum */ Plant BLUE_ORCHID = new Plant(BlockType.STANDARD, 0.9f, new int[]{2, 2, 2, 0, 1, 1, 1, 2, 2, 2, 2, 2});
    public static final /* enum */ Plant BLUE_GINGER = new Plant(BlockType.STANDARD, 0.8f, new int[]{1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1});
    public static final /* enum */ Plant CATTAIL = new Plant(BlockType.TALL_WATER_FRESH, 0.6f);
    public static final /* enum */ Plant LAMINARIA = new Plant(BlockType.WATER, 0.6f);
    public static final /* enum */ Plant MARIGOLD = new Plant(BlockType.TALL_WATER_FRESH, 0.4f);
    public static final /* enum */ Plant BUR_REED = new Plant(BlockType.TALL_WATER_FRESH, 0.6f, new int[]{0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0});
    public static final /* enum */ Plant BUTTERFLY_MILKWEED = new Plant(BlockType.STANDARD, 0.8f, new int[]{6, 6, 6, 0, 1, 2, 3, 3, 3, 3, 4, 5});
    public static final /* enum */ Plant BLACK_ORCHID = new Plant(BlockType.STANDARD, 0.8f, new int[]{2, 2, 2, 0, 1, 1, 1, 2, 2, 2, 2, 2});
    public static final /* enum */ Plant COONTAIL = new Plant(BlockType.GRASS_WATER_FRESH, 0.7f, new int[]{3, 0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 2});
    public static final /* enum */ Plant DANDELION = new Plant(BlockType.STANDARD, 0.9f, new int[]{9, 9, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8});
    public static final /* enum */ Plant DEAD_BUSH = new Plant(BlockType.DRY, 0.9f);
    public static final /* enum */ Plant DESERT_FLAME = new Plant(BlockType.STANDARD, 0.8f, new int[]{1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1});
    public static final /* enum */ Plant DUCKWEED = new Plant(BlockType.FLOATING_FRESH, 0.8f);
    public static final /* enum */ Plant EEL_GRASS = new Plant(BlockType.GRASS_WATER_FRESH, 0.9f, new int[]{3, 0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 2});
    public static final /* enum */ Plant FIELD_HORSETAIL = new Plant(BlockType.STANDARD, 0.7f, new int[]{1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1});
    public static final /* enum */ Plant FOXGLOVE = new Plant(BlockType.TALL_GRASS, 0.8f, new int[]{0, 0, 0, 0, 0, 1, 1, 2, 3, 3, 3, 4});
    public static final /* enum */ Plant GRAPE_HYACINTH = new Plant(BlockType.STANDARD, 0.8f, new int[]{3, 3, 3, 0, 1, 1, 2, 3, 3, 3, 3, 3});
    public static final /* enum */ Plant GUTWEED = new Plant(BlockType.WATER, 0.9f);
    public static final /* enum */ Plant HELICONIA = new Plant(BlockType.STANDARD, 0.8f, new int[]{0, 0, 1, 2, 0, 0, 0, 0, 1, 2, 0, 0});
    public static final /* enum */ Plant HIBISCUS = new Plant(BlockType.TALL_GRASS, 0.9f, new int[]{2, 2, 2, 0, 0, 0, 0, 0, 0, 1, 2, 2});
    public static final /* enum */ Plant KANGAROO_PAW = new Plant(BlockType.STANDARD, 0.8f, new int[]{1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1});
    public static final /* enum */ Plant KING_FERN = new Plant(BlockType.TALL_GRASS, 0.4f);
    public static final /* enum */ Plant LABRADOR_TEA = new Plant(BlockType.STANDARD, 0.8f, new int[]{0, 0, 1, 2, 3, 4, 4, 5, 6, 0, 0, 0});
    public static final /* enum */ Plant LADY_FERN = new Plant(BlockType.STANDARD, 0.6f);
    public static final /* enum */ Plant LICORICE_FERN = new Plant(BlockType.EPIPHYTE, 0.7f);
    public static final /* enum */ Plant LILAC = new Plant(BlockType.TALL_GRASS, 0.7f, new int[]{0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0});
    public static final /* enum */ Plant LOTUS = new Plant(BlockType.FLOATING_FRESH, 0.9f, new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 0, 0});
    public static final /* enum */ Plant CALENDULA = new Plant(BlockType.STANDARD, 0.8f, new int[]{6, 6, 6, 0, 1, 2, 3, 3, 3, 3, 4, 5});
    public static final /* enum */ Plant MEADS_MILKWEED = new Plant(BlockType.STANDARD, 0.8f, new int[]{6, 6, 6, 0, 1, 2, 3, 3, 3, 3, 4, 5});
    public static final /* enum */ Plant MILFOIL = new Plant(BlockType.WATER_FRESH, 0.7f);
    public static final /* enum */ Plant MORNING_GLORY = new Plant(BlockType.CREEPING, 0.9f, new int[]{2, 2, 2, 0, 0, 1, 1, 1, 1, 1, 2, 2});
    public static final /* enum */ Plant MOSS = new Plant(BlockType.CREEPING, 0.7f);
    public static final /* enum */ Plant NASTURTIUM = new Plant(BlockType.STANDARD, 0.8f, new int[]{4, 4, 4, 0, 1, 2, 2, 2, 2, 2, 3, 3});
    public static final /* enum */ Plant OSTRICH_FERN = new Plant(BlockType.TALL_GRASS, 0.6f, new int[]{0, 0, 0, 0, 1, 2, 3, 3, 3, 3, 4, 0});
    public static final /* enum */ Plant OXEYE_DAISY = new Plant(BlockType.STANDARD, 0.9f, new int[]{5, 5, 5, 0, 1, 2, 3, 3, 3, 4, 4, 5});
    public static final /* enum */ Plant PHRAGMITE = new Plant(BlockType.TALL_WATER_FRESH, 0.6f, new int[]{0, 0, 0, 1, 1, 1, 2, 2, 3, 1, 1, 0});
    public static final /* enum */ Plant PICKERELWEED = new Plant(BlockType.TALL_WATER_FRESH, 0.6f, new int[]{0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 0, 0});
    public static final /* enum */ Plant PISTIA = new Plant(BlockType.FLOATING_FRESH, 0.8f);
    public static final /* enum */ Plant POPPY = new Plant(BlockType.STANDARD, 0.9f, new int[]{4, 4, 4, 0, 1, 2, 2, 3, 3, 3, 3, 4});
    public static final /* enum */ Plant PRIMROSE = new Plant(BlockType.STANDARD, 0.9f, new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2});
    public static final /* enum */ Plant PULSATILLA = new Plant(BlockType.STANDARD, 0.8f, new int[]{0, 1, 2, 3, 3, 4, 5, 5, 5, 0, 0, 0});
    public static final /* enum */ Plant REINDEER_LICHEN = new Plant(BlockType.CREEPING, 0.7f);
    public static final /* enum */ Plant RED_SEALING_WAX_PALM = new Plant(BlockType.TALL_GRASS, 0.4f);
    public static final /* enum */ Plant ROSE = new Plant(BlockType.TALL_GRASS, 0.9f, new int[]{0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0});
    public static final /* enum */ Plant SACRED_DATURA = new Plant(BlockType.STANDARD, 0.8f, new int[]{3, 3, 3, 0, 1, 2, 2, 2, 2, 2, 2, 2});
    public static final /* enum */ Plant SAGEBRUSH = new Plant(BlockType.DRY, 0.5f, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0});
    public static final /* enum */ Plant SAGO = new Plant(BlockType.WATER_FRESH, 0.7f);
    public static final /* enum */ Plant SAPPHIRE_TOWER = new Plant(BlockType.TALL_GRASS, 0.6f, new int[]{2, 3, 0, 0, 0, 1, 2, 2, 2, 2, 2, 2});
    public static final /* enum */ Plant SARGASSUM = new Plant(BlockType.FLOATING, 0.9f);
    public static final /* enum */ Plant GUZMANIA = new Plant(BlockType.EPIPHYTE, 0.9f);
    public static final /* enum */ Plant SILVER_SPURFLOWER = new Plant(BlockType.STANDARD, 0.8f, new int[]{0, 0, 0, 0, 1, 2, 2, 2, 0, 0, 0, 0});
    public static final /* enum */ Plant SNAPDRAGON_PINK = new Plant(BlockType.STANDARD, 0.8f, new int[]{6, 6, 6, 0, 1, 1, 2, 3, 4, 1, 1, 5});
    public static final /* enum */ Plant SNAPDRAGON_RED = new Plant(BlockType.STANDARD, 0.8f, new int[]{6, 6, 6, 0, 1, 1, 2, 3, 4, 1, 1, 5});
    public static final /* enum */ Plant SNAPDRAGON_WHITE = new Plant(BlockType.STANDARD, 0.8f, new int[]{6, 6, 6, 0, 1, 1, 2, 3, 4, 1, 1, 5});
    public static final /* enum */ Plant SNAPDRAGON_YELLOW = new Plant(BlockType.STANDARD, 0.8f, new int[]{6, 6, 6, 0, 1, 1, 2, 3, 4, 1, 1, 5});
    public static final /* enum */ Plant SPANISH_MOSS = new Plant(BlockType.HANGING, 0.7f);
    public static final /* enum */ Plant STRELITZIA = new Plant(BlockType.STANDARD, 0.8f, new int[]{0, 0, 1, 1, 2, 2, 0, 0, 1, 1, 2, 2});
    public static final /* enum */ Plant SWITCHGRASS = new Plant(BlockType.TALL_GRASS, 0.7f, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0});
    public static final /* enum */ Plant SWORD_FERN = new Plant(BlockType.STANDARD, 0.7f);
    public static final /* enum */ Plant TALL_FESCUE_GRASS = new Plant(BlockType.TALL_GRASS, 0.5f);
    public static final /* enum */ Plant TOQUILLA_PALM = new Plant(BlockType.TALL_GRASS, 0.4f);
    public static final /* enum */ Plant TRILLIUM = new Plant(BlockType.STANDARD, 0.8f, new int[]{5, 5, 5, 0, 1, 2, 3, 3, 4, 4, 4, 4});
    public static final /* enum */ Plant TROPICAL_MILKWEED = new Plant(BlockType.STANDARD, 0.8f, new int[]{0, 0, 0, 0, 1, 2, 3, 3, 3, 3, 3, 0});
    public static final /* enum */ Plant TULIP_ORANGE = new Plant(BlockType.STANDARD, 0.9f, new int[]{4, 4, 5, 0, 1, 1, 2, 2, 2, 2, 3, 4});
    public static final /* enum */ Plant TULIP_PINK = new Plant(BlockType.STANDARD, 0.9f, new int[]{4, 4, 5, 0, 1, 1, 2, 2, 2, 2, 3, 4});
    public static final /* enum */ Plant TULIP_RED = new Plant(BlockType.STANDARD, 0.9f, new int[]{4, 4, 5, 0, 1, 1, 2, 2, 2, 2, 3, 4});
    public static final /* enum */ Plant TULIP_WHITE = new Plant(BlockType.STANDARD, 0.9f, new int[]{4, 4, 5, 0, 1, 1, 2, 2, 2, 2, 3, 4});
    public static final /* enum */ Plant TURTLE_GRASS = new Plant(BlockType.GRASS_WATER, 0.9f, new int[]{3, 0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 2});
    public static final /* enum */ Plant VRIESEA = new Plant(BlockType.EPIPHYTE, 0.8f, new int[]{1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0});
    public static final /* enum */ Plant WATER_CANNA = new Plant(BlockType.FLOATING_FRESH, 0.8f, new int[]{0, 0, 0, 0, 0, 1, 2, 3, 3, 3, 3, 0});
    public static final /* enum */ Plant WATER_LILY = new Plant(BlockType.FLOATING_FRESH, 0.8f, new int[]{5, 5, 6, 0, 1, 2, 2, 2, 2, 3, 4, 5});
    public static final /* enum */ Plant WATER_TARO = new Plant(BlockType.TALL_WATER_FRESH, 0.6f);
    public static final /* enum */ Plant YUCCA = new Plant(BlockType.DRY, 0.8f, new int[]{0, 0, 0, 0, 0, 1, 2, 2, 2, 2, 2, 3});
    public static final /* enum */ Plant HANGING_VINES_PLANT = new Plant(BlockType.WEEPING, 1.0f);
    public static final /* enum */ Plant HANGING_VINES = new Plant(BlockType.WEEPING_TOP, 1.0f);
    public static final /* enum */ Plant LIANA_PLANT = new Plant(BlockType.WEEPING, 1.0f);
    public static final /* enum */ Plant LIANA = new Plant(BlockType.WEEPING_TOP, 1.0f);
    public static final /* enum */ Plant TREE_FERN_PLANT = new Plant(BlockType.TWISTING_SOLID, 0.0f);
    public static final /* enum */ Plant TREE_FERN = new Plant(BlockType.TWISTING_SOLID_TOP, 0.0f);
    public static final /* enum */ Plant ARUNDO_PLANT = new Plant(BlockType.TWISTING, 0.3f);
    public static final /* enum */ Plant ARUNDO = new Plant(BlockType.TWISTING_TOP, 0.3f);
    public static final /* enum */ Plant DRY_PHRAGMITE_PLANT = new Plant(BlockType.TWISTING, 0.3f);
    public static final /* enum */ Plant DRY_PHRAGMITE = new Plant(BlockType.TWISTING_TOP, 0.3f);
    public static final /* enum */ Plant WINGED_KELP_PLANT = new Plant(BlockType.KELP, 0.7f);
    public static final /* enum */ Plant WINGED_KELP = new Plant(BlockType.KELP_TOP, 1.0f);
    public static final /* enum */ Plant LEAFY_KELP_PLANT = new Plant(BlockType.KELP, 0.7f);
    public static final /* enum */ Plant LEAFY_KELP = new Plant(BlockType.KELP_TOP, 1.0f);
    public static final /* enum */ Plant GIANT_KELP_PLANT = new Plant(BlockType.KELP_TREE, 0.2f);
    public static final /* enum */ Plant GIANT_KELP_FLOWER = new Plant(BlockType.KELP_TREE_FLOWER, 1.0f);
    public static final /* enum */ Plant IVY = new Plant(BlockType.VINE, 1.0f);
    public static final /* enum */ Plant JUNGLE_VINES = new Plant(BlockType.VINE, 1.0f);
    private final float speedFactor;
    @Nullable
    private final IntegerProperty property;
    private final int @Nullable [] stagesByMonth;
    private final BlockType type;
    private static final /* synthetic */ Plant[] $VALUES;

    public static Plant[] values() {
        return (Plant[])$VALUES.clone();
    }

    public static Plant valueOf(String name) {
        return Enum.valueOf(Plant.class, name);
    }

    private Plant(BlockType type, float speedFactor) {
        this(type, speedFactor, null);
    }

    private Plant(@Nullable BlockType type, float speedFactor, int[] stagesByMonth) {
        this.type = type;
        this.speedFactor = speedFactor;
        this.stagesByMonth = stagesByMonth;
        int maxStage = 0;
        if (stagesByMonth != null) {
            maxStage = Arrays.stream(stagesByMonth).max().orElse(0);
        }
        this.property = maxStage > 0 ? TFCBlockStateProperties.getStageProperty(maxStage) : null;
    }

    public Block create() {
        return this.type.factory.apply(this, this.type);
    }

    @Nullable
    public Function<Block, BlockItem> createBlockItem(Item.Properties properties) {
        return this.needsItem() ? block -> this.type.blockItemFactory.apply((Block)block, properties) : null;
    }

    @Override
    public int stageFor(Month month) {
        assert (this.stagesByMonth != null);
        return this.stagesByMonth.length < month.ordinal() ? 0 : this.stagesByMonth[month.ordinal()];
    }

    @Override
    @Nullable
    public IntegerProperty getStageProperty() {
        return this.property;
    }

    public boolean needsItem() {
        return this.type != BlockType.WEEPING && this.type != BlockType.TWISTING_SOLID && this.type != BlockType.KELP && this.type != BlockType.KELP_TREE && this.type != BlockType.TWISTING;
    }

    public boolean isFoliage() {
        return this.type == BlockType.WEEPING || this.type == BlockType.WEEPING_TOP || this.type == BlockType.FLOATING_FRESH || this.type == BlockType.FLOATING || this.type == BlockType.WATER_FRESH || this.type == BlockType.GRASS_WATER_FRESH || this.type == BlockType.GRASS_WATER;
    }

    public boolean isSeasonal() {
        return this.type == BlockType.VINE;
    }

    public boolean isTallGrass() {
        return this.type == BlockType.TALL_GRASS || this.type == BlockType.SHORT_GRASS;
    }

    public boolean isItemTinted() {
        return this == BLUEGRASS || this == BROMEGRASS || this == FOUNTAIN_GRASS || this == ORCHARD_GRASS || this == RYEGRASS || this == SCUTCH_GRASS || this == TIMOTHY_GRASS || this == KANGAROO_PAW || this == KING_FERN || this == MOSS || this == SAGO || this == SWITCHGRASS || this == TALL_FESCUE_GRASS || this == IVY || this == JUNGLE_VINES || this == HANGING_VINES || this == GUTWEED;
    }

    private Supplier<? extends Block> transform() {
        return (Supplier)TFCBlocks.PLANTS.get(switch (this) {
            case HANGING_VINES -> HANGING_VINES_PLANT;
            case HANGING_VINES_PLANT -> HANGING_VINES;
            case TREE_FERN -> TREE_FERN_PLANT;
            case TREE_FERN_PLANT -> TREE_FERN;
            case WINGED_KELP_PLANT -> WINGED_KELP;
            case WINGED_KELP -> WINGED_KELP_PLANT;
            case GIANT_KELP_FLOWER -> GIANT_KELP_PLANT;
            case LEAFY_KELP -> LEAFY_KELP_PLANT;
            case LEAFY_KELP_PLANT -> LEAFY_KELP;
            case ARUNDO -> ARUNDO_PLANT;
            case ARUNDO_PLANT -> ARUNDO;
            case DRY_PHRAGMITE -> DRY_PHRAGMITE_PLANT;
            case DRY_PHRAGMITE_PLANT -> DRY_PHRAGMITE;
            case LIANA -> LIANA_PLANT;
            case LIANA_PLANT -> LIANA;
            default -> throw new IllegalStateException("Uhh why did you try to transform something that's not a tall plant?");
        });
    }

    private static /* synthetic */ Plant[] $values() {
        return new Plant[]{ATHYRIUM_FERN, CANNA, GOLDENROD, PAMPAS_GRASS, PEROVSKIA, BLUEGRASS, BROMEGRASS, FOUNTAIN_GRASS, MANATEE_GRASS, ORCHARD_GRASS, RYEGRASS, SCUTCH_GRASS, STAR_GRASS, TIMOTHY_GRASS, RADDIA_GRASS, ALLIUM, ANTHURIUM, ARROWHEAD, HOUSTONIA, BADDERLOCKS, BARREL_CACTUS, BLOOD_LILY, BLUE_ORCHID, BLUE_GINGER, CATTAIL, LAMINARIA, MARIGOLD, BUR_REED, BUTTERFLY_MILKWEED, BLACK_ORCHID, COONTAIL, DANDELION, DEAD_BUSH, DESERT_FLAME, DUCKWEED, EEL_GRASS, FIELD_HORSETAIL, FOXGLOVE, GRAPE_HYACINTH, GUTWEED, HELICONIA, HIBISCUS, KANGAROO_PAW, KING_FERN, LABRADOR_TEA, LADY_FERN, LICORICE_FERN, LILAC, LOTUS, CALENDULA, MEADS_MILKWEED, MILFOIL, MORNING_GLORY, MOSS, NASTURTIUM, OSTRICH_FERN, OXEYE_DAISY, PHRAGMITE, PICKERELWEED, PISTIA, POPPY, PRIMROSE, PULSATILLA, REINDEER_LICHEN, RED_SEALING_WAX_PALM, ROSE, SACRED_DATURA, SAGEBRUSH, SAGO, SAPPHIRE_TOWER, SARGASSUM, GUZMANIA, SILVER_SPURFLOWER, SNAPDRAGON_PINK, SNAPDRAGON_RED, SNAPDRAGON_WHITE, SNAPDRAGON_YELLOW, SPANISH_MOSS, STRELITZIA, SWITCHGRASS, SWORD_FERN, TALL_FESCUE_GRASS, TOQUILLA_PALM, TRILLIUM, TROPICAL_MILKWEED, TULIP_ORANGE, TULIP_PINK, TULIP_RED, TULIP_WHITE, TURTLE_GRASS, VRIESEA, WATER_CANNA, WATER_LILY, WATER_TARO, YUCCA, HANGING_VINES_PLANT, HANGING_VINES, LIANA_PLANT, LIANA, TREE_FERN_PLANT, TREE_FERN, ARUNDO_PLANT, ARUNDO, DRY_PHRAGMITE_PLANT, DRY_PHRAGMITE, WINGED_KELP_PLANT, WINGED_KELP, LEAFY_KELP_PLANT, LEAFY_KELP, GIANT_KELP_PLANT, GIANT_KELP_FLOWER, IVY, JUNGLE_VINES};
    }

    static {
        $VALUES = Plant.$values();
    }

    static enum BlockType {
        STANDARD((plant, type) -> PlantBlock.create(plant, BlockType.fire(BlockType.nonSolid(plant)))),
        CACTUS((plant, type) -> TFCCactusBlock.create(plant, BlockType.fire(BlockType.solid().m_60978_(0.25f).m_60918_(SoundType.f_56745_)).pathType(BlockPathTypes.DAMAGE_CACTUS))),
        DRY((plant, type) -> DryPlantBlock.create(plant, BlockType.fire(BlockType.nonSolid(plant)))),
        CREEPING((plant, type) -> CreepingPlantBlock.create(plant, BlockType.fire(BlockType.nonSolid(plant).m_60982_(TFCBlocks::always)))),
        HANGING((plant, type) -> HangingPlantBlock.create(plant, BlockType.fire(BlockType.nonSolid(plant).m_60982_(TFCBlocks::always)))),
        EPIPHYTE((plant, type) -> EpiphytePlantBlock.create(plant, BlockType.fire(BlockType.nonSolid(plant).m_60982_(TFCBlocks::always)))),
        SHORT_GRASS((plant, type) -> ShortGrassBlock.create(plant, BlockType.fire(BlockType.nonSolid(plant)))),
        TALL_GRASS((plant, type) -> TFCTallGrassBlock.create(plant, BlockType.fire(BlockType.nonSolid(plant)))),
        VINE((plant, type) -> new TFCVineBlock(BlockType.fire(BlockType.nonSolid(plant)))),
        WEEPING((plant, type) -> new BodyPlantBlock(BlockType.fire(BlockType.nonSolidTallPlant(plant)), plant.transform(), BodyPlantBlock.BODY_SHAPE, Direction.DOWN)),
        WEEPING_TOP((plant, type) -> new TopPlantBlock(BlockType.fire(BlockType.nonSolidTallPlant(plant)), plant.transform(), Direction.DOWN, BodyPlantBlock.WEEPING_SHAPE)),
        TWISTING((plant, type) -> new BodyPlantBlock(BlockType.fire(BlockType.nonSolidTallPlant(plant)), plant.transform(), BodyPlantBlock.BODY_SHAPE, Direction.UP)),
        TWISTING_TOP((plant, type) -> new TopPlantBlock(BlockType.fire(BlockType.nonSolidTallPlant(plant)), plant.transform(), Direction.UP, BodyPlantBlock.TWISTING_SHAPE)),
        TWISTING_SOLID((plant, type) -> new BodyPlantBlock(BlockType.fire(BlockType.solidTallPlant()), plant.transform(), BodyPlantBlock.BODY_SHAPE, Direction.UP)),
        TWISTING_SOLID_TOP((plant, type) -> new TopPlantBlock(BlockType.fire(BlockType.solidTallPlant()), plant.transform(), Direction.UP, BodyPlantBlock.TWISTING_SHAPE)),
        KELP((plant, type) -> TFCKelpBlock.create(BlockType.nonSolidTallPlant(plant).lootFrom(plant.transform()), plant.transform(), Direction.UP, BodyPlantBlock.THIN_BODY_SHAPE, TFCBlockStateProperties.SALT_WATER)),
        KELP_TOP((plant, type) -> TFCKelpTopBlock.create(BlockType.nonSolidTallPlant(plant), plant.transform(), Direction.UP, BodyPlantBlock.TWISTING_THIN_SHAPE, TFCBlockStateProperties.SALT_WATER)),
        KELP_TREE((plant, type) -> KelpTreeBlock.create(BlockType.kelp(plant), TFCBlockStateProperties.SALT_WATER)),
        KELP_TREE_FLOWER((plant, type) -> KelpTreeFlowerBlock.create(BlockType.kelp(plant), plant.transform())),
        FLOATING((plant, type) -> FloatingWaterPlantBlock.create(plant, TFCFluids.SALT_WATER.source(), BlockType.nonSolid(plant)), WaterLilyBlockItem::new),
        FLOATING_FRESH((plant, type) -> FloatingWaterPlantBlock.create(plant, () -> Fluids.f_76193_, BlockType.nonSolid(plant)), WaterLilyBlockItem::new),
        TALL_WATER((plant, type) -> TallWaterPlantBlock.create(plant, TFCBlockStateProperties.SALT_WATER, BlockType.nonSolid(plant))),
        TALL_WATER_FRESH((plant, type) -> TallWaterPlantBlock.create(plant, TFCBlockStateProperties.FRESH_WATER, BlockType.nonSolid(plant))),
        WATER((plant, type) -> WaterPlantBlock.create(plant, TFCBlockStateProperties.SALT_WATER, BlockType.nonSolid(plant))),
        WATER_FRESH((plant, type) -> WaterPlantBlock.create(plant, TFCBlockStateProperties.FRESH_WATER, BlockType.nonSolid(plant))),
        GRASS_WATER((plant, type) -> TFCSeagrassBlock.create(plant, TFCBlockStateProperties.SALT_WATER, BlockType.nonSolid(plant))),
        GRASS_WATER_FRESH((plant, type) -> TFCSeagrassBlock.create(plant, TFCBlockStateProperties.FRESH_WATER, BlockType.nonSolid(plant)));

        private final BiFunction<Plant, BlockType, ? extends Block> factory;
        private final BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory;

        private static BlockBehaviour.Properties solid() {
            return BlockBehaviour.Properties.m_60939_((Material)Material.f_76302_).m_60955_().m_60918_(SoundType.f_56740_).m_60977_();
        }

        private static BlockBehaviour.Properties nonSolid(Plant plant) {
            return BlockType.solid().m_60966_().m_60956_(plant.speedFactor).m_60910_();
        }

        private static BlockBehaviour.Properties solidTallPlant() {
            return BlockBehaviour.Properties.m_60944_((Material)Material.f_76300_, (MaterialColor)MaterialColor.f_76405_).m_60977_().m_60918_(SoundType.f_56714_);
        }

        private static BlockBehaviour.Properties nonSolidTallPlant(Plant plant) {
            return BlockType.solidTallPlant().m_60966_().m_60910_().m_60956_(plant.speedFactor);
        }

        private static BlockBehaviour.Properties kelp(Plant plant) {
            return BlockBehaviour.Properties.m_60944_((Material)Material.f_76314_, (MaterialColor)MaterialColor.f_76405_).m_60910_().m_60977_().m_60956_(plant.speedFactor).m_60978_(1.0f).m_60918_(SoundType.f_56752_);
        }

        private static ExtendedProperties fire(BlockBehaviour.Properties properties) {
            return ExtendedProperties.of(properties).flammable(60, 30);
        }

        private BlockType(BiFunction<Plant, BlockType, ? extends Block> factory) {
            this(factory, BlockItem::new);
        }

        private BlockType(BiFunction<Plant, BlockType, ? extends Block> factory, BiFunction<Block, Item.Properties, ? extends BlockItem> blockItemFactory) {
            this.factory = factory;
            this.blockItemFactory = blockItemFactory;
        }
    }
}

