/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import java.util.Random;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.TFCBushBlock;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class PlantBlock
extends TFCBushBlock {
    public static final IntegerProperty AGE = TFCBlockStateProperties.AGE_3;
    protected static final VoxelShape PLANT_SHAPE = PlantBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public static PlantBlock create(final RegistryPlant plant, ExtendedProperties properties) {
        return new PlantBlock(properties){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }
        };
    }

    protected PlantBlock(ExtendedProperties properties) {
        super(properties);
        BlockState stateDefinition = (BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0));
        IntegerProperty stageProperty = this.getPlant().getStageProperty();
        if (stageProperty != null) {
            stateDefinition = (BlockState)stateDefinition.m_61124_((Property)stageProperty, (Comparable)Integer.valueOf(0));
        }
        this.m_49959_(stateDefinition);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return PLANT_SHAPE;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (random.nextDouble() < (Double)TFCConfig.SERVER.plantGrowthChance.get()) {
            state = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(Math.min((Integer)state.m_61143_((Property)AGE) + 1, 3)));
        }
        level.m_46597_(pos, this.updateStateWithCurrentMonth(state));
    }

    public abstract RegistryPlant getPlant();

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.updateStateWithCurrentMonth(this.m_49966_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.getPlant().getStageProperty() != null) {
            builder.m_61104_(new Property[]{this.getPlant().getStageProperty()});
        }
        builder.m_61104_(new Property[]{AGE});
    }

    protected BlockState updateStateWithCurrentMonth(BlockState state) {
        return this.getPlant().getStageProperty() != null ? (BlockState)state.m_61124_((Property)this.getPlant().getStageProperty(), (Comparable)Integer.valueOf(this.getPlant().stageFor(Calendars.SERVER.getCalendarMonthOfYear()))) : state;
    }
}

