/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant;

import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.plant.ITallPlant;
import net.dries007.tfc.common.blocks.plant.TFCTallGrassBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryPlant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class TFCCactusBlock
extends TFCTallGrassBlock {
    protected static final VoxelShape COLLISION_SHAPE = TFCCactusBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    protected static final VoxelShape OUTLINE_SHAPE = TFCCactusBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public static TFCCactusBlock create(final RegistryPlant plant, ExtendedProperties properties) {
        return new TFCCactusBlock(properties){

            @Override
            public RegistryPlant getPlant() {
                return plant;
            }
        };
    }

    protected TFCCactusBlock(ExtendedProperties properties) {
        super(properties);
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            mutable.m_122159_((Vec3i)pos, direction);
            BlockState stateAt = level.m_8055_((BlockPos)mutable);
            if (!stateAt.m_60767_().m_76333_() && !Helpers.isFluid(level.m_6425_((BlockPos)mutable), (TagKey<Fluid>)FluidTags.f_13132_)) continue;
            return false;
        }
        mutable.m_122154_((Vec3i)pos, 0, -1, 0);
        BlockState belowState = level.m_8055_((BlockPos)mutable);
        if (state.m_61143_((Property)PART) == ITallPlant.Part.LOWER) {
            return Helpers.isBlock(belowState, (TagKey<Block>)BlockTags.f_13029_);
        }
        if (state.m_60734_() != this) {
            return Helpers.isBlock(belowState, (TagKey<Block>)BlockTags.f_13029_);
        }
        return belowState.m_60734_() == this && belowState.m_61143_((Property)PART) == ITallPlant.Part.LOWER;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return OUTLINE_SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    @Override
    public BlockBehaviour.OffsetType m_5858_() {
        return BlockBehaviour.OffsetType.NONE;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        entity.m_6469_(DamageSource.f_19314_, 1.0f);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

