/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.BerryBushBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.fruit.BananaPlantBlock;
import net.dries007.tfc.common.blocks.plant.fruit.BananaSaplingBlock;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeBranchBlock;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeLeavesBlock;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeSaplingBlock;
import net.dries007.tfc.common.blocks.plant.fruit.GrowingFruitTreeBranchBlock;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.plant.fruit.SpreadingBushBlock;
import net.dries007.tfc.common.blocks.plant.fruit.SpreadingCaneBlock;
import net.dries007.tfc.common.blocks.plant.fruit.StationaryBerryBushBlock;
import net.dries007.tfc.common.blocks.plant.fruit.WaterloggedBerryBushBlock;
import net.dries007.tfc.common.items.Food;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.climate.ClimateRanges;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Material;

public final class FruitBlocks {
    private static final Lifecycle[] CRANBERRY_STAGES = new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT};
    private static final Lifecycle[] BANANA_STAGES = new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT};

    public static WaterloggedBerryBushBlock createCranberry() {
        return new WaterloggedBerryBushBlock(ExtendedProperties.of(Material.f_76274_).strength(0.6f).noOcclusion().randomTicks().sound(SoundType.f_56757_).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.BERRY_BUSH).flammableLikeLeaves(), (Supplier)TFCItems.FOOD.get((Object)Food.CRANBERRY), CRANBERRY_STAGES, ClimateRanges.CRANBERRY_BUSH);
    }

    public static Block createBananaSapling() {
        return new BananaSaplingBlock(ExtendedProperties.of(Material.f_76300_).noCollission().randomTicks().strength(0.0f).sound(SoundType.f_56740_).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.TICK_COUNTER).flammableLikeLeaves(), BANANA_STAGES, (Supplier<? extends Block>)TFCBlocks.BANANA_PLANT, 6);
    }

    public static Block createBananaPlant() {
        return new BananaPlantBlock(ExtendedProperties.of(Material.f_76274_).strength(0.5f).sound(SoundType.f_56740_).randomTicks().noOcclusion().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.BERRY_BUSH).serverTicks(BerryBushBlockEntity::serverTick).flammableLikeLeaves(), (Supplier)TFCItems.FOOD.get((Object)Food.BANANA), BANANA_STAGES);
    }

    public static enum Tree {
        CHERRY(Food.CHERRY, new Lifecycle[]{Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY}),
        GREEN_APPLE(Food.GREEN_APPLE, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT}),
        LEMON(Food.LEMON, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT}),
        OLIVE(Food.OLIVE, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT}),
        ORANGE(Food.ORANGE, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT}),
        PEACH(Food.PEACH, new Lifecycle[]{Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY}),
        PLUM(Food.PLUM, new Lifecycle[]{Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT}),
        RED_APPLE(Food.RED_APPLE, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT});

        private final Food product;
        private final Lifecycle[] stages;

        private Tree(Food product, Lifecycle[] stages) {
            this.product = product;
            this.stages = stages;
        }

        public Block createSapling() {
            return new FruitTreeSaplingBlock(ExtendedProperties.of(Material.f_76300_).noCollission().randomTicks().strength(0.0f).sound(SoundType.f_56740_).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.TICK_COUNTER).flammableLikeLeaves(), (Supplier)TFCBlocks.FRUIT_TREE_GROWING_BRANCHES.get((Object)this), 8, ClimateRanges.FRUIT_TREES.get((Object)this), this.stages);
        }

        public Block createLeaves() {
            return new FruitTreeLeavesBlock(ExtendedProperties.of(Material.f_76274_).strength(0.5f).sound(SoundType.f_56740_).randomTicks().noOcclusion().blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.BERRY_BUSH).serverTicks(BerryBushBlockEntity::serverTick).flammableLikeLeaves(), (Supplier)TFCItems.FOOD.get((Object)this.product), this.stages, ClimateRanges.FRUIT_TREES.get((Object)this));
        }

        public Block createBranch() {
            return new FruitTreeBranchBlock(ExtendedProperties.of(Material.f_76320_).sound(SoundType.f_56756_).randomTicks().strength(1.0f).flammableLikeLogs(), ClimateRanges.FRUIT_TREES.get((Object)this));
        }

        public Block createGrowingBranch() {
            return new GrowingFruitTreeBranchBlock(ExtendedProperties.of(Material.f_76320_).sound(SoundType.f_56756_).randomTicks().strength(1.0f).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.TICK_COUNTER).flammableLikeLogs(), (Supplier)TFCBlocks.FRUIT_TREE_BRANCHES.get((Object)this), (Supplier)TFCBlocks.FRUIT_TREE_LEAVES.get((Object)this), ClimateRanges.FRUIT_TREES.get((Object)this));
        }
    }

    public static enum StationaryBush {
        SNOWBERRY(Food.SNOWBERRY, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT),
        BUNCHBERRY(Food.BUNCHBERRY, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT),
        GOOSEBERRY(Food.GOOSEBERRY, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT),
        CLOUDBERRY(Food.CLOUDBERRY, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT),
        STRAWBERRY(Food.STRAWBERRY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY),
        WINTERGREEN_BERRY(Food.WINTERGREEN_BERRY, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING);

        private final Food product;
        private final Lifecycle[] stages;

        private StationaryBush(Food product, Lifecycle ... stages) {
            this.product = product;
            this.stages = stages;
        }

        public Block create() {
            return new StationaryBerryBushBlock(ExtendedProperties.of(Material.f_76274_).strength(0.6f).noOcclusion().randomTicks().sound(SoundType.f_56757_).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.BERRY_BUSH).serverTicks(BerryBushBlockEntity::serverTick).flammableLikeLeaves(), (Supplier)TFCItems.FOOD.get((Object)this.product), this.stages, ClimateRanges.STATIONARY_BUSHES.get((Object)this));
        }
    }

    public static enum SpreadingBush {
        BLACKBERRY(Food.BLACKBERRY, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT}, 4),
        RASPBERRY(Food.RASPBERRY, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT}, 3),
        BLUEBERRY(Food.BLUEBERRY, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT}, 2),
        ELDERBERRY(Food.ELDERBERRY, new Lifecycle[]{Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.HEALTHY, Lifecycle.FLOWERING, Lifecycle.FLOWERING, Lifecycle.FRUITING, Lifecycle.DORMANT, Lifecycle.DORMANT, Lifecycle.DORMANT}, 3);

        private final Food product;
        private final Lifecycle[] stages;
        private final int maxHeight;

        private SpreadingBush(Food product, Lifecycle[] stages, int maxHeight) {
            this.product = product;
            this.stages = stages;
            this.maxHeight = maxHeight;
        }

        public Block createBush() {
            return new SpreadingBushBlock(ExtendedProperties.of(Material.f_76274_).strength(0.6f).noOcclusion().randomTicks().sound(SoundType.f_56757_).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.BERRY_BUSH).serverTicks(BerryBushBlockEntity::serverTick).flammableLikeLeaves(), (Supplier)TFCItems.FOOD.get((Object)this.product), this.stages, (Supplier)TFCBlocks.SPREADING_CANES.get((Object)this), this.maxHeight, ClimateRanges.SPREADING_BUSHES.get((Object)this));
        }

        public Block createCane() {
            return new SpreadingCaneBlock(ExtendedProperties.of(Material.f_76274_).strength(0.6f).noOcclusion().randomTicks().sound(SoundType.f_56757_).blockEntity((Supplier<? extends BlockEntityType<?>>)TFCBlockEntities.BERRY_BUSH).serverTicks(BerryBushBlockEntity::serverTick).flammableLikeLeaves(), (Supplier)TFCItems.FOOD.get((Object)this.product), this.stages, (Supplier)TFCBlocks.SPREADING_BUSHES.get((Object)this), this.maxHeight, ClimateRanges.SPREADING_BUSHES.get((Object)this));
        }
    }
}

