/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeLeavesBlock;
import net.dries007.tfc.common.blocks.plant.fruit.FruitTreeSaplingBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class FruitTreeBranchBlock
extends PipeBlock
implements IForgeBlockExtension,
HoeOverlayBlock {
    public static final IntegerProperty STAGE = TFCBlockStateProperties.STAGE_3;
    private final ExtendedProperties properties;
    private final Supplier<ClimateRange> climateRange;

    public FruitTreeBranchBlock(ExtendedProperties properties, Supplier<ClimateRange> climateRange) {
        super(0.25f, properties.properties());
        this.properties = properties;
        this.climateRange = climateRange;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_55148_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55149_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55150_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55151_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55152_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_55153_, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getStateForPlacement((BlockGetter)context.m_43725_(), context.m_8083_());
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, List<Component> text, boolean isDebug) {
        ClimateRange range = this.climateRange.get();
        text.add(FarmlandBlock.getHydrationTooltip((LevelAccessor)level, pos, range, false, FruitTreeLeavesBlock.getHydration(level, pos)));
        text.add(FarmlandBlock.getTemperatureTooltip(level, pos, range, false));
        if (FruitTreeSaplingBlock.maySplice(level, pos.m_7494_(), level.m_8055_(pos.m_7494_()))) {
            text.add((Component)Helpers.translatable("tfc.tooltip.fruit_tree.sapling_splice"));
        }
        this.addExtraInfo(text);
    }

    public void addExtraInfo(List<Component> text) {
        text.add((Component)Helpers.translatable("tfc.tooltip.fruit_tree.done_growing"));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_55148_, f_55149_, f_55150_, f_55151_, f_55152_, f_55153_, STAGE});
    }

    public BlockState getStateForPlacement(BlockGetter level, BlockPos pos) {
        Block downBlock = level.m_8055_(pos.m_7495_()).m_60734_();
        Block upBlock = level.m_8055_(pos.m_7494_()).m_60734_();
        Block northBlock = level.m_8055_(pos.m_142127_()).m_60734_();
        Block eastBlock = level.m_8055_(pos.m_142126_()).m_60734_();
        Block southBlock = level.m_8055_(pos.m_142128_()).m_60734_();
        Block westBlock = level.m_8055_(pos.m_142125_()).m_60734_();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_55153_, (Comparable)Boolean.valueOf(Helpers.isBlock(downBlock, TFCTags.Blocks.FRUIT_TREE_BRANCH) || Helpers.isBlock(downBlock, TFCTags.Blocks.BUSH_PLANTABLE_ON)))).m_61124_((Property)f_55152_, (Comparable)Boolean.valueOf(Helpers.isBlock(upBlock, TFCTags.Blocks.FRUIT_TREE_BRANCH) || Helpers.isBlock(upBlock, TFCTags.Blocks.FRUIT_TREE_SAPLING)))).m_61124_((Property)f_55148_, (Comparable)Boolean.valueOf(Helpers.isBlock(northBlock, TFCTags.Blocks.FRUIT_TREE_BRANCH)))).m_61124_((Property)f_55149_, (Comparable)Boolean.valueOf(Helpers.isBlock(eastBlock, TFCTags.Blocks.FRUIT_TREE_BRANCH)))).m_61124_((Property)f_55150_, (Comparable)Boolean.valueOf(Helpers.isBlock(southBlock, TFCTags.Blocks.FRUIT_TREE_BRANCH)))).m_61124_((Property)f_55151_, (Comparable)Boolean.valueOf(Helpers.isBlock(westBlock, TFCTags.Blocks.FRUIT_TREE_BRANCH)));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!state.m_60710_((LevelReader)level, currentPos)) {
            level.m_186460_(currentPos, (Block)this, 1);
            return state;
        }
        boolean flag = Helpers.isBlock(facingState, TFCTags.Blocks.FRUIT_TREE_BRANCH) || facing == Direction.DOWN && Helpers.isBlock(facingState, TFCTags.Blocks.BUSH_PLANTABLE_ON) || facing == Direction.UP && Helpers.isBlock(facingState, TFCTags.Blocks.FRUIT_TREE_SAPLING);
        return (BlockState)state.m_61124_((Property)f_55154_.get(facing), (Comparable)Boolean.valueOf(flag));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState belowState = level.m_8055_(pos.m_7495_());
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            Block below;
            BlockPos relativePos = pos.m_142300_(direction);
            if (!Helpers.isBlock(level.m_8055_(relativePos).m_60734_(), TFCTags.Blocks.FRUIT_TREE_BRANCH) || !Helpers.isBlock(below = level.m_8055_(relativePos.m_7495_()).m_60734_(), TFCTags.Blocks.FRUIT_TREE_BRANCH) && !Helpers.isBlock(below, TFCTags.Blocks.BUSH_PLANTABLE_ON)) continue;
            return true;
        }
        Block block = belowState.m_60734_();
        return Helpers.isBlock(block, TFCTags.Blocks.FRUIT_TREE_BRANCH) || Helpers.isBlock(block, TFCTags.Blocks.BUSH_PLANTABLE_ON);
    }

    public void m_7458_(BlockState state, ServerLevel level, BlockPos pos, Random rand) {
        if (!state.m_60710_((LevelReader)level, pos) && !level.m_5776_()) {
            level.m_46961_(pos, true);
        }
    }

    @Override
    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }
}

