/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.fruit.IBushBlock;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.plant.fruit.SpreadingBushBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class SpreadingCaneBlock
extends SpreadingBushBlock
implements IBushBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape CANE_EAST = Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)8.0, (double)12.0, (double)16.0);
    private static final VoxelShape CANE_WEST = Block.m_49796_((double)8.0, (double)3.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape CANE_SOUTH = Block.m_49796_((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)12.0, (double)8.0);
    private static final VoxelShape CANE_NORTH = Block.m_49796_((double)0.0, (double)3.0, (double)8.0, (double)16.0, (double)12.0, (double)16.0);

    public SpreadingCaneBlock(ExtendedProperties properties, Supplier<? extends Item> productItem, Lifecycle[] stages, Supplier<? extends Block> companion, int maxHeight, Supplier<ClimateRange> climateRange) {
        super(properties, productItem, stages, companion, maxHeight, climateRange);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> CANE_NORTH;
            case Direction.WEST -> CANE_WEST;
            case Direction.SOUTH -> CANE_SOUTH;
            default -> CANE_EAST;
        };
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{FACING}));
    }

    @Override
    protected BlockState getDeadState(BlockState state) {
        return (BlockState)((BlockState)((Block)TFCBlocks.DEAD_CANE.get()).m_49966_().m_61124_((Property)STAGE, (Comparable)((Integer)state.m_61143_((Property)STAGE)))).m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    protected BlockState growAndPropagate(Level level, BlockPos pos, Random random, BlockState state) {
        if (!((Lifecycle)((Object)state.m_61143_((Property)LIFECYCLE))).active()) {
            return state;
        }
        int prevStage = (Integer)state.m_61143_((Property)STAGE);
        if (prevStage < 2) {
            return (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(prevStage + 1));
        }
        BlockState placeState = (BlockState)((BlockState)((Block)this.companion.get()).m_49966_().m_61124_((Property)STAGE, (Comparable)Integer.valueOf(1))).m_61124_((Property)LIFECYCLE, (Comparable)((Object)((Lifecycle)((Object)state.m_61143_((Property)LIFECYCLE)))));
        if (placeState.m_60710_((LevelReader)level, pos)) {
            level.m_46597_(pos, placeState);
        }
        return state;
    }

    @Override
    protected boolean mayDie(Level level, BlockPos pos, BlockState state, int monthsSpentDying) {
        BlockState parent = level.m_8055_(pos.m_142300_(((Direction)state.m_61143_((Property)FACING)).m_122424_()));
        if (Helpers.isBlock(parent, TFCTags.Blocks.SPREADING_BUSH)) {
            return false;
        }
        return super.mayDie(level, pos, state, monthsSpentDying);
    }

    @Override
    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    @Override
    @NotNull
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return Helpers.isBlock(level.m_8055_(pos.m_142300_(((Direction)state.m_61143_((Property)FACING)).m_122424_())), TFCTags.Blocks.ANY_SPREADING_BUSH);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)this.companion.get());
    }
}

