/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.common.blocks.plant.fruit;

import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.plant.fruit.IBushBlock;
import net.dries007.tfc.common.blocks.plant.fruit.Lifecycle;
import net.dries007.tfc.common.blocks.plant.fruit.SeasonalPlantBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.HoeOverlayBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.dries007.tfc.util.climate.Climate;
import net.dries007.tfc.util.climate.ClimateRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StationaryBerryBushBlock
extends SeasonalPlantBlock
implements HoeOverlayBlock,
IBushBlock {
    private static final VoxelShape HALF_PLANT = StationaryBerryBushBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
    private static final int MONTHS_SPENT_DORMANT_TO_DIE = 4;

    public StationaryBerryBushBlock(ExtendedProperties properties, Supplier<? extends Item> productItem, Lifecycle[] lifecycle, Supplier<ClimateRange> climateRange) {
        super(properties, climateRange, productItem, lifecycle);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)LIFECYCLE, (Comparable)((Object)(this.getLifecycleForCurrentMonth().active() ? Lifecycle.HEALTHY : Lifecycle.DORMANT)));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return HALF_PLANT;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        IBushBlock.randomTick(this, state, level, pos, random);
    }

    @Override
    public void addHoeOverlayInfo(Level level, BlockPos pos, BlockState state, List<Component> text, boolean isDebug) {
        BlockPos sourcePos = pos.m_7495_();
        ClimateRange range = (ClimateRange)this.climateRange.get();
        text.add(FarmlandBlock.getHydrationTooltip((LevelAccessor)level, sourcePos, range, false));
        text.add(FarmlandBlock.getTemperatureTooltip(level, sourcePos, range, false));
    }

    @Override
    public void onUpdate(Level level, BlockPos pos, BlockState state) {
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.BERRY_BUSH.get()).ifPresent(bush -> {
            Lifecycle expectedLifecycle;
            Lifecycle currentLifecycle = (Lifecycle)((Object)((Object)state.m_61143_((Property)LIFECYCLE)));
            if (!StationaryBerryBushBlock.checkAndSetDormant(level, pos, state, currentLifecycle, expectedLifecycle = this.getLifecycleForCurrentMonth())) {
                long deltaTicks = Math.min(bush.getTicksSinceBushUpdate(), Calendars.SERVER.getCalendarTicksInYear());
                long currentCalendarTick = Calendars.SERVER.getCalendarTicks();
                long nextCalendarTick = currentCalendarTick - deltaTicks;
                BlockPos sourcePos = pos.m_7495_();
                ClimateRange range = (ClimateRange)this.climateRange.get();
                int hydration = FarmlandBlock.getHydration((LevelAccessor)level, sourcePos);
                int monthsSpentDying = 0;
                do {
                    nextCalendarTick = Math.min(nextCalendarTick + Calendars.SERVER.getCalendarTicksInMonth(), currentCalendarTick);
                    float temperatureAtNextTick = Climate.getTemperature(level, pos, nextCalendarTick, Calendars.SERVER.getCalendarDaysInMonth());
                    Lifecycle lifecycleAtNextTick = this.getLifecycleForMonth(ICalendar.getMonthOfYear(nextCalendarTick, Calendars.SERVER.getCalendarDaysInMonth()));
                    currentLifecycle = range.checkBoth(hydration, temperatureAtNextTick, false) ? currentLifecycle.advanceTowards(lifecycleAtNextTick) : Lifecycle.DORMANT;
                    if (lifecycleAtNextTick != Lifecycle.DORMANT && currentLifecycle == Lifecycle.DORMANT) {
                        ++monthsSpentDying;
                        continue;
                    }
                    monthsSpentDying = 0;
                } while (nextCalendarTick < currentCalendarTick);
                BlockState newState = this.mayDie(level, pos, state, monthsSpentDying) ? this.getDeadState(state) : this.growAndPropagate(level, pos, level.m_5822_(), (BlockState)state.m_61124_((Property)LIFECYCLE, (Comparable)((Object)currentLifecycle)));
                if (state != newState) {
                    level.m_7731_(pos, newState, 3);
                }
            }
        });
    }

    protected boolean mayDie(Level level, BlockPos pos, BlockState state, int monthsSpentDying) {
        return monthsSpentDying >= 4;
    }

    protected BlockState getNewState(Level level, BlockPos pos) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)STAGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)LIFECYCLE, (Comparable)((Object)Lifecycle.HEALTHY));
    }

    protected boolean canPlaceNewBushAt(Level level, BlockPos pos, BlockState placementState) {
        return level.m_46859_(pos) && placementState.m_60710_((LevelReader)level, pos);
    }

    protected BlockState getDeadState(BlockState state) {
        return (BlockState)((Block)TFCBlocks.DEAD_BERRY_BUSH.get()).m_49966_().m_61124_((Property)STAGE, (Comparable)((Integer)state.m_61143_((Property)STAGE)));
    }

    protected BlockState growAndPropagate(Level level, BlockPos pos, Random random, BlockState state) {
        if (((Lifecycle)((Object)state.m_61143_((Property)LIFECYCLE))).active()) {
            return state;
        }
        BlockState newState = (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(Math.min(2, (Integer)state.m_61143_((Property)STAGE) + 1)));
        if ((Integer)newState.m_61143_((Property)STAGE) != 2) {
            return newState;
        }
        int count = 0;
        for (BlockPos target : BlockPos.m_121940_((BlockPos)pos.m_142082_(-2, -1, -2), (BlockPos)pos.m_142082_(2, 1, 2))) {
            if (level.m_8055_(target).m_60734_() != this || ++count <= 3) continue;
            return newState;
        }
        BlockPos.MutableBlockPos cursor = pos.m_122032_();
        for (int tries = 0; tries < 6; ++tries) {
            cursor.m_122154_((Vec3i)pos, Helpers.triangle(random, 3), Helpers.triangle(random, 2), Helpers.triangle(random, 3));
            BlockState placementState = this.getNewState(level, (BlockPos)cursor);
            if (!this.canPlaceNewBushAt(level, pos, placementState)) continue;
            level.m_46597_((BlockPos)cursor, placementState);
            return newState;
        }
        return newState;
    }
}

